# UCLIBC_BASE should be the latest released revision of uclibc (that way
# the config files will typically be correct!)  uclibc-cvs takes precedence
# over uclibc-${UCLIBC_BASE}, if a config file in uclibc-cvs is out of date
# try removing it
#
# UCLIBC_BASE can be set in a distro file, but whether this works depends
# on whether the base patches apply to the selected (SRCDATE) svn release.
#
UCLIBC_BASE ?= "0.9.29"
PR = "r9"

require uclibc.inc

PROVIDES += "virtual/${TARGET_PREFIX}libc-for-gcc"

SRC_URI += "file://uClibc.machine file://uClibc.distro \
	    file://errno_values.h.patch;patch=1 \
	    file://termios.h.patch;patch=1 \
            file://uClibc-0.9.29-001-fix-mmap.patch;patch=1 \
	    file://uClibc-0.9.29-conditional-sched_affinity.patch;patch=1 \
	    file://uClibc-0.9.29-fix-gethostent_r-failure-retval.patch;patch=1 \
	    file://uClibc-0.9.29-fix-internal_function-definition.patch;patch=1 \
	    file://uClibc-0.9.29-rm-whitespace.patch;patch=1 \
	    file://arm_fix_alignment.patch;patch=1 \
	    "

# mmap-unsigned-shift_bugid1303.patch
# http://uclibc.org/lists/uclibc-cvs/2007-May/011360.html;patch=1"

#recent versions uclibc require real kernel headers
PACKAGE_ARCH = "${MACHINE_ARCH}"

#as stated above, uclibc needs real kernel-headers
#however: we can't depend on virtual/kernel when nptl hits due to depends deadlocking ....
KERNEL_SOURCE = "${CROSS_DIR}/${TARGET_SYS}"

SRC_URI += "http://www.uclibc.org/downloads/uClibc-${PV}.tar.bz2"

S = "${WORKDIR}/uClibc-${UCLIBC_BASE}"

LEAD_SONAME = "libc.so"

