DESCRIPTION  = "Sat Solver"
HOMEPAGE = "http://en.opensue.org/Portal:Libzypp"

LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://LICENSE.BSD;md5=62272bd11c97396d4aaf1c41bc11f7d8"

DEPENDS = "libcheck rpm zlib expat db"

PV = "0.0-git${SRCPV}"
PR = "r9"

SRC_URI = "git://gitorious.org/opensuse/sat-solver.git;protocol=git \
           file://sat-solver_rpm5.patch \
           file://sat-solver_obsolete.patch \
           file://cmake.patch \
           file://db5.patch \
           file://sat-solver_core.patch \
          "

S = "${WORKDIR}/git"

EXTRA_OECMAKE += "-DLIB=lib -DRPM5=RPM5 -DOE_CORE=OE_CORE"

inherit cmake pkgconfig

PACKAGE_ARCH = "${MACHINE_ARCH}"

do_archgen () {
	# We need to dynamically generate our arch file based on the machine
	# configuration

	INSTALL_PLATFORM_ARCHS=""
	for each_arch in ${PACKAGE_ARCHS} ; do
		case "$each_arch" in
			all | any | noarch)
				continue;;
		esac
		INSTALL_PLATFORM_ARCHS="$each_arch $INSTALL_PLATFORM_ARCHS"
	done

	echo "/* Automatically generated by the sat-solver recipe */" > src/core-arch.h
	echo "const char *archpolicies[] = {" >> src/core-arch.h

        set -- $INSTALL_PLATFORM_ARCHS

        save_IFS=$IFS
        IFS=:
        while [ $# -gt 0 ]; do echo "  \"$1\",	"\""$*"\", >> src/core-arch.h ; shift; done
        IFS=$save_IFS

	echo "  0" >> src/core-arch.h
	echo "};" >> src/core-arch.h
}

addtask archgen before do_configure after do_patch
