#!/usr/bin/env python3

# What steps will reproduce the problem?
########################################
#
# 1. Create package 'a', which includes conflict_file.
# 2. Create package 'b', which DEPENDS on 'c'.
# 3. Create package 'c', which includes conflict_file.
# 4. Install 'a'
# 5. Install 'b'
#
# What is the expected output? What do you see instead?
########################################
# Expected:  Packages 'b' and 'c' should not be installed.
#
# Observed:  Opkg correctly reports an error and non-zero exit status after
# attempting to install 'b'.  However, 'b' is marked as installed despite its
# dependency 'c' not being installed.
#

import os
import opk, cfg, opkgcl

opk.regress_init()

with open('conflict_file', 'w') as f:
    f.write('Test')

a = opk.Opk(Package="a")
a.write(data_files=['conflict_file'])
b = opk.Opk(Package="b", Depends="c")
b.write()
c = opk.Opk(Package="c")
c.write(data_files=['conflict_file'])

o = opk.OpkGroup()
o.opk_list.extend([a, b, c])
o.write_list()

opkgcl.update()

opkgcl.install("a")
if not opkgcl.is_installed("a"):
    opk.fail("Package 'a' failed to install")

opkgcl.install("b")
if opkgcl.is_installed("c"):
    opk.fail("Package 'c' installed despite conflict")
if opkgcl.is_installed("b"):
    opk.xfail("Package 'b' installed without dependency 'c'")
