#! /usr/bin/env python3
#
# Reporter: alejandro.delcastillo@ni.com
#
# What steps will reproduce the problem?
# ======================================
#
# 1.- Create package 'a', which DEPENDS on 'b'
# 2.- Create package 'b', which DEPENDS on 'c'
# 3.- Create package 'c'
# 4.- Install 'a'
#
# What is the expected output? What do you see instead?
# =====================================================
#
# The order of installation should be c -> b -> a,
# instead it is b -> c -> a.
#

import os
import opk, cfg, opkgcl

opk.regress_init()
o = opk.OpkGroup()

f = open('test_file', 'w')
f.close()
a = opk.Opk(Package='a', Provides='v', Replaces='v', Conflicts='v')
a.prerm = '\n'.join([
    '#!/bin/sh',
    'echo a prerm',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
a.postrm = '\n'.join([
    '#!/bin/sh',
    'echo a postrm',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
a.preinst = '\n'.join([
    '#!/bin/sh',
    'echo a preinst',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
a.postinst = '\n'.join([
    '#!/bin/sh',
    'echo a postinst',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
a.write(data_files=['test_file'])

# Package 'b' has a preinst script that relies
# on a file installed by package 'c'
b = opk.Opk(Package='b', Provides='v', Replaces='v', Conflicts='v')
b.prerm = '\n'.join([
    '#!/bin/sh',
    'echo b prerm',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
b.postrm = '\n'.join([
    '#!/bin/sh',
    'echo b postrm',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
b.preinst = '\n'.join([
    '#!/bin/sh',
    'echo b preinst',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
b.postinst = '\n'.join([
    '#!/bin/sh',
    'echo b postinst',
#    'test ! -f %s/test_file' % cfg.offline_root,
#    'exit $?',
])
b.write()

o.opk_list.append(a)
o.opk_list.append(b)
o.write_list()

opkgcl.update()

os.unlink('test_file')

opkgcl.install('a')

if opkgcl.install('b') != 0:
    opk.fail("Installation of Package 'b' failed (preinst of b ran out of order)")
