#include <stdio.h>
#include <libmb/mb.h>

void dump(MBPixbufImage *image, const char* symbol)
{
  int i;
  printf("/* Image data generated by dump-image */\n");
  printf("#define %s_WIDTH %d\n", symbol, mb_pixbuf_img_get_width(image));
  printf("#define %s_HEIGHT %d\n", symbol, mb_pixbuf_img_get_height(image));
  printf("#define %s_HASALPHA %d\n", symbol, mb_pixbuf_img_has_alpha(image));
  printf("unsigned char %s[] = {\n", symbol);
  for (i = 0; i < (image->width * image->height * (3 + image->has_alpha)); ++i) {
    printf("0x%X, ", image->rgba[i]);
  }
  printf("};\n");
}


int main(int argc, char* argv[])
{
  Display *dpy;
  MBPixbuf *pb;
  MBPixbufImage *image;

  if (argc != 3) {
    fprintf(stderr, "dump-image <symbol> <filename>\n");
    return 1;
  }

  dpy = XOpenDisplay (NULL);
  pb = mb_pixbuf_new(dpy, DefaultScreen(dpy));
  image = mb_pixbuf_img_new_from_file (pb, argv[2]);
  if (image == NULL) {
    fprintf(stderr, "Could not open %s\n", argv[2]);
    return 1;
  }

  dump(image, argv[1]);
  
  mb_pixbuf_img_free (pb, image);
  XCloseDisplay (dpy);
  return 0;
}
