/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.LocalException;
import Ice.Logger;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.IndirectReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.TraceLevels;
import IceUtil.Debug;
import IceUtil.StringUtil;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String string) {
        Reference reference = this._instance.referenceFactory().create(string);
        return this.referenceToProxy(reference);
    }

    public String proxyToString(ObjectPrx objectPrx) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            return objectPrxHelperBase.__reference().toString();
        }
        return "";
    }

    public ObjectPrx propertyToProxy(String string) {
        Reference reference = this._instance.referenceFactory().createFromProperties(string);
        return this.referenceToProxy(reference);
    }

    public ObjectPrx streamToProxy(BasicStream basicStream) {
        Identity identity = new Identity();
        identity.__read(basicStream);
        Reference reference = this._instance.referenceFactory().create(identity, basicStream);
        return this.referenceToProxy(reference);
    }

    public void proxyToStream(ObjectPrx objectPrx, BasicStream basicStream) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            Reference reference = objectPrxHelperBase.__reference();
            reference.getIdentity().__write(basicStream);
            reference.streamWrite(basicStream);
        } else {
            Identity identity = new Identity();
            identity.name = "";
            identity.category = "";
            identity.__write(basicStream);
        }
    }

    public ObjectPrx referenceToProxy(Reference reference) {
        if (reference != null) {
            ObjectPrxHelperBase objectPrxHelperBase = new ObjectPrxHelperBase();
            objectPrxHelperBase.setup(reference);
            return objectPrxHelperBase;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkRetryAfterException(LocalException localException, Reference reference, int n) {
        Object object;
        Object object2;
        TraceLevels traceLevels = this._instance.traceLevels();
        Logger logger = this._instance.initializationData().logger;
        if (localException instanceof ObjectNotExistException) {
            object2 = (ObjectNotExistException)localException;
            object = reference.getLocatorInfo();
            if (object == null) {
                if (reference.getRouterInfo() == null) throw localException;
                if (!((RequestFailedException)object2).operation.equals("ice_add_proxy")) throw localException;
                if (traceLevels.retry < 1) return n;
                String string = "retrying operation call to add proxy to router\n" + localException.toString();
                logger.trace(traceLevels.retryCat, string);
                return n;
            }
            ((LocatorInfo)object).clearObjectCache((IndirectReference)reference);
        } else if (localException instanceof RequestFailedException) {
            throw localException;
        }
        if (localException instanceof MarshalException) {
            throw localException;
        }
        Debug.Assert(++n > 0);
        if (n > this._retryIntervals.length) {
            if (traceLevels.retry < 1) throw localException;
            object2 = "cannot retry operation call because retry limit has been exceeded\n" + localException.toString();
            logger.trace(traceLevels.retryCat, (String)object2);
            throw localException;
        }
        int n2 = this._retryIntervals[n - 1];
        if (traceLevels.retry >= 1) {
            object = "retrying operation call";
            if (n2 > 0) {
                object = (String)object + " in " + n2 + "ms";
            }
            object = (String)object + " because of exception\n" + localException;
            logger.trace(traceLevels.retryCat, (String)object);
        }
        if (n2 <= 0) return n;
        try {
            Thread.currentThread();
            Thread.sleep(n2);
            return n;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String string = this._instance.initializationData().properties.getPropertyWithDefault("Ice.RetryIntervals", "0");
        String[] stringArray = StringUtil.split(string.trim(), " \t\n\r");
        if (stringArray.length > 0) {
            this._retryIntervals = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                try {
                    n = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (i == 0 && n == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = n > 0 ? n : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

