/*
 * model2.c
 *
 *
 * Part of TREE-PUZZLE 5.2 (July 2004)
 *
 * (c) 2003-2004 by Heiko A. Schmidt, Korbinian Strimmer, and Arndt von Haeseler
 * (c) 1999-2003 by Heiko A. Schmidt, Korbinian Strimmer,
 *                  M. Vingron, and Arndt von Haeseler
 * (c) 1995-1999 by Korbinian Strimmer and Arndt von Haeseler
 *
 * All parts of the source except where indicated are distributed under
 * the GNU public licence.  See http://www.opensource.org for details.
 *
 * ($Id$)
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


/* definitions */
#define EXTERN extern

/* prototypes */
#include <stdio.h>
#include "util.h"
#include "ml.h"

/* IUPAC AA Codings:
 *
 * ordered by 1-letter-code:
 *
 * A   C   D   E   F   G   H   I   K   L   M   N   P   Q   R   S   T   V   W   Y    -/others
 * Ala Cys Asp Glu Phe Gly His Ile Lys Leu Met Asn Pro Gln Arg Ser Thr Val Trp Tyr
 *   0   4   3   6  13   7   8   9  11  10  12   2  14   5   1  15  16  19  17  18  20
 *
 *
 * ordered by 3-letter-code/index:
 *
 *   0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20
 * A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V  -/others
 * Ala Arg Asn Asp Cys Gln Glu Gly His Ile Leu Lys Met Phe Pro Ser Thr Trp Tyr Val
 *
 */


void jttdata(dmatrix q, double *f)
{
	/*
	 * JTT model for amino acid evolution
	 * D.T. Jones, W.R. Taylor, and J.M. Thornton
	 * "The rapid generation of mutation data matrices from protein sequences"
	 * CABIOS  vol. 8 no. 3 1992 pp. 275-282
	 */

	q[0][1]=3.1628651460584e+00; 	q[0][2]=3.2804935927860e+00;
	q[0][3]=4.8477237048666e+00; 	q[0][4]=3.4612244897959e+00;
	q[0][5]=3.3130910900946e+00; 	q[0][6]=6.3199473337722e+00;
	q[0][7]=1.0440154440154e+01; 	q[0][8]=1.3061224489796e+00;
	q[0][9]=2.1726844583987e+00; 	q[0][10]=1.8443597219107e+00;
	q[0][11]=2.2137668626773e+00; 	q[0][12]=2.7210884353741e+00;
	q[0][13]=8.3265306122449e-01; 	q[0][14]=1.1537414965986e+01;
	q[0][15]=2.2838213546288e+01; 	q[0][16]=2.7007955724663e+01;
	q[0][17]=5.1311953352770e-01; 	q[0][18]=8.3673469387755e-01;
	q[0][19]=1.7474335188621e+01; 
	
	q[1][2]=2.6598918637222e+00; 	q[1][3]=9.1014867485456e-01;
	q[1][4]=6.1624649859944e+00; 	q[1][5]=1.8036482885837e+01;
	q[1][6]=1.8924731182796e+00; 	q[1][7]=8.1810886516769e+00;
	q[1][8]=1.9119717452198e+01; 	q[1][9]=1.4410687351864e+00;
	q[1][10]=2.2211961707760e+00; 	q[1][11]=3.9239234676922e+01;
	q[1][12]=2.5060690943044e+00; 	q[1][13]=3.9439775910364e-01;
	q[1][14]=4.1953094963476e+00; 	q[1][15]=5.9016766126741e+00;
	q[1][16]=3.8437069743152e+00; 	q[1][17]=7.6766706682673e+00;
	q[1][18]=1.4173669467787e+00; 	q[1][19]=1.0308123249300e+00;

	q[2][3]=3.2226935854843e+01; 	q[2][4]=1.8710963455150e+00;
	q[2][5]=4.5351268130622e+00; 	q[2][6]=3.3951344979102e+00;
	q[2][7]=4.5987249708180e+00; 	q[2][8]=2.3693774375271e+01;
	q[2][9]=2.9235880398671e+00; 	q[2][10]=8.0960899565551e-01;
	q[2][11]=1.5024269384537e+01; 	q[2][12]=1.9003322259136e+00;
	q[2][13]=4.3853820598007e-01; 	q[2][14]=7.1083317047749e-01;
	q[2][15]=2.9456208772690e+01; 	q[2][16]=1.3735908553410e+01;
	q[2][17]=1.6706217370669e-01; 	q[2][18]=4.1661129568106e+00;
	q[2][19]=9.7452934662237e-01; 
	
	q[3][4]=6.2857142857143e-01; 	q[3][5]=3.0662020905923e+00;
	q[3][6]=4.5450549450549e+01; 	q[3][7]=7.5402435402435e+00;
	q[3][8]=6.0544672718586e+00; 	q[3][9]=6.8808114961961e-01;
	q[3][10]=3.6130902064968e-01; 	q[3][11]=1.6718197057180e+00;
	q[3][12]=1.0879120879121e+00; 	q[3][13]=1.9340659340659e-01;
	q[3][14]=7.3949579831933e-01; 	q[3][15]=3.4196528109572e+00;
	q[3][16]=2.4749487800335e+00; 	q[3][17]=3.4536891679749e-01;
	q[3][18]=2.6895604395604e+00; 	q[3][19]=1.8608058608059e+00;

	q[4][5]=5.5191637630662e-01; 	q[4][6]=3.2442396313364e-01;
	q[4][7]=3.3297297297297e+00; 	q[4][8]=4.3726708074534e+00;
	q[4][9]=9.1868131868132e-01; 	q[4][10]=9.9466248037677e-01;
	q[4][11]=2.9830508474576e-01; 	q[4][12]=2.4095238095238e+00;
	q[4][13]=4.1485714285714e+00; 	q[4][14]=7.3949579831933e-01;
	q[4][15]=1.2862939958592e+01; 	q[4][16]=2.8125907990315e+00;
	q[4][17]=6.8244897959184e+00; 	q[4][18]=1.2885714285714e+01;
	q[4][19]=3.7714285714286e+00; 
	
	q[5][6]=2.0316061593796e+01; 	q[5][7]=1.3922214897825e+00;
	q[5][8]=3.3861536130889e+01; 	q[5][9]=4.7172339855267e-01;
	q[5][10]=4.2320327755868e+00; 	q[5][11]=1.7835941652395e+01;
	q[5][12]=2.6573751451800e+00; 	q[5][13]=2.7595818815331e-01;
	q[5][14]=9.4992143198743e+00; 	q[5][15]=3.2350653941322e+00;
	q[5][16]=3.0973838067678e+00; 	q[5][17]=1.0512692882031e+00;
	q[5][18]=1.5331010452962e+00; 	q[5][19]=1.0778164924506e+00;

	q[6][7]=6.6857641051189e+00; 	q[6][8]=1.4458024443999e+00;
	q[6][9]=6.7068415455512e-01; 	q[6][10]=5.7932850559579e-01;
	q[6][11]=1.0365070686558e+01; 	q[6][12]=1.0138248847926e+00;
	q[6][13]=2.6359447004608e-01; 	q[6][14]=1.1291226167887e+00;
	q[6][15]=1.8337006611901e+00; 	q[6][16]=1.9520424900414e+00;
	q[6][17]=6.9519420671494e-01; 	q[6][18]=3.8018433179723e-01;
	q[6][19]=2.7772657450077e+00; 
	
	q[7][8]=1.2113479939567e+00; 	q[7][9]=3.2670032670033e-01;
	q[7][10]=4.1817641817642e-01; 	q[7][11]=1.6354950592239e+00;
	q[7][12]=7.6447876447876e-01; 	q[7][13]=3.0579150579151e-01;
	q[7][14]=1.2391551215081e+00; 	q[7][15]=1.1138492529797e+01;
	q[7][16]=1.8888816176952e+00; 	q[7][17]=3.3491450634308e+00;
	q[7][18]=3.1853281853282e-01; 	q[7][19]=2.8416988416988e+00;

	q[8][9]=1.0931677018634e+00; 	q[8][10]=3.2194389461470e+00;
	q[8][11]=3.1498052426571e+00; 	q[8][12]=1.9130434782609e+00;
	q[8][13]=2.7329192546584e+00; 	q[8][14]=6.7304834977469e+00;
	q[8][15]=4.3726708074534e+00; 	q[8][16]=2.8162964522581e+00;
	q[8][17]=7.8083407275954e-01; 	q[8][18]=3.5118012422360e+01;
	q[8][19]=7.2877846790890e-01; 
	
	q[9][10]=1.4069798333535e+01; 	q[9][11]=1.2292791953809e+00;
	q[9][12]=2.8366300366300e+01; 	q[9][13]=4.7384615384615e+00;
	q[9][14]=5.8780435251023e-01; 	q[9][15]=2.4105749323141e+00;
	q[9][16]=1.5243062022723e+01; 	q[9][17]=8.2888540031397e-01;
	q[9][18]=1.8434065934066e+00; 	q[9][19]=5.7699633699634e+01;

	q[10][11]=8.8039805231089e-01; 	q[10][12]=2.2425954997384e+01;
	q[10][13]=1.5099529042386e+01; 	q[10][14]=6.2626896912611e+00;
	q[10][15]=3.4917298022888e+00; 	q[10][16]=1.6109411169944e+00;
	q[10][17]=3.2366001345593e+00; 	q[10][18]=1.4505494505495e+00;
	q[10][19]=1.0557823129252e+01; 
	
	q[11][12]=3.6577885391445e+00; 	q[11][13]=1.4915254237288e-01;
	q[11][14]=1.2868062479229e+00; 	q[11][15]=2.8162964522581e+00;
	q[11][16]=5.7494151926786e+00; 	q[11][17]=5.4790729851263e-01;
	q[11][18]=5.3268765133172e-01; 	q[11][19]=7.4899112187248e-01;

	q[12][13]=2.5666666666667e+00; 	q[12][14]=9.4491129785247e-01;
	q[12][15]=1.6397515527950e+00; 	q[12][16]=1.2180790960452e+01;
	q[12][17]=1.1972789115646e+00; 	q[12][18]=1.1130952380952e+00;
	q[12][19]=1.7746031746032e+01; 
	
	q[13][14]=8.8739495798319e-01; 	q[13][15]=5.6298136645963e+00;
	q[13][16]=8.3099273607748e-01; 	q[13][17]=3.3224489795918e+00;
	q[13][18]=3.3392857142857e+01; 	q[13][19]=3.6000000000000e+00;

	q[14][15]=1.6261762676085e+01; 	q[14][16]=6.8852490148602e+00;
	q[14][17]=4.2256902761104e-01; 	q[14][18]=6.7787114845938e-01;
	q[14][19]=1.2549019607843e+00; 
	
	q[15][16]=2.7891216619293e+01; 	q[15][17]=1.8740017746229e+00;
	q[15][18]=3.7349896480331e+00; 	q[15][19]=2.4182194616977e+00;

	q[16][17]=4.8702870978900e-01; 	q[16][18]=1.1985472154964e+00;
	q[16][19]=6.7925746569814e+00; 
	
	q[17][18]=4.6020408163265e+00; 	q[17][19]=1.4693877551020e+00;

	q[18][19]=1.0000000000000e+00; 


	f[0] = 0.077; f[1] = 0.051; f[2] = 0.043; f[3] = 0.052;
	f[4] = 0.02; f[5] = 0.041; f[6] = 0.062; f[7] = 0.074;
	f[8] = 0.023; f[9] = 0.052; f[10] = 0.091; f[11] = 0.059;
	f[12] = 0.024; f[13] = 0.04; f[14] = 0.051; f[15] = 0.069;
	f[16] = 0.059; f[17] = 0.014; f[18] = 0.032; f[19] = 0.066;
} /* jttdata */

void dyhfdata(dmatrix q, double *f)
{
	/*
	 * Dayhoff model for amino acid evolution
	 * Dayhoff, M.O., Schwartz, R.M., Orcutt, B.C. (1978)
	 * "A model of evolutionary change in proteins."
	 * Dayhoff, M.O. (ed.) Atlas of Protein Sequence Structur., Vol5, Suppl. 3,
	 * National Biomedical Research Foundation, Washington DC, pp. 345-352.
	 */

	q[0][1]=9.6472567159749e-01; 	q[0][2]=3.5927991886410e+00;
	q[0][3]=4.3200552414656e+00; 	q[0][4]=1.3184584178499e+00;
	q[0][5]=3.2267534963169e+00; 	q[0][6]=7.0141987829615e+00;
	q[0][7]=8.5773867857875e+00; 	q[0][8]=8.1434196396611e-01;
	q[0][9]=2.3518447453539e+00; 	q[0][10]=1.4735711728911e+00;
	q[0][11]=9.3940162271805e-01; 	q[0][12]=2.5490196078431e+00;
	q[0][13]=6.5922920892495e-01; 	q[0][14]=8.9189834148670e+00;
	q[0][15]=1.4540712836859e+01; 	q[0][16]=1.3411904595370e+01;
	q[0][17]=3.8517964118027e-02; 	q[0][18]=8.7897227856660e-01;
	q[0][19]=7.4036511156187e+00; 
	
	q[1][2]=1.1890243902439e+00; 	q[1][3]=5.9525626545377e-02;
	q[1][4]=8.4778922655537e-01; 	q[1][5]=8.8348561504191e+00;
	q[1][6]=5.5954088952654e-02; 	q[1][7]=3.1434881434075e-01;
	q[1][8]=8.4753987678285e+00; 	q[1][9]=2.2684090115941e+00;
	q[1][10]=5.5954088952654e-01; 	q[1][11]=1.6681312769010e+01;
	q[1][12]=3.1707317073171e+00; 	q[1][13]=4.8959827833572e-01;
	q[1][14]=3.6754156468900e+00; 	q[1][15]=5.4755072760812e+00;
	q[1][16]=9.6472567159749e-01; 	q[1][17]=7.5538020086083e+00;
	q[1][18]=2.7977044476327e-01; 	q[1][19]=8.6083213773314e-01;

	q[2][3]=3.2459324155194e+01; 	q[2][4]=7.3852625416383e-02;
	q[2][5]=3.7732198142415e+00; 	q[2][6]=5.3911764705882e+00;
	q[2][7]=5.0264375413087e+00; 	q[2][8]=1.9061418685121e+01;
	q[2][9]=2.7901430842607e+00; 	q[2][10]=1.2482698961938e+00;
	q[2][11]=1.1542279411765e+01; 	q[2][12]=1.9117647058824e-01;
	q[2][13]=5.0183823529412e-01; 	q[2][14]=1.5181660899654e+00;
	q[2][15]=1.7697478991597e+01; 	q[2][16]=8.3557302231237e+00;
	q[2][17]=8.6029411764706e-01; 	q[2][18]=3.4411764705882e+00;
	q[2][19]=5.7352941176471e-01; 
	
	q[3][4]=2.5534152404601e-02; 	q[3][5]=4.8811013767209e+00;
	q[3][6]=4.0561952440551e+01; 	q[3][7]=4.4423506911730e+00;
	q[3][8]=3.0865788117500e+00; 	q[3][9]=8.5749078239692e-01;
	q[3][10]=2.5926985518518e-02; 	q[3][11]=2.5930851063830e+00;
	q[3][12]=1.1667143483333e-01; 	q[3][13]=1.2963492759259e-02;
	q[3][14]=4.7853935065891e-01; 	q[3][15]=3.4167709637046e+00;
	q[3][16]=2.3984722282163e+00; 	q[3][17]=3.2408731898147e-02;
	q[3][18]=8.1351689612015e-02; 	q[3][19]=6.3829787234043e-01;

	q[4][5]=2.1864264103535e-02; 	q[4][6]=1.4770525083277e-02;
	q[4][7]=3.9055458751427e-01; 	q[4][8]=1.0223340673168e+00;
	q[4][9]=1.5970515970516e+00; 	q[4][10]=3.9098448749850e-02;
	q[4][11]=8.0776309049169e-03; 	q[4][12]=1.4155086538140e-01;
	q[4][13]=8.6898395721925e-02; 	q[4][14]=6.8155604487784e-01;
	q[4][15]=5.8097784568373e+00; 	q[4][16]=5.9929928084086e-01;
	q[4][17]=3.4759358288770e-01; 	q[4][18]=3.4759358288770e+00;
	q[4][19]=1.7647058823529e+00; 
	
	q[5][6]=2.5476780185759e+01; 	q[5][7]=1.0174974779977e+00;
	q[5][8]=2.1573939173192e+01; 	q[5][9]=6.5266504894988e-01;
	q[5][10]=2.6634492806410e+00; 	q[5][11]=5.5466331269350e+00;
	q[5][12]=4.0247678018576e+00; 	q[5][13]=1.8038017885416e-02;
	q[5][14]=5.5044618466582e+00; 	q[5][15]=2.0267580716497e+00;
	q[5][16]=1.9256432155439e+00; 	q[5][17]=9.6202762055552e-02;
	q[5][18]=1.0061919504644e-01; 	q[5][19]=1.2538699690402e+00;

	q[6][7]=2.8869795109055e+00; 	q[6][8]=1.5519031141869e+00;
	q[6][9]=2.1701112877583e+00; 	q[6][10]=4.0484429065744e-01;
	q[6][11]=2.9823529411765e+00; 	q[6][12]=1.0705882352941e+00;
	q[6][13]=1.9801735189768e-02; 	q[6][14]=1.7993079584775e+00;
	q[6][15]=2.8184873949580e+00; 	q[6][16]=1.2261663286004e+00;
	q[6][17]=7.3114099162219e-02; 	q[6][18]=7.6470588235294e-01;
	q[6][19]=1.3058823529412e+00; 
	
	q[7][8]=3.7906768788150e-01; 	q[7][9]=2.3128004846840e-02;
	q[7][10]=2.5776602775942e-01; 	q[7][11]=9.6662260409782e-01;
	q[7][12]=6.0145406477198e-01; 	q[7][13]=5.4775280898876e-01;
	q[7][14]=1.2382877804129e+00; 	q[7][15]=8.2853366065527e+00;
	q[7][16]=1.1110604644803e+00; 	q[7][17]=1.2888301387971e-01;
	q[7][18]=1.7114723586662e-02; 	q[7][19]=1.9233311302049e+00;

	q[8][9]=2.7354343963341e-01; 	q[8][10]=1.5876246692449e+00;
	q[8][11]=9.6993944636678e-01; 	q[8][12]=1.2544085640577e-01;
	q[8][13]=1.6868512110727e+00; 	q[8][14]=3.3075513942601e+00;
	q[8][15]=1.2530894710826e+00; 	q[8][16]=8.1434196396611e-01;
	q[8][17]=1.0121107266436e+00; 	q[8][18]=4.4982698961938e+00;
	q[8][19]=1.5570934256055e+00; 
	
	q[9][10]=9.2275320303002e+00; 	q[9][11]=1.6663354531002e+00;
	q[9][12]=1.1780604133545e+01; 	q[9][13]=6.9753577106518e+00;
	q[9][14]=4.2551201720752e-01; 	q[9][15]=8.8575970928912e-01;
	q[9][16]=6.8951811852420e+00; 	q[9][17]=9.8802836705702e-02;
	q[9][18]=1.3434022257552e+00; 	q[9][19]=3.1526232114467e+01;

	q[10][11]=6.5787197231834e-01; 	q[10][12]=1.8622837370242e+01;
	q[10][13]=5.6340830449827e+00; 	q[10][14]=1.1377976796255e+00;
	q[10][15]=6.1690558576372e-01; 	q[10][16]=1.2098794893211e+00;
	q[10][17]=1.7543252595156e+00; 	q[10][18]=1.0346020761246e+00;
	q[10][19]=6.2906574394464e+00; 
	
	q[11][12]=8.6029411764706e+00; 	q[11][13]=6.6640454965565e-03;
	q[11][14]=1.2089100346021e+00; 	q[11][15]=3.4411764705882e+00;
	q[11][16]=4.9442190669371e+00; 	q[11][17]=3.4272233982290e-02;
	q[11][18]=4.7794117647059e-01; 	q[11][19]=3.7500000000000e-01;

	q[12][13]=3.2500000000000e+00; 	q[12][14]=5.9976931949250e-01;
	q[12][15]=2.1848739495798e+00; 	q[12][16]=3.6916835699797e+00;
	q[12][17]=1.6247577591604e-01; 	q[12][18]=1.1508700794053e-01;
	q[12][19]=9.0588235294118e+00; 
	
	q[13][14]=3.9359861591695e-01; 	q[13][15]=1.6386554621849e+00;
	q[13][16]=4.9442190669371e-01; 	q[13][17]=2.8676470588235e+00;
	q[13][18]=2.4852941176471e+01; 	q[13][19]=4.4117647058824e-01;

	q[14][15]=8.6431043005437e+00; 	q[14][16]=2.8308077795013e+00;
	q[14][17]=3.5840244687362e-02; 	q[14][18]=4.3804743506776e-02;
	q[14][19]=1.7301038062284e+00; 
	
	q[15][16]=1.9663865546218e+01; 	q[15][17]=2.7857142857143e+00;
	q[15][18]=1.2016806722689e+00; 	q[15][19]=1.0840336134454e+00;

	q[16][17]=4.2019597219666e-02; 	q[16][18]=1.5162271805274e+00;
	q[16][19]=5.6592292089249e+00; 
	
	q[17][18]=2.2941176470588e+00; 	q[17][19]=1.2654363316538e-01;

	q[18][19]=1.0000000000000e+00; 


	f[0] = 0.087; f[1] = 0.041; f[2] = 0.040; f[3] = 0.047;
	f[4] = 0.033; f[5] = 0.038; f[6] = 0.05; f[7] = 0.089;
	f[8] = 0.034; f[9] = 0.037; f[10] = 0.085; f[11] = 0.08;
	f[12] = 0.015; f[13] = 0.04; f[14] = 0.051; f[15] = 0.07;
	f[16] = 0.058; f[17] = 0.01; f[18] = 0.03; f[19] = 0.065;
} /* dyhfdata */

void mtrevdata(dmatrix q, double *f)
{	
	/*
	 * mtREV24 model of amino acid evolution
	 * (complete sequence data of mtDNA from 24 vertebrate species)
	 * Adachi, J. and Hasegawa, M. (1996)
	 *
	 * (values optained from molphy. matrix normalized such that 
	 *  sum of lower triangular is 100000 and lower limit is 10.)
	 */

	q[0][1]  =1.2199217606346e+01; 	q[0][2]  =1.4182139942122e+01;
	q[0][3]  =9.2985091873208e+00; 	q[0][4]  =3.1542792981957e+01;
	q[0][5]  =1.0025852846688e+00; 	q[0][6]  =5.1418866803338e+00;
	q[0][7]  =6.3531246495131e+01; 	q[0][8]  =7.3137132861715e+00;
	q[0][9]  =5.0782382656186e+01; 	q[0][10] =1.3399741808481e+01;
	q[0][11] =4.4021672780560e+00; 	q[0][12] =7.4673480520104e+01;
	q[0][13] =3.3513021631978e+00; 	q[0][14] =2.8582502221773e+01;
	q[0][15] =2.0413623195312e+02; 	q[0][16] =2.5301305153906e+02;
	q[0][17] =1.0000000000000e+00; 	q[0][18] =3.4084158197615e+00;
	q[0][19] =1.0266468401249e+02; 
	
	q[1][2]  =6.9661274444534e+00; 	q[1][3]  =1.0000000000000e+00;
	q[1][4]  =5.4384584796568e+01; 	q[1][5]  =1.1631134513343e+02;
	q[1][6]  =1.0000000000000e+00; 	q[1][7]  =1.2122831341194e+01;
	q[1][8]  =8.6961067087353e+01; 	q[1][9]  =1.0000000000000e+00;
	q[1][10] =8.1976829394538e+00; 	q[1][11] =7.4423215395318e+01;
	q[1][12] =1.0000000000000e+00; 	q[1][13] =2.4659158338099e+00;
	q[1][14] =1.2439947713615e+01; 	q[1][15] =3.1791814866372e+00;
	q[1][16] =1.0935327216119e+00; 	q[1][17] =1.1550775790126e+01;
	q[1][18] =1.0000000000000e+00; 	q[1][19] =4.0211417480338e+00;

	q[2][3]  =4.1809325468160e+02; 	q[2][4]  =3.1020979842967e+01;
	q[2][5]  =9.1349622725361e+01; 	q[2][6]  =3.3185663516310e+01;
	q[2][7]  =2.8052324651124e+01; 	q[2][8]  =2.6112087577885e+02;
	q[2][9]  =1.4261453863336e+01; 	q[2][10] =7.9775653461977e+00;
	q[2][11] =3.2036829276162e+02; 	q[2][12] =3.4424354918739e+01;
	q[2][13] =7.9996445145608e+00; 	q[2][14] =3.8586541461044e+01;
	q[2][15] =2.6020426225852e+02; 	q[2][16] =1.2550758780474e+02;
	q[2][17] =5.6207759736659e+00; 	q[2][18] =1.0071406219571e+02;
	q[2][19] =1.0000000000000e+00; 
	
	q[3][4]  =1.0000000000000e+00; 	q[3][5]  =2.9097352675564e+01;
	q[3][6]  =3.0713149855302e+02; 	q[3][7]  =2.9877072751897e+01;
	q[3][8]  =5.9995408885817e+01; 	q[3][9]  =2.2827096245105e+00;
	q[3][10] =1.0000000000000e+00; 	q[3][11] =1.2183938185384e+00;
	q[3][12] =1.0000000000000e+00; 	q[3][13] =2.6221929413096e+00;
	q[3][14] =7.0708004204733e+00; 	q[3][15] =3.6327934317139e+01;
	q[3][16] =1.4743408713748e+01; 	q[3][17] =1.0453246057102e+01;
	q[3][18] =1.1165627147496e+01; 	q[3][19] =1.0000000000000e+00;

	q[4][5]  =3.9599394038972e+01; 	q[4][6]  =1.0000000000000e+00;
	q[4][7]  =1.6163581056674e+01; 	q[4][8]  =7.4467985406234e+01;
	q[4][9]  =3.3018175376623e+01; 	q[4][10] =1.3500725995091e+01;
	q[4][11] =1.0000000000000e+00; 	q[4][12] =3.2504095376923e+00;
	q[4][13] =3.7264767083096e+01; 	q[4][14] =1.6454136037822e+01;
	q[4][15] =1.4581783243113e+02; 	q[4][16] =9.4720031458442e+01;
	q[4][17] =1.7684087896962e+01; 	q[4][18] =1.3409157685926e+02;
	q[4][19] =1.0000000000000e+00; 
	
	q[5][6]  =1.6503249008836e+02; 	q[5][7]  =3.5530760735494e+00;
	q[5][8]  =3.0652523140859e+02; 	q[5][9]  =4.3905393139325e+00;
	q[5][10] =2.0895470525345e+01; 	q[5][11] =2.4504076430724e+02;
	q[5][12] =2.4931300477797e+01; 	q[5][13] =1.0059428264289e+01;
	q[5][14] =7.2256314165467e+01; 	q[5][15] =2.8480937892158e+01;
	q[5][16] =4.9962974409828e+01; 	q[5][17] =1.0000000000000e+00;
	q[5][18] =2.0430790980529e+01; 	q[5][19] =9.9986289000676e+00;

	q[6][7]  =1.4884496769963e+01; 	q[6][8]  =2.5853576435567e+01;
	q[6][9]  =1.7418201388328e+00; 	q[6][10] =1.0000000000000e+00;
	q[6][11] =1.6519126809071e+02; 	q[6][12] =1.0000000000000e+00;
	q[6][13] =1.4067850525292e+00; 	q[6][14] =6.7547121641947e+00;
	q[6][15] =2.8794794140840e+01; 	q[6][16] =7.8001372062558e+00;
	q[6][17] =1.0000000000000e+00; 	q[6][18] =6.9067239183061e+00;
	q[6][19] =1.1127702362585e+01; 
	
	q[7][8]  =1.0000000000000e+00; 	q[7][9]  =3.1466649021550e+00;
	q[7][10] =1.2699794194865e+00; 	q[7][11] =1.1962111069278e+01;
	q[7][12] =1.0000000000000e+00; 	q[7][13] =1.0000000000000e+00;
	q[7][14] =1.0000000000000e+00; 	q[7][15] =6.6277950574411e+01;
	q[7][16] =5.8800079133028e+00; 	q[7][17] =5.7494182626674e+00;
	q[7][18] =1.6887657206208e+00; 	q[7][19] =1.3320553471351e+00;

	q[8][9]  =6.4536986087271e+00; 	q[8][10] =6.0472584534958e+00;
	q[8][11] =6.7197196398961e+01; 	q[8][12] =6.2977633277779e+00;
	q[8][13] =2.5347805183364e+01; 	q[8][14] =3.2089868698728e+01;
	q[8][15] =4.0766987134407e+01; 	q[8][16] =2.3570850628539e+01;
	q[8][17] =3.7286635325194e+00; 	q[8][18] =3.5270764890474e+02;
	q[8][19] =1.0000000000000e+00; 
	
	q[9][10] =1.7320653206333e+02; 	q[9][11] =1.0298655619743e+01;
	q[9][12] =2.7262244199514e+02; 	q[9][13] =4.4561065036310e+01;
	q[9][14] =1.0856482766156e+01; 	q[9][15] =2.5107659603898e+01;
	q[9][16] =1.9391167162525e+02; 	q[9][17] =1.0000000000000e+00;
	q[9][18] =1.3161329199391e+01; 	q[9][19] =6.4365086389428e+02;

	q[10][11]=7.8314019154706e+00; 	q[10][12]=2.8290920517725e+02;
	q[10][13]=1.1371735519833e+02; 	q[10][14]=2.1105885757279e+01;
	q[10][15]=3.8741359395934e+01; 	q[10][16]=6.6524559321657e+01;
	q[10][17]=1.7071378554833e+01; 	q[10][18]=2.3234516108847e+01;
	q[10][19]=4.8247261078055e+01; 
	
	q[11][12]=4.8092094826036e+01; 	q[11][13]=3.3887559483420e+00;
	q[11][14]=2.6368577564199e+01; 	q[11][15]=5.5679895711418e+01;
	q[11][16]=7.1750284708933e+01; 	q[11][17]=1.2631893872825e+01;
	q[11][18]=2.6932728996777e+01; 	q[11][19]=1.0000000000000e+00;

	q[12][13]=4.7798798034572e+01; 	q[12][14]=9.9165053447429e+00;
	q[12][15]=5.8505442466161e+01; 	q[12][16]=2.7798190504760e+02;
	q[12][17]=1.1427000119701e+01; 	q[12][18]=2.1029990530586e+01;
	q[12][19]=2.0397078683768e+02; 
	
	q[13][14]=9.1089574817139e+00; 	q[13][15]=3.3835737720574e+01;
	q[13][16]=1.7815549567056e+01; 	q[13][17]=4.1272404968214e+00;
	q[13][18]=2.4504156395152e+02; 	q[13][19]=3.3435675442163e+00;

	q[14][15]=8.9421193040709e+01; 	q[14][16]=6.7485067008375e+01;
	q[14][17]=2.2161693733113e+00; 	q[14][18]=8.5338209390745e+00;
	q[14][19]=4.3342126659660e+00; 
	
	q[15][16]=3.1432036618746e+02; 	q[15][17]=2.0305343047059e+01;
	q[15][18]=3.4167877957799e+01; 	q[15][19]=1.0000000000000e+00;

	q[16][17]=5.2559565123081e+00; 	q[16][18]=2.0382362288681e+01;
	q[16][19]=1.0765527137500e+02; 
	
	q[17][18]=1.3814733274637e+01; 	q[17][19]=2.8259139240676e+00;

	q[18][19]=1.0000000000000e+00; 


	/* amino acid frequencies */
	f[0]=0.072; f[1]=0.019; f[2]=0.039; f[3]=0.019; f[4]=0.006;
	f[5]=0.025; f[6]=0.024; f[7]=0.056; f[8]=0.028; f[9]=0.088;
	f[10]=0.168; f[11]=0.023; f[12]=0.054; f[13]=0.061; f[14]=0.054;
	f[15]=0.072; f[16]=0.086; f[17]=0.029; f[18]=0.033; f[19]=0.043;
} /* mtrevdata */

void blosum62data(dmatrix q, double *f)
{
	/*
	 * BLOSUM62 model of amino acid evolution
	 * 
	 * S. Henikoff and J. G. Henikoff.  1992.  PNAS USA 89:10915-10919.
	 * 
	 */

	q[0][1]=7.3579038969751e-01; 	q[0][2]=4.8539105546575e-01;
	q[0][3]=5.4316182089867e-01; 	q[0][4]=1.4599953104700e+00;
	q[0][5]=1.1997057046020e+00; 	q[0][6]=1.1709490427999e+00;
	q[0][7]=1.9558835749595e+00; 	q[0][8]=7.1624144499779e-01;
	q[0][9]=6.0589900368677e-01; 	q[0][10]=8.0001653051838e-01;
	q[0][11]=1.2952012667833e+00; 	q[0][12]=1.2537582666635e+00;
	q[0][13]=4.9296467974759e-01; 	q[0][14]=1.1732759009239e+00;
	q[0][15]=4.3250926870566e+00; 	q[0][16]=1.7291780194850e+00;
	q[0][17]=4.6583936772479e-01; 	q[0][18]=7.1820669758623e-01;
	q[0][19]=2.1877745220045e+00; 
	
	q[1][2]=1.2974467051337e+00; 	q[1][3]=5.0096440855513e-01;
	q[1][4]=2.2782657420895e-01; 	q[1][5]=3.0208336100636e+00;
	q[1][6]=1.3605741904203e+00; 	q[1][7]=4.1876330851753e-01;
	q[1][8]=1.4561411663360e+00; 	q[1][9]=2.3203644514174e-01;
	q[1][10]=6.2271166969249e-01; 	q[1][11]=5.4111151414889e+00;
	q[1][12]=9.8369298745695e-01; 	q[1][13]=3.7164469320875e-01;
	q[1][14]=4.4813366171831e-01; 	q[1][15]=1.1227831042096e+00;
	q[1][16]=9.1466595456337e-01; 	q[1][17]=4.2638231012175e-01;
	q[1][18]=7.2051744121611e-01; 	q[1][19]=4.3838834377202e-01;

	q[2][3]=3.1801000482161e+00; 	q[2][4]=3.9735894989702e-01;
	q[2][5]=1.8392161469920e+00; 	q[2][6]=1.2404885086396e+00;
	q[2][7]=1.3558723444845e+00; 	q[2][8]=2.4145014342081e+00;
	q[2][9]=2.8301732627800e-01; 	q[2][10]=2.1188815961519e-01;
	q[2][11]=1.5931370434574e+00; 	q[2][12]=6.4844127878707e-01;
	q[2][13]=3.5486124922252e-01; 	q[2][14]=4.9488704370192e-01;
	q[2][15]=2.9041016564560e+00; 	q[2][16]=1.8981736345332e+00;
	q[2][17]=1.9148204624678e-01; 	q[2][18]=5.3822251903674e-01;
	q[2][19]=3.1285879799342e-01; 
	
	q[3][4]=2.4083661480204e-01; 	q[3][5]=1.1909457033960e+00;
	q[3][6]=3.7616252083685e+00; 	q[3][7]=7.9847324896839e-01;
	q[3][8]=7.7814266402188e-01; 	q[3][9]=4.1855573246161e-01;
	q[3][10]=2.1813157759360e-01; 	q[3][11]=1.0324479249521e+00;
	q[3][12]=2.2262189795786e-01; 	q[3][13]=2.8173069420651e-01;
	q[3][14]=7.3062827299842e-01; 	q[3][15]=1.5827541420653e+00;
	q[3][16]=9.3418750943056e-01; 	q[3][17]=1.4534504627853e-01;
	q[3][18]=2.6142220896504e-01; 	q[3][19]=2.5812928941763e-01;

	q[4][5]=3.2980150463028e-01; 	q[4][6]=1.4074889181440e-01;
	q[4][7]=4.1820319228376e-01; 	q[4][8]=3.5405810983129e-01;
	q[4][9]=7.7489402279418e-01; 	q[4][10]=8.3184264014158e-01;
	q[4][11]=2.8507880090648e-01; 	q[4][12]=7.6768882347954e-01;
	q[4][13]=4.4133747118660e-01; 	q[4][14]=3.5600849876863e-01;
	q[4][15]=1.1971884150942e+00; 	q[4][16]=1.1198313585160e+00;
	q[4][17]=5.2766441887169e-01; 	q[4][18]=4.7023773369610e-01;
	q[4][19]=1.1163524786062e+00; 
	
	q[5][6]=5.5289191779282e+00; 	q[5][7]=6.0984630538281e-01;
	q[5][8]=2.4353411311401e+00; 	q[5][9]=2.3620245120365e-01;
	q[5][10]=5.8073709318144e-01; 	q[5][11]=3.9452776745146e+00;
	q[5][12]=2.4948960771127e+00; 	q[5][13]=1.4435695975031e-01;
	q[5][14]=8.5857057567418e-01; 	q[5][15]=1.9348709245965e+00;
	q[5][16]=1.2774802945956e+00; 	q[5][17]=7.5865380864172e-01;
	q[5][18]=9.5898974285014e-01; 	q[5][19]=5.3078579012486e-01;

	q[6][7]=4.2357999217628e-01; 	q[6][8]=1.6268910569817e+00;
	q[6][9]=1.8684804693170e-01; 	q[6][10]=3.7262517508685e-01;
	q[6][11]=2.8024271516787e+00; 	q[6][12]=5.5541539747043e-01;
	q[6][13]=2.9140908416530e-01; 	q[6][14]=9.2656393484598e-01;
	q[6][15]=1.7698932389373e+00; 	q[6][16]=1.0710972360073e+00;
	q[6][17]=4.0763564893830e-01; 	q[6][18]=5.9671930034577e-01;
	q[6][19]=5.2425384633796e-01; 
	
	q[7][8]=5.3985912495418e-01; 	q[7][9]=1.8929629237636e-01;
	q[7][10]=2.1772115923623e-01; 	q[7][11]=7.5204244030271e-01;
	q[7][12]=4.5943617357855e-01; 	q[7][13]=3.6816646445253e-01;
	q[7][14]=5.0408659952683e-01; 	q[7][15]=1.5093262532236e+00;
	q[7][16]=6.4143601140497e-01; 	q[7][17]=5.0835892463812e-01;
	q[7][18]=3.0805573703500e-01; 	q[7][19]=2.5334079019018e-01;

	q[8][9]=2.5271844788492e-01; 	q[8][10]=3.4807220979697e-01;
	q[8][11]=1.0225070358890e+00; 	q[8][12]=9.8431152535870e-01;
	q[8][13]=7.1453370392764e-01; 	q[8][14]=5.2700733915060e-01;
	q[8][15]=1.1170297629105e+00; 	q[8][16]=5.8540709022472e-01;
	q[8][17]=3.0124860078016e-01; 	q[8][18]=4.2189539693890e+00;
	q[8][19]=2.0155597175031e-01; 
	
	q[9][10]=3.8909637733035e+00; 	q[9][11]=4.0619358664202e-01;
	q[9][12]=3.3647977631042e+00; 	q[9][13]=1.5173593259539e+00;
	q[9][14]=3.8835540920564e-01; 	q[9][15]=3.5754441245967e-01;
	q[9][16]=1.1790911972601e+00; 	q[9][17]=3.4198578754023e-01;
	q[9][18]=6.7461709322842e-01; 	q[9][19]=8.3118394054582e+00;

	q[10][11]=4.4557027426059e-01; 	q[10][12]=6.0305593795716e+00;
	q[10][13]=2.0648397032375e+00; 	q[10][14]=3.7455568747097e-01;
	q[10][15]=3.5296918452729e-01; 	q[10][16]=9.1525985769421e-01;
	q[10][17]=6.9147463459998e-01; 	q[10][18]=8.1124585632307e-01;
	q[10][19]=2.2314056889131e+00; 
	
	q[11][12]=1.0730611843319e+00; 	q[11][13]=2.6692475051102e-01;
	q[11][14]=1.0473834507215e+00; 	q[11][15]=1.7521659178195e+00;
	q[11][16]=1.3038752007987e+00; 	q[11][17]=3.3224304063396e-01;
	q[11][18]=7.1799348690032e-01; 	q[11][19]=4.9813847530407e-01;

	q[12][13]=1.7738551688305e+00; 	q[12][14]=4.5412362510273e-01;
	q[12][15]=9.1872341574605e-01; 	q[12][16]=1.4885480537218e+00;
	q[12][17]=8.8810109815193e-01; 	q[12][18]=9.5168216224591e-01;
	q[12][19]=2.5758507553153e+00; 
	
	q[13][14]=2.3359790962888e-01; 	q[13][15]=5.4002764482413e-01;
	q[13][16]=4.8820611879305e-01; 	q[13][17]=2.0743248934965e+00;
	q[13][18]=6.7472604308008e+00; 	q[13][19]=8.3811961017754e-01;

	q[14][15]=1.1691295777157e+00; 	q[14][16]=1.0054516831488e+00;
	q[14][17]=2.5221483002727e-01; 	q[14][18]=3.6940531935451e-01;
	q[14][19]=4.9690841067567e-01; 
	
	q[15][16]=5.1515562922704e+00; 	q[15][17]=3.8792562209837e-01;
	q[15][18]=7.9675152076106e-01; 	q[15][19]=5.6192545744165e-01;

	q[16][17]=5.1312812689059e-01; 	q[16][18]=8.0101024319939e-01;
	q[16][19]=2.2530740511763e+00; 
	
	q[17][18]=4.0544190065580e+00; 	q[17][19]=2.6650873142646e-01;

	q[18][19]=1.0000000000000e+00; 


	f[0]=0.074; f[1]=0.052; f[2]=0.045; f[3]=0.054;
	f[4]=0.025; f[5]=0.034; f[6]=0.054; f[7]=0.074;
	f[8]=0.026; f[9]=0.068; f[10]=0.099; f[11]=0.058;
	f[12]=0.025; f[13]=0.047; f[14]=0.039; f[15]=0.057;
	f[16]=0.051; f[17]=0.013; f[18]=0.032; f[19]=0.073;
} /* blosum62data */

void vtmvdata(dmatrix q, double *f)
{                 
  /* 
   * Dayhoff model for amino acid evolution 
   * Mueller, T. and Vingron, M. 
   * "Modeling Amino Acid Replacement" 
   * Journal of Comp. Biology, 7(6):761-776,2000
   */

/* amino acid frequencies */

f[ 0]=0.0770764620135024 ; f[ 1]=0.0500819370772208 ;
f[ 2]=0.0462377395993731 ; f[ 3]=0.0537929860758246 ;
f[ 4]=0.0144533387583345 ; f[ 5]=0.0408923608974345 ;
f[ 6]=0.0633579339160905 ; f[ 7]=0.0655672355884439 ;
f[ 8]=0.0218802687005936 ; f[ 9]=0.0591969699027449 ;
f[10]=0.0976461276528445 ; f[11]=0.0592079410822730 ;
f[12]=0.0220695876653368 ; f[13]=0.0413508521834260 ;
f[14]=0.0476871596856874 ; f[15]=0.0707295165111524 ;
f[16]=0.0567759161524817 ; f[17]=0.0127019797647213 ;
f[18]=0.0323746050281867 ; f[19]=0.0669190817443274 ;
 
/* relative rates */

q[ 0][ 1] = 1.2412691067876198;  q[ 0][ 2] = 1.2184237953498958;
q[ 0][ 3] = 1.3759368509441177;  q[ 0][ 4] = 2.4731223087544874;
q[ 0][ 5] = 2.2155167805137470;  q[ 0][ 6] = 2.3379911207495061;
q[ 0][ 7] = 3.3386555146457697;  q[ 0][ 8] = 0.9615841926910841;
q[ 0][ 9] = 0.8908203061925510;  q[ 0][10] = 1.0778497408764076;
q[ 0][11] = 1.4932055816372476;  q[ 0][12] = 1.9006455961717605;
q[ 0][13] = 0.6883439026872615;  q[ 0][14] = 2.7355620089953550;
q[ 0][15] = 6.4208961859142883;  q[ 0][16] = 5.2892514169776437;
q[ 0][17] = 0.5488578478106930;  q[ 0][18] = 0.5411769916657778;
q[ 0][19] = 4.6501894691803214;

q[ 1][ 2] = 1.5720770753326880;  q[ 1][ 3] = 0.7550654439001206;
q[ 1][ 4] = 1.4414262567428417;  q[ 1][ 5] = 5.5120819705248678;
q[ 1][ 6] = 1.3542404860613146;  q[ 1][ 7] = 1.3121700301622004;
q[ 1][ 8] = 4.9238668283945266;  q[ 1][ 9] = 0.4323005487925516;
q[ 1][10] = 0.8386701149158265;  q[ 1][11] = 10.0173308173660018;
q[ 1][12] = 1.2488638689609959;  q[ 1][13] = 0.4224945197276290;
q[ 1][14] = 1.3091837782420783;  q[ 1][15] = 1.9202994262316166;
q[ 1][16] = 1.3363401740560601;  q[ 1][17] = 1.5170142153962840;
q[ 1][18] = 0.8912614404565405;  q[ 1][19] = 0.7807017855806767;

q[ 2][ 3] = 7.8584219153689405;  q[ 2][ 4] = 0.9784679122774127;
q[ 2][ 5] = 3.0143201670924822;  q[ 2][ 6] = 2.0093434778398112;
q[ 2][ 7] = 2.4117632898861809;  q[ 2][ 8] = 6.1974384977884114;
q[ 2][ 9] = 0.9179291175331520;  q[ 2][10] = 0.4098311270816011;
q[ 2][11] = 4.4034547578962568;  q[ 2][12] = 0.9378803706165143;
q[ 2][13] = 0.5044944273324311;  q[ 2][14] = 0.7103720531974738;
q[ 2][15] = 6.1234512396801764;  q[ 2][16] = 3.8852506105922231;
q[ 2][17] = 0.1808525752605976;  q[ 2][18] = 1.0894926581511342;
q[ 2][19] = 0.4586061981719967;

q[ 3][ 4] = 0.2272488448121475;  q[ 3][ 5] = 1.6562495638176040;
q[ 3][ 6] = 9.6883451875685065;  q[ 3][ 7] = 1.9142079025990228;
q[ 3][ 8] = 2.1459640610133781;  q[ 3][ 9] = 0.2161660372725585;
q[ 3][10] = 0.3574207468998517;  q[ 3][11] = 1.4521790561663968;
q[ 3][12] = 0.4075239926000898;  q[ 3][13] = 0.1675129724559251;
q[ 3][14] = 1.0714605979577547;  q[ 3][15] = 2.2161944596741829;
q[ 3][16] = 1.5066839872944762;  q[ 3][17] = 0.2496584188151770;
q[ 3][18] = 0.7447620891784513;  q[ 3][19] = 0.4594535241660911;

q[ 4][ 5] = 0.4587469126746136;  q[ 4][ 6] = 0.4519167943192672;
q[ 4][ 7] = 1.1034605684472507;  q[ 4][ 8] = 1.5196756759380692;
q[ 4][ 9] = 0.9126668032539315;  q[ 4][10] = 1.4081315998413697;
q[ 4][11] = 0.3371091785647479;  q[ 4][12] = 1.2213054800811556;
q[ 4][13] = 1.6953951980808002;  q[ 4][14] = 0.4326227078645523;
q[ 4][15] = 3.6366815408744255;  q[ 4][16] = 1.7557065205837685;
q[ 4][17] = 1.6275179891253113;  q[ 4][18] = 2.1579775140421025;
q[ 4][19] = 2.2627456996290891;

q[ 5][ 6] = 6.8124601839937675;  q[ 5][ 7] = 0.8776110594765502;
q[ 5][ 8] = 7.9943228564946525;  q[ 5][ 9] = 0.4882733432879921;
q[ 5][10] = 1.3318097154194044;  q[ 5][11] = 6.0519085243118811;
q[ 5][12] = 1.9106190827629084;  q[ 5][13] = 0.3573432522499545;
q[ 5][14] = 2.3019177728300728;  q[ 5][15] = 2.3193703643237220;
q[ 5][16] = 2.1576510103471440;  q[ 5][17] = 0.8959082681546182;
q[ 5][18] = 0.9183596801412757;  q[ 5][19] = 0.6366932501396869;

q[ 6][ 7] = 1.3860121390169038;  q[ 6][ 8] = 1.6360079688522375;
q[ 6][ 9] = 0.4035497929633328;  q[ 6][10] = 0.5610717242294755;
q[ 6][11] = 4.3290086529582830;  q[ 6][12] = 0.7471936218068498;
q[ 6][13] = 0.2317194387691585;  q[ 6][14] = 1.5132807416252063;
q[ 6][15] = 1.8273535587773553;  q[ 6][16] = 1.5839981708584689;
q[ 6][17] = 0.4198391148111098;  q[ 6][18] = 0.5818111331782764;
q[ 6][19] = 0.8940572875547330;

q[ 7][ 8] = 0.8561248973045037;  q[ 7][ 9] = 0.2888075033037488;
q[ 7][10] = 0.3578662395745526;  q[ 7][11] = 0.8945563662345198;
q[ 7][12] = 0.5954812791740037;  q[ 7][13] = 0.3693722640980460;
q[ 7][14] = 0.7744933618134962;  q[ 7][15] = 3.0637776193717610;
q[ 7][16] = 0.7147489676267383;  q[ 7][17] = 0.9349753595598769;
q[ 7][18] = 0.3374467649724478;  q[ 7][19] = 0.6193321034173915;

q[ 8][ 9] = 0.5787937115407940;  q[ 8][10] = 1.0765007949562073;
q[ 8][11] = 1.8085136096039203;  q[ 8][12] = 1.3808291710019667;
q[ 8][13] = 1.3629765501081097;  q[ 8][14] = 1.8370555852070649;
q[ 8][15] = 1.9699895187387506;  q[ 8][16] = 1.6136654573285647;
q[ 8][17] = 0.6301954684360302;  q[ 8][18] = 7.7587442309146040;
q[ 8][19] = 0.5333220944030346;

q[ 9][10] = 6.0019110258426362;  q[ 9][11] = 0.6244297525127139;
q[ 9][12] = 6.7597899772045418;  q[ 9][13] = 2.2864286949316077;
q[ 9][14] = 0.4811402387911145;  q[ 9][15] = 0.6047491507504744;
q[ 9][16] = 2.6344778384442731;  q[ 9][17] = 0.5604648274060783;
q[ 9][18] = 0.8626796044156272;  q[ 9][19] = 14.8729334615190609;

q[10][11] = 0.5642322882556321;  q[10][12] = 8.0327792947421148;
q[10][13] = 4.3611548063555778;  q[10][14] = 1.0084320519837335;
q[10][15] = 0.8953754669269811;  q[10][16] = 1.0192004372506540;
q[10][17] = 1.5183114434679339;  q[10][18] = 1.2452243224541324;
q[10][19] = 3.5458093276667237;

q[11][12] = 1.7129670976916258;  q[11][13] = 0.3910559903834828;
q[11][14] = 1.3918935593582853;  q[11][15] = 1.9776630140912268;
q[11][16] = 2.5513781312660280;  q[11][17] = 0.5851920879490173;
q[11][18] = 0.7835447533710449;  q[11][19] = 0.7801080335991272;

q[12][13] = 2.3201373546296349;  q[12][14] = 0.4953193808676289;
q[12][15] = 1.0657482318076852;  q[12][16] = 3.3628488360462363;
q[12][17] = 1.4680478689711018;  q[12][18] = 1.0899165770956820;
q[12][19] = 4.0584577156753401;

q[13][14] = 0.3746821107962129;  q[13][15] = 1.1079144700606407;
q[13][16] = 0.6882725908872254;  q[13][17] = 3.3448437239772266;
q[13][18] = 10.3848523331334590;  q[13][19] = 1.7039730522675411;

q[14][15] = 3.5465914843628927;  q[14][16] = 1.9485376673137556;
q[14][17] = 0.4326058001438786;  q[14][18] = 0.4819109019647465;
q[14][19] = 0.5985498912985666;

q[15][16] = 8.8479984061248178;  q[15][17] = 0.6791126595939816;
q[15][18] = 0.9547229305958682;  q[15][19] = 0.9305232113028208;

q[16][17] = 0.4514203099376473;  q[16][18] = 0.8564314184691215;
q[16][19] = 3.4242218450865543;

q[17][18] = 4.5377235790405388;  q[17][19] = 0.5658969249032649;

q[18][19] = 1.0000000000000000;

} /* vtmvdata */



/*
 * WAG matrix: Simon Whelan and Nick Goldman
 *
 */

void wagdata(dmatrix q, double *f)
{
		/*
		 * WAG model of amino acid evolution
		 * 
		 * Whelan, S. and N. Goldman (2001) 
		 * A general empirical model of protein evolution 
		 * derived from multiple protein families using a 
		 * maximum likelihood approach.  
		 * Mol. Biol. Evol. 18:691-699
                 *
		 */

		/* R matrix */

	
	
	q[0][1]  =0.551571; 
	
	q[0][2]  =0.509848;  q[1][2]  =0.635346; 
	
	q[0][3]  =0.738998;  q[1][3]  =0.147304;  q[2][3]  =5.429420; 
	
	q[0][4]  =1.027040;  q[1][4]  =0.528191;  q[2][4]  =0.265256; 
	q[3][4]  =0.0302949; 
	
	q[0][5]  =0.908598;  q[1][5]  =3.035500;  q[2][5]  =1.543640; 
	q[3][5]  =0.616783;  q[4][5]  =0.0988179; 
	
	q[0][6]  =1.582850;  q[1][6]  =0.439157;  q[2][6]  =0.947198; 
	q[3][6]  =6.174160;  q[4][6]  =0.021352;  q[5][6]  =5.469470; 
	
	q[0][7]  =1.416720;  q[1][7]  =0.584665;  q[2][7]  =1.125560; 
	q[3][7]  =0.865584;  q[4][7]  =0.306674;  q[5][7]  =0.330052; 
	q[6][7]  =0.567717; 
	
	q[0][8]  =0.316954;  q[1][8]  =2.137150;  q[2][8]  =3.956290; 
	q[3][8]  =0.930676;  q[4][8]  =0.248972;  q[5][8]  =4.294110; 
	q[6][8]  =0.570025;  q[7][8]  =0.249410; 
	
	q[0][9]  =0.193335;  q[1][9]  =0.186979;  q[2][9]  =0.554236; 
	q[3][9]  =0.039437;  q[4][9]  =0.170135;  q[5][9]  =0.113917; 
	q[6][9]  =0.127395;  q[7][9]  =0.0304501; q[8][9]  =0.138190; 
	
	q[0][10] =0.397915;  q[1][10] =0.497671;  q[2][10] =0.131528;  
	q[3][10] =0.0848047; q[4][10] =0.384287;  q[5][10] =0.869489; 
	q[6][10] =0.154263;  q[7][10] =0.0613037; q[8][10] =0.499462; 
	q[9][10] =3.170970; 
	
	q[0][11] =0.906265;  q[1][11] =5.351420;  q[2][11] =3.012010; 
	q[3][11] =0.479855;  q[4][11] =0.0740339; q[5][11] =3.894900; 
	q[6][11] =2.584430;  q[7][11] =0.373558;  q[8][11] =0.890432; 
	q[9][11] =0.323832;  q[10][11]=0.257555; 
	
	q[0][12] =0.893496;  q[1][12] =0.683162;  q[2][12] =0.198221; 
	q[3][12] =0.103754;  q[4][12] =0.390482;  q[5][12] =1.545260; 
	q[6][12] =0.315124;  q[7][12] =0.174100;  q[8][12] =0.404141; 
	q[9][12] =4.257460;  q[10][12]=4.854020;  q[11][12]=0.934276; 
	
	q[0][13] =0.210494;  q[1][13] =0.102711;  q[2][13] =0.0961621; 
	q[3][13] =0.0467304; q[4][13] =0.398020;  q[5][13] =0.0999208; 
	q[6][13] =0.0811339; q[7][13] =0.049931;  q[8][13] =0.679371; 
	q[9][13] =1.059470;  q[10][13]=2.115170;  q[11][13]=0.088836; 
	q[12][13]=1.190630; 

	q[0][14] =1.438550;  q[1][14] =0.679489;  q[2][14] =0.195081; 
	q[3][14] =0.423984;  q[4][14] =0.109404;  q[5][14] =0.933372; 
	q[6][14] =0.682355;  q[7][14] =0.243570;  q[8][14] =0.696198; 
	q[9][14] =0.0999288; q[10][14]=0.415844;  q[11][14]=0.556896; 
	q[12][14]=0.171329;  q[13][14]=0.161444; 
	
	q[0][15] =3.370790;  q[1][15] =1.224190;  q[2][15] =3.974230; 
	q[3][15] =1.071760;  q[4][15] =1.407660;  q[5][15] =1.028870; 
	q[6][15] =0.704939;  q[7][15] =1.341820;  q[8][15] =0.740169; 
	q[9][15] =0.319440;  q[10][15]=0.344739;  q[11][15]=0.967130; 
	q[12][15]=0.493905;  q[13][15]=0.545931;  q[14][15]=1.613280; 
	
	q[0][16] =2.121110;  q[1][16] =0.554413;  q[2][16] =2.030060; 
	q[3][16] =0.374866;  q[4][16] =0.512984;  q[5][16] =0.857928; 
	q[6][16] =0.822765;  q[7][16] =0.225833;  q[8][16] =0.473307; 
	q[9][16] =1.458160;  q[10][16]=0.326622;  q[11][16]=1.386980; 
	q[12][16]=1.516120;  q[13][16]=0.171903;  q[14][16]=0.795384; 
	q[15][16]=4.378020; 
	
	q[0][17] =0.113133;  q[1][17] =1.163920;  q[2][17] =0.0719167; 
	q[3][17] =0.129767;  q[4][17] =0.717070;  q[5][17] =0.215737; 
	q[6][17] =0.156557;  q[7][17] =0.336983;  q[8][17] =0.262569; 
	q[9][17] =0.212483;  q[10][17]=0.665309;  q[11][17]=0.137505; 
	q[12][17]=0.515706;  q[13][17]=1.529640;  q[14][17]=0.139405; 
	q[15][17]=0.523742;  q[16][17]=0.110864; 
	
	q[0][18] =0.240735;  q[1][18] =0.381533;  q[2][18] =1.086000; 
	q[3][18] =0.325711;  q[4][18] =0.543833;  q[5][18] =0.227710; 
	q[6][18] =0.196303;  q[7][18] =0.103604;  q[8][18] =3.873440; 
	q[9][18] =0.420170;  q[10][18]=0.398618;  q[11][18]=0.133264; 
	q[12][18]=0.428437;  q[13][18]=6.454280;  q[14][18]=0.216046; 
	q[15][18]=0.786993;  q[16][18]=0.291148;  q[17][18]=2.485390; 
	
	q[0][19] =2.006010;  q[1][19] =0.251849;  q[2][19] =0.196246; 
	q[3][19] =0.152335;  q[4][19] =1.002140;  q[5][19] =0.301281; 
	q[6][19] =0.588731;  q[7][19] =0.187247;  q[8][19] =0.118358; 
	q[9][19] =7.821300;  q[10][19]=1.800340;  q[11][19]=0.305434; 
	q[12][19]=2.058450;  q[13][19]=0.649892;  q[14][19]=0.314887; 
	q[15][19]=0.232739;  q[16][19]=1.388230;  q[17][19]=0.365369; 
	q[18][19]=0.314730; 

	f[ 0] = 0.0866279; 
	f[ 1] = 0.043972; 
	f[ 2] = 0.0390894; 
	f[ 3] = 0.0570451; 
	f[ 4] = 0.0193078; 
	f[ 5] = 0.0367281; 
	f[ 6] = 0.0580589; 
	f[ 7] = 0.0832518; 
	f[ 8] = 0.0244313; 
	f[ 9] = 0.048466; 
	f[10] = 0.086209; 
	f[11] = 0.0620286; 
	f[12] = 0.0195027; 
	f[13] = 0.0384319; 
	f[14] = 0.0457631; 
	f[15] = 0.0695179; 
	f[16] = 0.0610127; 
	f[17] = 0.0143859; 
	f[18] = 0.0352742; 
	f[19] = 0.0708956;


} /* wagdata */


/*
 * old WAG matrix: Simon Whelan and Nick Goldman
 *
 */

void oldwagdata(dmatrix q, double *f)
{
		/*
		 * WAG model of amino acid evolution
		 * 
		 * S. Whelan and N. Goldman.  2000.  In prep.
		 * 
                 * presented at the MASAMB-X workshop in Cambridge
                 *
                 * Whelan, S., and N. Goldman.  2000.  
                 * The WAG amino acid rate matrix.
                 * Manuscript in prep.
		 *
		 * old version - differed from the published matrix
		 */

		/* Q matrix */
		q[0][1] = 0.610810; q[0][2] = 0.569079; 
		q[0][3] = 0.821500; q[0][4] = 1.141050; 
		q[0][5] = 1.011980; q[0][6] = 1.756410; 
		q[0][7] = 1.572160; q[0][8] = 0.354813; 
		q[0][9] = 0.219023; q[0][10] = 0.443935; 
		q[0][11] = 1.005440; q[0][12] = 0.989475; 
		q[0][13] = 0.233492; q[0][14] = 1.594890; 
		q[0][15] = 3.733380; q[0][16] = 2.349220; 
		q[0][17] = 0.125227; q[0][18] = 0.268987; 
		q[0][19] = 2.221870; 

		q[1][2] = 0.711690; q[1][3] = 0.165074; 
		q[1][4] = 0.585809; q[1][5] = 3.360330; 
		q[1][6] = 0.488649; q[1][7] = 0.650469; 
		q[1][8] = 2.362040; q[1][9] = 0.206722; 
		q[1][10] = 0.551450; q[1][11] = 5.925170; 
		q[1][12] = 0.758446; q[1][13] = 0.116821; 
		q[1][14] = 0.753467; q[1][15] = 1.357640; 
		q[1][16] = 0.613776; q[1][17] = 1.294610; 
		q[1][18] = 0.423612; q[1][19] = 0.280336; 

		q[2][3] = 6.013660; q[2][4] = 0.296524; 
		q[2][5] = 1.716740; q[2][6] = 1.056790; 
		q[2][7] = 1.253910; q[2][8] = 4.378930; 
		q[2][9] = 0.615636; q[2][10] = 0.147156; 
		q[2][11] = 3.334390; q[2][12] = 0.224747; 
		q[2][13] = 0.110793; q[2][14] = 0.217538; 
		q[2][15] = 4.394450; q[2][16] = 2.257930; 
		q[2][17] = 0.078463; q[2][18] = 1.208560; 
		q[2][19] = 0.221176; 

		q[3][4] = 0.033379; q[3][5] = 0.691268; 
		q[3][6] = 6.833400; q[3][7] = 0.961142; 
		q[3][8] = 1.032910; q[3][9] = 0.043523; 
		q[3][10] = 0.093930; q[3][11] = 0.533362; 
		q[3][12] = 0.116813; q[3][13] = 0.052004; 
		q[3][14] = 0.472601; q[3][15] = 1.192810; 
		q[3][16] = 0.417372; q[3][17] = 0.146348; 
		q[3][18] = 0.363243; q[3][19] = 0.169417; 

		q[4][5] = 0.109261; q[4][6] = 0.023920; 
		q[4][7] = 0.341086; q[4][8] = 0.275403; 
		q[4][9] = 0.189890; q[4][10] = 0.428414; 
		q[4][11] = 0.083649; q[4][12] = 0.437393; 
		q[4][13] = 0.441300; q[4][14] = 0.122303; 
		q[4][15] = 1.560590; q[4][16] = 0.570186; 
		q[4][17] = 0.795736; q[4][18] = 0.604634; 
		q[4][19] = 1.114570; 

		q[5][6] = 6.048790; q[5][7] = 0.366510; 
		q[5][8] = 4.749460; q[5][9] = 0.131046; 
		q[5][10] = 0.964886; q[5][11] = 4.308310; 
		q[5][12] = 1.705070; q[5][13] = 0.110744; 
		q[5][14] = 1.036370; q[5][15] = 1.141210; 
		q[5][16] = 0.954144; q[5][17] = 0.243615; 
		q[5][18] = 0.252457; q[5][19] = 0.333890; 

		q[6][7] = 0.630832; q[6][8] = 0.635025; 
		q[6][9] = 0.141320; q[6][10] = 0.172579; 
		q[6][11] = 2.867580; q[6][12] = 0.353912; 
		q[6][13] = 0.092310; q[6][14] = 0.755791; 
		q[6][15] = 0.782467; q[6][16] = 0.914814; 
		q[6][17] = 0.172682; q[6][18] = 0.217549; 
		q[6][19] = 0.655045; 

		q[7][8] = 0.276379; q[7][9] = 0.034151; 
		q[7][10] = 0.068651; q[7][11] = 0.415992; 
		q[7][12] = 0.194220; q[7][13] = 0.055288; 
		q[7][14] = 0.273149; q[7][15] = 1.486700; 
		q[7][16] = 0.251477; q[7][17] = 0.374321; 
		q[7][18] = 0.114187; q[7][19] = 0.209108; 
		
		q[8][9] = 0.152215; q[8][10] = 0.555096; 
		q[8][11] = 0.992083; q[8][12] = 0.450867; 
		q[8][13] = 0.756080; q[8][14] = 0.771387; 
		q[8][15] = 0.822459; q[8][16] = 0.525511; 
		q[8][17] = 0.289998; q[8][18] = 4.290350; 
		q[8][19] = 0.131869; 

		q[9][10] = 3.517820; q[9][11] = 0.360574; 
		q[9][12] = 4.714220; q[9][13] = 1.177640; 
		q[9][14] = 0.111502; q[9][15] = 0.353443; 
		q[9][16] = 1.615050; q[9][17] = 0.234326; 
		q[9][18] = 0.468951; q[9][19] = 8.659740; 
		
		q[10][11] = 0.287583; q[10][12] = 5.375250; 
		q[10][13] = 2.348200; q[10][14] = 0.462018; 
		q[10][15] = 0.382421; q[10][16] = 0.364222; 
		q[10][17] = 0.740259; q[10][18] = 0.443205; 
		q[10][19] = 1.997370; 
		
		q[11][12] = 1.032220; q[11][13] = 0.098843; 
		q[11][14] = 0.619503; q[11][15] = 1.073780; 
		q[11][16] = 1.537920; q[11][17] = 0.152232; 
		q[11][18] = 0.147411; q[11][19] = 0.342012; 
		
		q[12][13] = 1.320870; q[12][14] = 0.194864; 
		q[12][15] = 0.556353; q[12][16] = 1.681970; 
		q[12][17] = 0.570369; q[12][18] = 0.473810; 
		q[12][19] = 2.282020; 
		
		q[13][14] = 0.179896; q[13][15] = 0.606814; 
		q[13][16] = 0.191467; q[13][17] = 1.699780; 
		q[13][18] = 7.154480; q[13][19] = 0.725096; 
		
		q[14][15] = 1.786490; q[14][16] = 0.885349; 
		q[14][17] = 0.156619; q[14][18] = 0.239607; 
		q[14][19] = 0.351250; 
		
		q[15][16] = 4.847130; q[15][17] = 0.578784; 
		q[15][18] = 0.872519; q[15][19] = 0.258861; 
		
		q[16][17] = 0.126678; q[16][18] = 0.325490; 
		q[16][19] = 1.547670; 
		
		q[17][18] = 2.763540; q[17][19] = 0.409817; 
		
		q[18][19] = 0.347826; 

		/* original frequencies */
		f[ 0] = 0.0866;
		f[ 1] = 0.0440;
		f[ 2] = 0.0391;
		f[ 3] = 0.0570;
		f[ 4] = 0.0193;
		f[ 5] = 0.0367;
		f[ 6] = 0.0581;
		f[ 7] = 0.0833;
		f[ 8] = 0.0244;
		f[ 9] = 0.0485;
		f[10] = 0.0862;
		f[11] = 0.0620;
		f[12] = 0.0195;
		f[13] = 0.0384;
		f[14] = 0.0458;
		f[15] = 0.0695;
		f[16] = 0.0610;
		f[17] = 0.0144;
		f[18] = 0.0353;
		f[19] = 0.0709;
} /* oldwagdata */


void cprev45data(dmatrix q, double *f)
{
	/* cpREV45 model of amino acid evolution
	 * Adachi, J., P.J. Waddell, W. Martin, and M. Hasegawa. 2000. 
	 * J. Mol. Evol. 50:348-358
	 * (reconstructed from 45 chloroplast genomes)
	 */
	q[0][1]  =  105; q[0][2]  =  227; 
	q[0][3]  =  175; q[0][4]  =  669; 
	q[0][5]  =  157; q[0][6]  =  499; 
	q[0][7]  =  665; q[0][8]  =   66; 
	q[0][9]  =  145; q[0][10] =  197; 
	q[0][11] =  236; q[0][12] =  185; 
	q[0][13] =   68; q[0][14] =  490; 
	q[0][15] = 2440; q[0][16] = 1340; 
	q[0][17] =   14; q[0][18] =   56; 
	q[0][19] =  968; 
	
	q[1][2]  =  357; q[1][3]  =   43; 
	q[1][4]  =  823; q[1][5]  = 1745; 
	q[1][6]  =  152; q[1][7]  =  243; 
	q[1][8]  =  715; q[1][9]  =  136; 
	q[1][10] =  203; q[1][11] = 4482; 
	q[1][12] =  125; q[1][13] =   53; 
	q[1][14] =   87; q[1][15] =  385; 
	q[1][16] =  314; q[1][17] =  230; 
	q[1][18] =  323; q[1][19] =   92; 
	
	q[2][3]  = 4435; q[2][4]  =  538; 
	q[2][5]  =  768; q[2][6]  = 1055; 
	q[2][7]  =  653; q[2][8]  = 1405; 
	q[2][9]  =  168; q[2][10] =  113; 
	q[2][11] = 2430; q[2][12] =   61; 
	q[2][13] =   97; q[2][14] =  173; 
	q[2][15] = 2085; q[2][16] = 1393; 
	q[2][17] =   40; q[2][18] =  754; 
	q[2][19] =   83; 
	
	q[3][4]  =   10; q[3][5]  =  400; 
	q[3][6]  = 3691; q[3][7]  =  431; 
	q[3][8]  =  331; q[3][9]  =   10; 
	q[3][10] =   10; q[3][11] =  412; 
	q[3][12] =   47; q[3][13] =   22; 
	q[3][14] =  170; q[3][15] =  590; 
	q[3][16] =  266; q[3][17] =   18; 
	q[3][18] =  281; q[3][19] =   75; 
	
	q[4][5]  =   10; q[4][6]  =   10; 
	q[4][7]  =  303; q[4][8]  =  441; 
	q[4][9]  =  280; q[4][10] =  396; 
	q[4][11] =   48; q[4][12] =  159; 
	q[4][13] =  726; q[4][14] =  285; 
	q[4][15] = 2331; q[4][16] =  576; 
	q[4][17] =  435; q[4][18] = 1466; 
	q[4][19] =  592; 
	
	q[5][6]  = 3122; q[5][7]  =  133; 
	q[5][8]  = 1269; q[5][9]  =   92; 
	q[5][10] =  286; q[5][11] = 3313; 
	q[5][12] =  202; q[5][13] =   10; 
	q[5][14] =  323; q[5][15] =  396; 
	q[5][16] =  241; q[5][17] =   53; 
	q[5][18] =  391; q[5][19] =   54; 
	
	q[6][7]  =  379; q[6][8]  =  162; 
	q[6][9]  =  148; q[6][10] =   82; 
	q[6][11] = 2629; q[6][12] =  113; 
	q[6][13] =  145; q[6][14] =  185; 
	q[6][15] =  568; q[6][16] =  369; 
	q[6][17] =   63; q[6][18] =  142; 
	q[6][19] =  200; 
	
	q[7][8]  =   19; q[7][9]  =   40; 
	q[7][10] =   20; q[7][11] =  263; 
	q[7][12] =   21; q[7][13] =   25; 
	q[7][14] =   28; q[7][15] =  691; 
	q[7][16] =   92; q[7][17] =   82; 
	q[7][18] =   10; q[7][19] =   91; 
	
	q[8][9]  =   29; q[8][10] =   66; 
	q[8][11] =  305; q[8][12] =   10; 
	q[8][13] =  127; q[8][14] =  152; 
	q[8][15] =  303; q[8][16] =   32; 
	q[8][17] =   69; q[8][18] = 1971; 
	q[8][19] =   25; 
	
	q[9][10] = 1745; q[9][11] =  345; 
	q[9][12] = 1772; q[9][13] =  454; 
	q[9][14] =  117; q[9][15] =  216; 
	q[9][16] = 1040; q[9][17] =   42; 
	q[9][18] =   89; q[9][19] = 4797; 
	
	q[10][11] =  218; q[10][12] = 1351; 
	q[10][13] = 1268; q[10][14] =  219; 
	q[10][15] =  516; q[10][16] =  156; 
	q[10][17] =  159; q[10][18] =  189; 
	q[10][19] =  865; 
	
	q[11][12] =  193; q[11][13] =   72; 
	q[11][14] =  302; q[11][15] =  868; 
	q[11][16] =  918; q[11][17] =   10; 
	q[11][18] =  247; q[11][19] =  249; 
	
	q[12][13] =  327; q[12][14] =  100; 
	q[12][15] =   93; q[12][16] =  645; 
	q[12][17] =   86; q[12][18] =  215; 
	q[12][19] =  475; 
	
	q[13][14] =   43; q[13][15] =  487; 
	q[13][16] =  148; q[13][17] =  468; 
	q[13][18] = 2370; q[13][19] =  317; 
	
	q[14][15] = 1202; q[14][16] =  260; 
	q[14][17] =   49; q[14][18] =   97; 
	q[14][19] =  122; 
	
	q[15][16] = 2151; q[15][17] =   73; 
	q[15][18] =  522; q[15][19] =  167; 
	
	q[16][17] =   29; q[16][18] =   71; 
	q[16][19] =  760; 
	
	q[17][18] =  346; q[17][19] =   10; 
	
	q[18][19] =  119; 

	f[0]  = 0.076;
	f[1]  = 0.062;
	f[2]  = 0.041;
	f[3]  = 0.037;
	f[4]  = 0.009;
	f[5]  = 0.038;
	f[6]  = 0.049;
	f[7]  = 0.084;
	f[8]  = 0.025;
	f[9]  = 0.081;
	f[10] = 0.101;
	f[11] = 0.050;
	f[12] = 0.022;
	f[13] = 0.051;
	f[14] = 0.043;
	f[15] = 0.062;
	f[16] = 0.054;
	f[17] = 0.018;
	f[18] = 0.031;
	f[19] = 0.066;
} /* cprev45data */

