% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faq.R
\name{faq-selection-context}
\alias{faq-selection-context}
\title{FAQ - Error: Must be used within a \emph{selecting} function}
\description{
Functions like \code{starts_with()}, \code{contains()} or \code{matches()} are
\strong{selection helpers} that only work in a selection context.

Examples of valid selection contexts are:
\itemize{
\item Inside \code{dplyr::select()}.
\item The \code{cols} argument of \code{tidyr::pivot_longer()}.
}

Using a selection helper anywhere else results in an error:\if{html}{\out{<div class="sourceCode r">}}\preformatted{starts_with("foo")
#> Error:
#> ! `starts_with()` must be used within a *selecting* function.
#> i See <https://tidyselect.r-lib.org/reference/faq-selection-context.html>.

mtcars[contains("foo")]
#> Error:
#> ! `contains()` must be used within a *selecting* function.
#> i See <https://tidyselect.r-lib.org/reference/faq-selection-context.html>.

subset(mtcars, select = matches("foo"))
#> Error:
#> ! `matches()` must be used within a *selecting* function.
#> i See <https://tidyselect.r-lib.org/reference/faq-selection-context.html>.
}\if{html}{\out{</div>}}

If you see this error, you’ve probably used a selection helper in the
wrong place, possibly as the result of a typo (e.g. misplaced comma or
wrong argument name).
}
