% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_locate_4.R
\name{stri_locate_all}
\alias{stri_locate_all}
\alias{stri_locate_first}
\alias{stri_locate_last}
\alias{stri_locate}
\alias{stri_locate_all_charclass}
\alias{stri_locate_first_charclass}
\alias{stri_locate_last_charclass}
\alias{stri_locate_all_coll}
\alias{stri_locate_first_coll}
\alias{stri_locate_last_coll}
\alias{stri_locate_all_regex}
\alias{stri_locate_first_regex}
\alias{stri_locate_last_regex}
\alias{stri_locate_all_fixed}
\alias{stri_locate_first_fixed}
\alias{stri_locate_last_fixed}
\title{Locate Pattern Occurrences}
\usage{
stri_locate_all(str, ..., regex, fixed, coll, charclass)

stri_locate_first(str, ..., regex, fixed, coll, charclass)

stri_locate_last(str, ..., regex, fixed, coll, charclass)

stri_locate(
  str,
  ...,
  regex,
  fixed,
  coll,
  charclass,
  mode = c("first", "all", "last")
)

stri_locate_all_charclass(
  str,
  pattern,
  merge = TRUE,
  omit_no_match = FALSE,
  get_length = FALSE
)

stri_locate_first_charclass(str, pattern, get_length = FALSE)

stri_locate_last_charclass(str, pattern, get_length = FALSE)

stri_locate_all_coll(
  str,
  pattern,
  omit_no_match = FALSE,
  get_length = FALSE,
  ...,
  opts_collator = NULL
)

stri_locate_first_coll(
  str,
  pattern,
  get_length = FALSE,
  ...,
  opts_collator = NULL
)

stri_locate_last_coll(
  str,
  pattern,
  get_length = FALSE,
  ...,
  opts_collator = NULL
)

stri_locate_all_regex(
  str,
  pattern,
  omit_no_match = FALSE,
  capture_groups = FALSE,
  get_length = FALSE,
  ...,
  opts_regex = NULL
)

stri_locate_first_regex(
  str,
  pattern,
  capture_groups = FALSE,
  get_length = FALSE,
  ...,
  opts_regex = NULL
)

stri_locate_last_regex(
  str,
  pattern,
  capture_groups = FALSE,
  get_length = FALSE,
  ...,
  opts_regex = NULL
)

stri_locate_all_fixed(
  str,
  pattern,
  omit_no_match = FALSE,
  get_length = FALSE,
  ...,
  opts_fixed = NULL
)

stri_locate_first_fixed(
  str,
  pattern,
  get_length = FALSE,
  ...,
  opts_fixed = NULL
)

stri_locate_last_fixed(
  str,
  pattern,
  get_length = FALSE,
  ...,
  opts_fixed = NULL
)
}
\arguments{
\item{str}{character vector; strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator},
\code{opts_regex}, \code{opts_fixed}, and so on}

\item{mode}{single string;
one of: \code{'first'} (the default), \code{'all'}, \code{'last'}}

\item{pattern, regex, fixed, coll, charclass}{character vector;
search patterns; for more details refer to \link{stringi-search}}

\item{merge}{single logical value;
indicates whether consecutive sequences of indexes in the resulting
matrix should be merged; \code{stri_locate_all_charclass} only}

\item{omit_no_match}{single logical value; if \code{TRUE},
a no-match will be indicated by a matrix with 0 rows
\code{stri_locate_all_*} only}

\item{get_length}{single logical value; if \code{FALSE} (default),
generate \emph{from-to} matrices; otherwise, output
\emph{from-length} ones}

\item{opts_collator, opts_fixed, opts_regex}{named list used to tune up
the selected search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for the defaults}

\item{capture_groups}{single logical value;
whether positions of matches to parenthesized subexpressions
should be returned too (as \code{capture_groups} attribute);
\code{stri_locate_*_regex} only}
}
\value{
For \code{stri_locate_all_*},
a list of integer matrices is returned. Each list element
represents the results of a separate search scenario.
The first column gives the start positions
of the matches, and the second column gives the end positions.
Moreover, two \code{NA}s in a row denote \code{NA} arguments
or a no-match (the latter only if \code{omit_no_match} is \code{FALSE}).

\code{stri_locate_first_*} and \code{stri_locate_last_*}
return an integer matrix with
two columns, giving the start and end positions of the first
or the last matches, respectively, and two \code{NA}s if and
only if they are not found.

For \code{stri_locate_*_regex}, if the match is of zero length,
\code{end} will be one character less than \code{start}.
Note that \code{stri_locate_last_regex} searches from start to end,
but skips overlapping matches, see the example below.

Setting \code{get_length=TRUE} results in the 2nd column representing
the length of the match instead of the end position. In this case,
negative length denotes a no-match.

If \code{capture_groups=TRUE}, then the outputs are equipped with the
\code{capture_groups} attribute, which is a list of matrices
giving the start-end positions of matches to parenthesized subexpressions.
Similarly to \code{stri_match_regex}, capture group names are extracted
unless looking for first/last occurrences of many different patterns.
}
\description{
These functions find the indexes (positions) where
there is a match to some pattern.
The functions \code{stri_locate_all_*} locate all the matches.
\code{stri_locate_first_*} and \code{stri_locate_last_*}
give the first and the last matches, respectively.
}
\details{
Vectorized over \code{str} and \code{pattern} (with recycling
of the elements in the shorter vector if necessary). This allows to,
for instance, search for one pattern in each string,
search for each pattern in one string,
and search for the i-th pattern within the i-th string.

The matches may be extracted by calling
\code{\link{stri_sub}} or \code{\link{stri_sub_all}}.
Alternatively, you may call \code{\link{stri_extract}} directly.

\code{stri_locate}, \code{stri_locate_all}, \code{stri_locate_first},
and \code{stri_locate_last} are convenience functions.
They just call \code{stri_locate_*_*}, depending on the arguments used.
}
\examples{
stri_locate_all('stringi', fixed='i')

stri_locate_first_coll('hladn\u00FD', 'HLADNY', strength=1, locale='sk_SK')

stri_locate_all_regex(
    c('breakfast=eggs;lunch=pizza', 'breakfast=spam', 'no food here'),
   '(?<when>\\\\w+)=(?<what>\\\\w+)',
   capture_groups=TRUE
)  # named capture groups

stri_locate_all_fixed("abababa", "ABA", case_insensitive=TRUE, overlap=TRUE)
stri_locate_first_fixed("ababa", "aba")
stri_locate_last_fixed("ababa", "aba")  # starts from end
stri_locate_last_regex("ababa", "aba")  # no overlaps, from left to right

x <- c("yes yes", "no", NA)
stri_locate_all_fixed(x, "yes")
stri_locate_all_fixed(x, "yes", omit_no_match=TRUE)
stri_locate_all_fixed(x, "yes", get_length=TRUE)
stri_locate_all_fixed(x, "yes", get_length=TRUE, omit_no_match=TRUE)
stri_locate_first_fixed(x, "yes")
stri_locate_first_fixed(x, "yes", get_length=TRUE)

# Use regex positive-lookahead to locate overlapping pattern matches:
stri_locate_all_regex('ACAGAGACTTTAGATAGAGAAGA', '(?=AGA)')
# note that start > end here (match of length zero)


}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other search_locate: 
\code{\link{about_search}},
\code{\link{stri_locate_all_boundaries}()}

Other indexing: 
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_sub_all}()},
\code{\link{stri_sub}()}
}
\concept{indexing}
\concept{search_locate}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
