% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcfcs.r
\name{smcfcs.casecohort}
\alias{smcfcs.casecohort}
\title{Substantive model compatible fully conditional specification imputation of covariates for case cohort studies}
\usage{
smcfcs.casecohort(
  originaldata,
  smformula,
  sampfrac,
  in.subco,
  method,
  predictorMatrix = NULL,
  m = 5,
  numit = 10,
  rjlimit = 1000,
  noisy = FALSE,
  errorProneMatrix = NULL
)
}
\arguments{
\item{originaldata}{The case-cohort data set (NOT a full cohort data set with a case-cohort substudy within it)}

\item{smformula}{A formula of the form "Surv(entertime,t,d)~x", where d is the event (d=1) or censoring (d=0) indicator, t is the event or censoring time and entertime is equal to the time origin (typically 0) for individuals in the subcohort and is equal to (t-0.001) for cases outside the subcohort [this sets cases outside the subcohort to enter follow-up just before their event time. The value 0.001 may need to be modified depending on the time scale.]}

\item{sampfrac}{The proportion of individuals from the underlying full cohort who are in the subcohort}

\item{in.subco}{The name of a column in the dataset with 0/1s that indicates whether the subject is in the subcohort}

\item{method}{A required vector of strings specifying for each variable either
that it does not need to be imputed (""), the type of regression model to be
be used to impute. Possible values are \code{"norm"} (normal linear regression),
\code{"logreg"} (logistic regression), \code{"brlogreg"} (bias reduced logistic regression),
\code{"poisson"} (Poisson regression),
\code{"podds"} (proportional odds regression for ordered categorical variables),
\code{"mlogit"} (multinomial logistic regression for unordered categorical variables),
or a custom expression which defines a passively imputed variable, e.g.
\code{"x^2"} or \code{"x1*x2"}. \code{"latnorm"} indicates the variable is a latent
normal variable which is measured with error. If this is specified for a variable,
the \code{"errorProneMatrix"} argument should also be used.}

\item{predictorMatrix}{An optional predictor matrix. If specified, the matrix defines which
covariates will be used as predictors in the imputation models
(the outcome must not be included). The i'th row of the matrix should consist of
0s and 1s, with a 1 in the j'th column indicating the j'th variable be used
as a covariate when imputing the i'th variable. If not specified, when
imputing a given variable, the imputation model covariates are the other
covariates of the substantive model which are partially observed
(but which are not passively imputed) and any fully observed covariates (if present)
in the substantive model. Note that the outcome variable is implicitly conditioned
on by the rejection sampling scheme used by smcfcs, and should not be specified as a predictor
in the predictor matrix.}

\item{m}{The number of imputed datasets to generate. The default is 5.}

\item{numit}{The number of iterations to run when generating each imputation.
In a (limited) range of simulations good performance was obtained with the
default of 10 iterations. However, particularly when the proportion of missingness
is large, more iterations may be required for convergence to stationarity.}

\item{rjlimit}{Specifies the maximum number of attempts which should be made
when using rejection sampling to draw from imputation models. If the limit is reached
when running a warning will be issued. In this case it is probably advisable to
increase the \code{rjlimit} until the warning does not appear.}

\item{noisy}{logical value (default FALSE) indicating whether output should be noisy, which can
be useful for debugging or checking that models being used are as desired.}

\item{errorProneMatrix}{An optional matrix which if specified indicates that some variables
are measured with classical measurement error. If the i'th variable is measured with error
by variables j and k, then the (i,j) and (i,k) entries of this matrix should be 1, with the
remainder of entries 0. The i'th element of the method argument should then be specified
as \code{"latnorm"}. See the measurement error vignette for more details.}
}
\description{
Multiply imputes missing covariate values using substantive model compatible
fully conditional specification for case cohort studies.
}
\details{
This version of \code{smcfcs} is designed for use with case cohort studies but where the analyst does not wish to,
or cannot (due to not having the necessary data) impute the full cohort. The function's arguments are the same
as for the main smcfcs function, except for \code{smformula}, \code{in.subco}, and \code{sampfrac} - see above
for details on how these should be specified.
}
\examples{
#the following example is not run when the package is compiled on CRAN
#(to keep computation time down), but it can be run by package users
\dontrun{
  #as per the documentation for ex_cc, the sampling fraction is 10\%
  imps <- smcfcs.casecohort(ex_cc, smformula="Surv(entertime, t, d)~x+z", sampfrac=0.1,
                            in.subco="in.subco", method=c("", "", "norm", "", "", "", ""))
  library(mitools)
  impobj <- imputationList(imps$impDatasets)
  models <- with(impobj, coxph(Surv(entertime,t,d)~x+z+cluster(id)))
  summary(MIcombine(models))
}
}
\author{
Ruth Keogh \email{ruth.keogh@lshtm.ac.uk}

Jonathan Bartlett \email{jonathan.bartlett1@lshtm.ac.uk}
}
