% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html-deps.R
\name{createWebDependency}
\alias{createWebDependency}
\title{Create a web dependency}
\usage{
createWebDependency(dependency, scrubFile = TRUE)
}
\arguments{
\item{dependency}{A single HTML dependency object, created using
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}. If the \code{src} value is named,
then \code{href} and/or \code{file} names must be present.}

\item{scrubFile}{If TRUE (the default), remove \code{src$file} for the
dependency. This prevents the local file path from being sent to the client
when dynamic web dependencies are used. If FALSE, don't remove
\code{src$file}. Setting it to FALSE should be needed only in very unusual
cases.}
}
\value{
A single HTML dependency object that has an \code{href}-named element
in its \code{src}.
}
\description{
Ensure that a file-based HTML dependency (from the htmltools package) can be
served over Shiny's HTTP server. This function works by using
\code{\link[=addResourcePath]{addResourcePath()}} to map the HTML dependency's directory to a
URL.
}
