% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_SAR.TL.R
\name{analyse_SAR.TL}
\alias{analyse_SAR.TL}
\title{Analyse SAR TL measurements}
\usage{
analyse_SAR.TL(
  object,
  object.background,
  signal.integral.min,
  signal.integral.max,
  integral_input = "channel",
  sequence.structure = c("PREHEAT", "SIGNAL", "BACKGROUND"),
  rejection.criteria = list(recycling.ratio = 10, recuperation.rate = 10),
  dose.points,
  log = "",
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or a \link{list} of such objects (\strong{required}) :
input object containing data for analysis}

\item{object.background}{currently not used}

\item{signal.integral.min}{\link{integer} (\strong{required}):
requires the channel number for the lower signal integral bound
(e.g. \code{signal.integral.min = 100})}

\item{signal.integral.max}{\link{integer} (\strong{required}):
requires the channel number for the upper signal integral bound
(e.g. \code{signal.integral.max = 200})}

\item{integral_input}{\link{character} (\emph{with default}):
defines the input for the the arguments \code{signal.integral.min} and
\code{signal.integral.max}. These limits can be either provided \code{'channel'}
number (the default) or \code{'temperature'}. If \code{'temperature'} is chosen the
best matching channel is selected.}

\item{sequence.structure}{\link{vector} \link{character} (\emph{with default}):
specifies the general sequence structure. Three steps are allowed
(\code{"PREHEAT"}, \code{"SIGNAL"}, \code{"BACKGROUND"}), in addition a
parameter \code{"EXCLUDE"}. This allows excluding TL curves which are not
relevant for the protocol analysis.  (\strong{Note:} None TL are removed by default)}

\item{rejection.criteria}{\link{list} (\emph{with default}):
list containing rejection criteria in percentage for the calculation.}

\item{dose.points}{\link{numeric} (\emph{optional}):
option set dose points manually}

\item{log}{\link{character} (\emph{with default}):
a character string which contains \code{"x"} if the x-axis is to be logarithmic,
\code{"y"} if the y axis is to be logarithmic and \code{"xy"} or \code{"yx"} if both axes
are to be logarithmic. See
\link{plot.default}).}

\item{...}{further arguments that will be passed to the function \link{plot_GrowthCurve}}
}
\value{
A plot (\emph{optional}) and an \linkS4class{RLum.Results} object is
returned containing the following elements:

\item{De.values}{\link{data.frame} containing De-values and further parameters}
\item{LnLxTnTx.values}{\link{data.frame} of all calculated \code{Lx/Tx} values including signal, background counts and the dose points.}
\item{rejection.criteria}{\link{data.frame} with values that might by used as rejection criteria. NA is produced if no R0 dose point exists.}

\strong{note:} the output should be accessed using the function \link{get_RLum}
}
\description{
The function performs a SAR TL analysis on a
\linkS4class{RLum.Analysis} object including growth curve fitting.
}
\details{
This function performs a SAR TL analysis on a set of curves. The SAR
procedure in general is given by Murray and Wintle (2000). For the
calculation of the \code{Lx/Tx} value the function \link{calc_TLLxTxRatio} is
used.

\strong{Provided rejection criteria}

\verb{[recyling.ratio]}: calculated for every repeated regeneration dose point.

\verb{[recuperation.rate]}: recuperation rate calculated by
comparing the \code{Lx/Tx} values of the zero regeneration point with the \code{Ln/Tn}
value (the \code{Lx/Tx} ratio of the natural signal).  For methodological
background see Aitken and Smith (1988)
}
\note{
\strong{THIS IS A BETA VERSION}

None TL curves will be removed
from the input object without further warning.
}
\section{Function version}{
 0.3.0
}

\examples{

##load data
data(ExampleData.BINfileData, envir = environment())

##transform the values from the first position in a RLum.Analysis object
object <- Risoe.BINfileData2RLum.Analysis(TL.SAR.Data, pos=3)

##perform analysis
analyse_SAR.TL(
 object = object,
 signal.integral.min = 210,
 signal.integral.max = 220,
 fit.method = "EXP OR LIN",
 sequence.structure = c("SIGNAL", "BACKGROUND"))

} 

\section{How to cite}{
Kreutzer, S., 2022. analyse_SAR.TL(): Analyse SAR TL measurements. Function version 0.3.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.18. https://CRAN.R-project.org/package=Luminescence
}

\references{
Aitken, M.J. and Smith, B.W., 1988. Optical dating: recuperation
after bleaching.  Quaternary Science Reviews 7, 387-393.

Murray, A.S. and Wintle, A.G., 2000. Luminescence dating of quartz using an
improved single-aliquot regenerative-dose protocol. Radiation Measurements
32, 57-73.
}
\seealso{
\link{calc_TLLxTxRatio}, \link{plot_GrowthCurve}, \linkS4class{RLum.Analysis},
\linkS4class{RLum.Results}, \link{get_RLum}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{datagen}
\keyword{plot}
