% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-paths.R
\name{pathing}
\alias{pathing}
\alias{set_latte_path}
\alias{set_4ti2_path}
\alias{get_4ti2_path}
\alias{get_latte_path}
\alias{has_4ti2}
\alias{has_latte}
\alias{missing_4ti2_stop}
\alias{missing_latte_stop}
\title{Set paths to LattE and 4ti2 executables}
\usage{
set_latte_path(path)

set_4ti2_path(path)

get_4ti2_path()

get_latte_path()

has_4ti2()

has_latte()

missing_4ti2_stop()

missing_latte_stop()
}
\arguments{
\item{path}{A character string, the path to a 4ti2 function (e.g. markov) for
setting 4ti2's path or a LattE function (e.g. count) for LattE's path}
}
\value{
An invisible character string, the path found.  More importantly, the
function has the side effect of setting the option "latte_path" or
"4ti2_path"
}
\description{
These functions set the path to external programs either by (1) passing them
a character string or (2) using \code{\link[=file.choose]{file.choose()}}.
}
\details{
When latte is loaded it attempts to find LattE and 4ti2 executables
(represented by count and markov, respectively).  How it looks depends on
your operating system.

If you're using a Mac or Linux machine, it looks based on your system's path.
Unfortunately, R changes the system path in such a way that the path that R
sees is not the same as the path that you'd see if you were working in the
terminal. (You can open the Terminal app on a Mac by going to
/Applications/Utilities/Terminal.)  Consequently, latte tries to guess the
file in which your path is set.  To do so, it first checks if your home
directory (type echo ~/ in the terminal to figure out which directory this is
if you don't know) for the file named .bash_profile.  If this file is
present, it runs it and then checks your system's path variable (echo $PATH).
If it's not present, it does the same for .bashrc and then .profile. In any
case, once it has its best guess at your path, it looks for "latte".

On Windows, latte just uses \code{\link[=Sys.which]{Sys.which()}} on "whereis" to On Windows, latte
just uses \code{\link[=Sys.which]{Sys.which()}} on "whereis" to determine where the executables count
and markov are (for LattE and 4ti2, respectively).
}
\examples{


has_4ti2()
if (has_4ti2()) get_4ti2_path()

has_latte()
if (has_4ti2()) get_latte_path()

# these are stored in your .Renviron file; that's where you should put the 
# path to LattE and 4ti2 executables. for example, you should have a lines 
# that look like
# LATTE=/Applications/latte/bin
# 4TI2=/Applications/latte/bin
# you can set these with usethis::edit_r_environ() 

# you can change these in your current session with set_latte_path() and 
# set_4ti2_path(), for example set_4ti2_path("/path/to/4ti2")


}
\author{
David Kahle \email{david@kahle.io}
}
