% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero-inflated-negative-binomial-distribution.R
\name{ZINB}
\alias{ZINB}
\alias{dzinb}
\alias{pzinb}
\alias{qzinb}
\alias{rzinb}
\title{Zero-inflated negative binomial distribution}
\usage{
dzinb(x, size, prob, pi, log = FALSE)

pzinb(q, size, prob, pi, lower.tail = TRUE, log.p = FALSE)

qzinb(p, size, prob, pi, lower.tail = TRUE, log.p = FALSE)

rzinb(n, size, prob, pi)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{target for number of successful trials, or dispersion
parameter (the shape parameter of the gamma mixing
distribution). Must be strictly positive, need not be
integer.}

\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}

\item{pi}{probability of extra zeros.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the zero-inflated negative binomial distribution.
}
\details{
Probability density function
\deqn{
f(x) = \left\{\begin{array}{ll}
\pi + (1 - \pi) p^r & x = 0 \\
(1 - \pi) {x+r-1 \choose x} p^r (1-p)^x & x > 0 \\
\end{array}\right.
}{
f(x) = [if x = 0:] (1-\pi)+\pi * p^r [else:] (1-\pi) * dnbinom(x, size, prob)
}
}
\examples{

x <- rzinb(1e5, 100, 0.6, 0.33)
xx <- -2:200
plot(prop.table(table(x)), type = "h")
lines(xx, dzinb(xx, 100, 0.6, 0.33), col = "red")

xx <- seq(0, 200, by = 0.01)
plot(ecdf(x))
lines(xx, pzinb(xx, 100, 0.6, 0.33), col = "red")

}
\seealso{
\code{\link[stats]{NegBinomial}}
}
\concept{Discrete}
\concept{Univariate}
\keyword{distribution}
