% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{delta}
\alias{delta}
\title{Generalized Kronecker Delta}
\usage{
delta(n, p = 1)
}
\arguments{
\item{n}{number of elements for each dimension.}

\item{p}{order of the generalized Kronecker delta, \code{p=1} for the standard Kronecker delta.}
}
\value{
\code{array} representing the generalized Kronecker delta tensor.
}
\description{
Computes the Generalized Kronecker Delta.
}
\examples{
### Kronecker delta 3x3
delta(3)

### generalized Kronecker delta 3x3 of order 2
delta(3, p = 2)  

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other tensor algebra: 
\code{\link{contraction}()},
\code{\link{diagonal}()},
\code{\link{einstein}()},
\code{\link{epsilon}()},
\code{\link{index}()}
}
\concept{tensor algebra}
