% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{CoercionToStandard}
\alias{CoercionToStandard}
\alias{as.logical.bit}
\alias{as.integer.bit}
\alias{as.double.bit}
\alias{as.integer.bitwhich}
\alias{as.double.bitwhich}
\alias{as.logical.bitwhich}
\alias{as.logical.ri}
\alias{as.integer.ri}
\alias{as.double.ri}
\alias{as.logical.which}
\title{Coercion from bit, bitwhich, which and ri to logical, integer, double}
\usage{
\method{as.logical}{bit}(x, ...)

\method{as.integer}{bit}(x, ...)

\method{as.double}{bit}(x, ...)

\method{as.integer}{bitwhich}(x, ...)

\method{as.double}{bitwhich}(x, ...)

\method{as.logical}{bitwhich}(x, ...)

\method{as.logical}{ri}(x, ...)

\method{as.integer}{ri}(x, ...)

\method{as.double}{ri}(x, ...)

\method{as.logical}{which}(x, length = attr(x, "maxindex"), ...)
}
\arguments{
\item{x}{an object of class \code{\link{bit}}, \code{\link{bitwhich}} or
\code{\link{ri}}}

\item{\dots}{ignored}

\item{length}{length of the boolean vector (required for \code{as.logical.which})}
}
\value{
\code{\link{as.logical}} returns a vector of \code{FALSE, TRUE},
\code{\link{as.integer}} and \code{\link{as.double}} return a vector of
\code{0,1}.
}
\description{
Coercion from bit is quite fast because we use a double loop that fixes each
word in a processor register.
}
\examples{

  x <- ri(2, 5, 10)
  y <- as.logical(x)
  y
  stopifnot(identical(y, as.logical(as.bit(x))))
  stopifnot(identical(y, as.logical(as.bitwhich(x))))

  y <- as.integer(x)
  y
  stopifnot(identical(y, as.integer(as.logical(x))))
  stopifnot(identical(y, as.integer(as.bit(x))))
  stopifnot(identical(y, as.integer(as.bitwhich(x))))

  y <- as.double(x)
  y
  stopifnot(identical(y, as.double(as.logical(x))))
  stopifnot(identical(y, as.double(as.bit(x))))
  stopifnot(identical(y, as.double(as.bitwhich(x))))
}
\seealso{
\code{\link{CoercionToStandard}}, \code{\link{as.booltype}}, \code{\link{as.bit}}, \code{\link{as.bitwhich}}
, \code{\link{as.which}}, \code{\link{as.ri}}, \code{\link[ff]{as.hi}},  \code{\link[ff]{as.ff}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
