# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AddressSpace(Model):
    """AddressSpace contains an array of IP address ranges that can be used by
    subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this
     virtual network in CIDR notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = kwargs.get('address_prefixes', None)


class Resource(Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySku
    :param ssl_policy: SSL policy of the application gateway resource.
    :type ssl_policy:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway
     resource. Possible values include: 'Stopped', 'Starting', 'Running',
     'Stopping'
    :vartype operational_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Subnets of application the gateway
     resource.
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayIPConfiguration]
    :param authentication_certificates: Authentication certificates of the
     application gateway resource.
    :type authentication_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayAuthenticationCertificate]
    :param ssl_certificates: SSL certificates of the application gateway
     resource.
    :type ssl_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the
     application gateway resource.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
    :type frontend_ports:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application
     gateway resource.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the
     application gateway resource.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
    :type http_listeners:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
    :type url_path_maps:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application
     gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRule]
    :param redirect_configurations: Redirect configurations of the application
     gateway resource.
    :type redirect_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectConfiguration]
    :param web_application_firewall_configuration: Web application firewall
     configuration.
    :type web_application_firewall_configuration:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :param resource_guid: Resource GUID property of the application gateway
     resource.
    :type resource_guid: str
    :param provisioning_state: Provisioning state of the application gateway
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'ssl_policy': {'key': 'properties.sslPolicy', 'type': 'ApplicationGatewaySslPolicy'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[ApplicationGatewayAuthenticationCertificate]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'redirect_configurations': {'key': 'properties.redirectConfigurations', 'type': '[ApplicationGatewayRedirectConfiguration]'},
        'web_application_firewall_configuration': {'key': 'properties.webApplicationFirewallConfiguration', 'type': 'ApplicationGatewayWebApplicationFirewallConfiguration'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGateway, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.ssl_policy = kwargs.get('ssl_policy', None)
        self.operational_state = None
        self.gateway_ip_configurations = kwargs.get('gateway_ip_configurations', None)
        self.authentication_certificates = kwargs.get('authentication_certificates', None)
        self.ssl_certificates = kwargs.get('ssl_certificates', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.frontend_ports = kwargs.get('frontend_ports', None)
        self.probes = kwargs.get('probes', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.backend_http_settings_collection = kwargs.get('backend_http_settings_collection', None)
        self.http_listeners = kwargs.get('http_listeners', None)
        self.url_path_maps = kwargs.get('url_path_maps', None)
        self.request_routing_rules = kwargs.get('request_routing_rules', None)
        self.redirect_configurations = kwargs.get('redirect_configurations', None)
        self.web_application_firewall_configuration = kwargs.get('web_application_firewall_configuration', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class SubResource(Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param data: Certificate public data.
    :type data: str
    :param provisioning_state: Provisioning state of the authentication
     certificate resource. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayAuthenticationCertificate, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param predefined_policies: List of available Ssl predefined policy.
    :type predefined_policies:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param default_policy: Name of the Ssl predefined policy applied by
     default to application gateway. Possible values include:
     'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401',
     'AppGwSslPolicy20170401S'
    :type default_policy: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
    :param available_cipher_suites: List of available Ssl cipher suites.
    :type available_cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :param available_protocols: List of available Ssl protocols.
    :type available_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'predefined_policies': {'key': 'properties.predefinedPolicies', 'type': '[SubResource]'},
        'default_policy': {'key': 'properties.defaultPolicy', 'type': 'str'},
        'available_cipher_suites': {'key': 'properties.availableCipherSuites', 'type': '[str]'},
        'available_protocols': {'key': 'properties.availableProtocols', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayAvailableSslOptions, self).__init__(**kwargs)
        self.predefined_policies = kwargs.get('predefined_policies', None)
        self.default_policy = kwargs.get('default_policy', None)
        self.available_cipher_suites = kwargs.get('available_cipher_suites', None)
        self.available_protocols = kwargs.get('available_protocols', None)


class ApplicationGatewayAvailableWafRuleSetsResult(Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :param value: The list of application gateway rule sets.
    :type value:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewayFirewallRuleSet]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayAvailableWafRuleSetsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ApplicationGatewayBackendAddress(Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.ip_address = kwargs.get('ip_address', None)


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param backend_ip_configurations: Collection of references to IPs defined
     in network interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses
    :type backend_addresses:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddress]
    :param provisioning_state: Provisioning state of the backend address pool
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Resource that is unique within a resource group. This name
     can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendAddressPool, self).__init__(**kwargs)
        self.backend_ip_configurations = kwargs.get('backend_ip_configurations', None)
        self.backend_addresses = kwargs.get('backend_addresses', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayBackendHealth(Model):
    """List of ApplicationGatewayBackendHealthPool resources.

    :param backend_address_pools:
    :type backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        'backend_address_pools': {'key': 'backendAddressPools', 'type': '[ApplicationGatewayBackendHealthPool]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendHealth, self).__init__(**kwargs)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)


class ApplicationGatewayBackendHealthHttpSettings(Model):
    """Application gateway BackendHealthHttp settings.

    :param backend_http_settings: Reference of an
     ApplicationGatewayBackendHttpSettings resource.
    :type backend_http_settings:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings
    :param servers: List of ApplicationGatewayBackendHealthServer resources.
    :type servers:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'ApplicationGatewayBackendHttpSettings'},
        'servers': {'key': 'servers', 'type': '[ApplicationGatewayBackendHealthServer]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendHealthHttpSettings, self).__init__(**kwargs)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.servers = kwargs.get('servers', None)


class ApplicationGatewayBackendHealthPool(Model):
    """Application gateway BackendHealth pool.

    :param backend_address_pool: Reference of an
     ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool
    :param backend_http_settings_collection: List of
     ApplicationGatewayBackendHealthHttpSettings resources.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_http_settings_collection': {'key': 'backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHealthHttpSettings]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendHealthPool, self).__init__(**kwargs)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings_collection = kwargs.get('backend_http_settings_collection', None)


class ApplicationGatewayBackendHealthServer(Model):
    """Application gateway backendhealth http settings.

    :param address: IP address or FQDN of backend server.
    :type address: str
    :param ip_configuration: Reference of IP configuration of backend server.
    :type ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration
    :param health: Health of backend server. Possible values include:
     'Unknown', 'Up', 'Down', 'Partial', 'Draining'
    :type health: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServerHealth
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'ip_configuration': {'key': 'ipConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'health': {'key': 'health', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendHealthServer, self).__init__(**kwargs)
        self.address = kwargs.get('address', None)
        self.ip_configuration = kwargs.get('ip_configuration', None)
        self.health = kwargs.get('health', None)


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param port: Port
    :type port: int
    :param protocol: Protocol. Possible values include: 'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values
     include: 'Enabled', 'Disabled'
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway
     will fail the request if response is not received within RequestTimeout.
     Acceptable values are from 1 second to 86400 seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param authentication_certificates: Array of references to application
     gateway authentication certificates.
    :type authentication_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param connection_draining: Connection draining of the backend http
     settings resource.
    :type connection_draining:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayConnectionDraining
    :param host_name: Host header to be sent to the backend servers.
    :type host_name: str
    :param pick_host_name_from_backend_address: Whether to pick host header
     should be picked from the host name of the backend server. Default value
     is false.
    :type pick_host_name_from_backend_address: bool
    :param affinity_cookie_name: Cookie name to use for the affinity cookie.
    :type affinity_cookie_name: str
    :param probe_enabled: Whether the probe is enabled. Default value is
     false.
    :type probe_enabled: bool
    :param path: Path which should be used as a prefix for all HTTP requests.
     Null means no path will be prefixed. Default value is null.
    :type path: str
    :param provisioning_state: Provisioning state of the backend http settings
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[SubResource]'},
        'connection_draining': {'key': 'properties.connectionDraining', 'type': 'ApplicationGatewayConnectionDraining'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'pick_host_name_from_backend_address': {'key': 'properties.pickHostNameFromBackendAddress', 'type': 'bool'},
        'affinity_cookie_name': {'key': 'properties.affinityCookieName', 'type': 'str'},
        'probe_enabled': {'key': 'properties.probeEnabled', 'type': 'bool'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)
        self.protocol = kwargs.get('protocol', None)
        self.cookie_based_affinity = kwargs.get('cookie_based_affinity', None)
        self.request_timeout = kwargs.get('request_timeout', None)
        self.probe = kwargs.get('probe', None)
        self.authentication_certificates = kwargs.get('authentication_certificates', None)
        self.connection_draining = kwargs.get('connection_draining', None)
        self.host_name = kwargs.get('host_name', None)
        self.pick_host_name_from_backend_address = kwargs.get('pick_host_name_from_backend_address', None)
        self.affinity_cookie_name = kwargs.get('affinity_cookie_name', None)
        self.probe_enabled = kwargs.get('probe_enabled', None)
        self.path = kwargs.get('path', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayConnectionDraining(Model):
    """Connection draining allows open connections to a backend server to be
    active for a specified time after the backend server got removed from the
    configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether connection draining is enabled or not.
    :type enabled: bool
    :param drain_timeout_in_sec: Required. The number of seconds connection
     draining is active. Acceptable values are from 1 second to 3600 seconds.
    :type drain_timeout_in_sec: int
    """

    _validation = {
        'enabled': {'required': True},
        'drain_timeout_in_sec': {'required': True, 'maximum': 3600, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'drain_timeout_in_sec': {'key': 'drainTimeoutInSec', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayConnectionDraining, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.drain_timeout_in_sec = kwargs.get('drain_timeout_in_sec', None)


class ApplicationGatewayFirewallDisabledRuleGroup(Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the rule group that will be
     disabled.
    :type rule_group_name: str
    :param rules: The list of rules that will be disabled. If null, all rules
     of the rule group will be disabled.
    :type rules: list[int]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[int]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFirewallDisabledRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = kwargs.get('rule_group_name', None)
        self.rules = kwargs.get('rules', None)


class ApplicationGatewayFirewallRule(Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. The identifier of the web application firewall
     rule.
    :type rule_id: int
    :param description: The description of the web application firewall rule.
    :type description: str
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFirewallRule, self).__init__(**kwargs)
        self.rule_id = kwargs.get('rule_id', None)
        self.description = kwargs.get('description', None)


class ApplicationGatewayFirewallRuleGroup(Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the web application firewall
     rule group.
    :type rule_group_name: str
    :param description: The description of the web application firewall rule
     group.
    :type description: str
    :param rules: Required. The rules of the web application firewall rule
     group.
    :type rules:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        'rule_group_name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ApplicationGatewayFirewallRule]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFirewallRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = kwargs.get('rule_group_name', None)
        self.description = kwargs.get('description', None)
        self.rules = kwargs.get('rules', None)


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param provisioning_state: The provisioning state of the web application
     firewall rule set.
    :type provisioning_state: str
    :param rule_set_type: Required. The type of the web application firewall
     rule set.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the web application
     firewall rule set type.
    :type rule_set_version: str
    :param rule_groups: Required. The rule groups of the web application
     firewall rule set.
    :type rule_groups:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'rule_groups': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ApplicationGatewayFirewallRuleGroup]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFirewallRuleSet, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.rule_set_type = kwargs.get('rule_set_type', None)
        self.rule_set_version = kwargs.get('rule_set_version', None)
        self.rule_groups = kwargs.get('rule_groups', None)


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param private_ip_address: PrivateIPAddress of the network interface IP
     Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: PrivateIP allocation method. Possible
     values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Provisioning state of the public IP resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(**kwargs)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param port: Frontend port
    :type port: int
    :param provisioning_state: Provisioning state of the frontend port
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayFrontendPort, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an
     application gateway.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param protocol: Protocol. Possible values include: 'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application
     gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is
     https. Enables SNI for multi-hosting.
    :type require_server_name_indication: bool
    :param provisioning_state: Provisioning state of the HTTP listener
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayHttpListener, self).__init__(**kwargs)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.protocol = kwargs.get('protocol', None)
        self.host_name = kwargs.get('host_name', None)
        self.ssl_certificate = kwargs.get('ssl_certificate', None)
        self.require_server_name_indication = kwargs.get('require_server_name_indication', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1
    private IP configuration is allowed.

    :param id: Resource ID.
    :type id: str
    :param subnet: Reference of the subnet resource. A subnet from where
     application gateway gets its private address.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Provisioning state of the application gateway
     subnet resource. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayIPConfiguration, self).__init__(**kwargs)
        self.subnet = kwargs.get('subnet', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map
     path rule.
    :type backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path
     map path rule.
    :type backend_http_settings:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of URL path
     map path rule.
    :type redirect_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Path rule of URL path map resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayPathRule, self).__init__(**kwargs)
        self.paths = kwargs.get('paths', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.redirect_configuration = kwargs.get('redirect_configuration', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    :param id: Resource ID.
    :type id: str
    :param protocol: Protocol. Possible values include: 'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is
     sent to <Protocol>://<host>:<port><path>
    :type path: str
    :param interval: The probing interval in seconds. This is the time
     interval between two consecutive probes. Acceptable values are from 1
     second to 86400 seconds.
    :type interval: int
    :param timeout: the probe timeout in seconds. Probe marked as failed if
     valid response is not received with this timeout period. Acceptable values
     are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is
     marked down after consecutive probe failure count reaches
     UnhealthyThreshold. Acceptable values are from 1 second to 20.
    :type unhealthy_threshold: int
    :param pick_host_name_from_backend_http_settings: Whether the host header
     should be picked from the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param min_servers: Minimum number of servers that are always marked
     healthy. Default value is 0.
    :type min_servers: int
    :param match: Criterion for classifying a healthy probe response.
    :type match:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbeHealthResponseMatch
    :param provisioning_state: Provisioning state of the backend http settings
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'properties.pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'min_servers': {'key': 'properties.minServers', 'type': 'int'},
        'match': {'key': 'properties.match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayProbe, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.host = kwargs.get('host', None)
        self.path = kwargs.get('path', None)
        self.interval = kwargs.get('interval', None)
        self.timeout = kwargs.get('timeout', None)
        self.unhealthy_threshold = kwargs.get('unhealthy_threshold', None)
        self.pick_host_name_from_backend_http_settings = kwargs.get('pick_host_name_from_backend_http_settings', None)
        self.min_servers = kwargs.get('min_servers', None)
        self.match = kwargs.get('match', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayProbeHealthResponseMatch(Model):
    """Application gateway probe health response match.

    :param body: Body that must be contained in the health response. Default
     value is empty.
    :type body: str
    :param status_codes: Allowed ranges of healthy status codes. Default range
     of healthy status codes is 200-399.
    :type status_codes: list[str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'status_codes': {'key': 'statusCodes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayProbeHealthResponseMatch, self).__init__(**kwargs)
        self.body = kwargs.get('body', None)
        self.status_codes = kwargs.get('status_codes', None)


class ApplicationGatewayRedirectConfiguration(SubResource):
    """Redirect configuration of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param redirect_type: Supported http redirection types - Permanent,
     Temporary, Found, SeeOther. Possible values include: 'Permanent', 'Found',
     'SeeOther', 'Temporary'
    :type redirect_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectType
    :param target_listener: Reference to a listener to redirect the request
     to.
    :type target_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param target_url: Url to redirect the request to.
    :type target_url: str
    :param include_path: Include path in the redirected url.
    :type include_path: bool
    :param include_query_string: Include query string in the redirected url.
    :type include_query_string: bool
    :param request_routing_rules: Request routing specifying redirect
     configuration.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param url_path_maps: Url path maps specifying default redirect
     configuration.
    :type url_path_maps:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param path_rules: Path rules specifying redirect configuration.
    :type path_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'redirect_type': {'key': 'properties.redirectType', 'type': 'str'},
        'target_listener': {'key': 'properties.targetListener', 'type': 'SubResource'},
        'target_url': {'key': 'properties.targetUrl', 'type': 'str'},
        'include_path': {'key': 'properties.includePath', 'type': 'bool'},
        'include_query_string': {'key': 'properties.includeQueryString', 'type': 'bool'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[SubResource]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[SubResource]'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[SubResource]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayRedirectConfiguration, self).__init__(**kwargs)
        self.redirect_type = kwargs.get('redirect_type', None)
        self.target_listener = kwargs.get('target_listener', None)
        self.target_url = kwargs.get('target_url', None)
        self.include_path = kwargs.get('include_path', None)
        self.include_query_string = kwargs.get('include_query_string', None)
        self.request_routing_rules = kwargs.get('request_routing_rules', None)
        self.url_path_maps = kwargs.get('url_path_maps', None)
        self.path_rules = kwargs.get('path_rules', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param rule_type: Rule type. Possible values include: 'Basic',
     'PathBasedRouting'
    :type rule_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRuleType
    :param backend_address_pool: Backend address pool resource of the
     application gateway.
    :type backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param backend_http_settings: Frontend port resource of the application
     gateway.
    :type backend_http_settings:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of the
     application gateway.
    :type redirect_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Provisioning state of the request routing rule
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(**kwargs)
        self.rule_type = kwargs.get('rule_type', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.http_listener = kwargs.get('http_listener', None)
        self.url_path_map = kwargs.get('url_path_map', None)
        self.redirect_configuration = kwargs.get('redirect_configuration', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewaySku(Model):
    """SKU of an application gateway.

    :param name: Name of an application gateway SKU. Possible values include:
     'Standard_Small', 'Standard_Medium', 'Standard_Large', 'WAF_Medium',
     'WAF_Large'
    :type name: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySkuName
    :param tier: Tier of an application gateway. Possible values include:
     'Standard', 'WAF'
    :type tier: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayTier
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT
     Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only
     applicable in PUT request.
    :type password: str
    :param public_cert_data: Base-64 encoded Public cert data corresponding to
     pfx specified in data. Only applicable in GET request.
    :type public_cert_data: str
    :param provisioning_state: Provisioning state of the SSL certificate
     resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewaySslCertificate, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.password = kwargs.get('password', None)
        self.public_cert_data = kwargs.get('public_cert_data', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewaySslPolicy(Model):
    """Application Gateway Ssl policy.

    :param disabled_ssl_protocols: Ssl protocols to be disabled on application
     gateway.
    :type disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
    :param policy_type: Type of Ssl Policy. Possible values include:
     'Predefined', 'Custom'
    :type policy_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyType
    :param policy_name: Name of Ssl predefined policy. Possible values
     include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401',
     'AppGwSslPolicy20170401S'
    :type policy_name: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
    :param cipher_suites: Ssl cipher suites to be enabled in the specified
     order to application gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be
     supported on application gateway. Possible values include: 'TLSv1_0',
     'TLSv1_1', 'TLSv1_2'
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'disabled_ssl_protocols': {'key': 'disabledSslProtocols', 'type': '[str]'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'cipher_suites': {'key': 'cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'minProtocolVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewaySslPolicy, self).__init__(**kwargs)
        self.disabled_ssl_protocols = kwargs.get('disabled_ssl_protocols', None)
        self.policy_type = kwargs.get('policy_type', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.cipher_suites = kwargs.get('cipher_suites', None)
        self.min_protocol_version = kwargs.get('min_protocol_version', None)


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :param id: Resource ID.
    :type id: str
    :param name: Name of Ssl predefined policy.
    :type name: str
    :param cipher_suites: Ssl cipher suites to be enabled in the specified
     order for application gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be
     supported on application gateway. Possible values include: 'TLSv1_0',
     'TLSv1_1', 'TLSv1_2'
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'cipher_suites': {'key': 'properties.cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'properties.minProtocolVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewaySslPredefinedPolicy, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.cipher_suites = kwargs.get('cipher_suites', None)
        self.min_protocol_version = kwargs.get('min_protocol_version', None)


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for
    PathBasedRouting.

    :param id: Resource ID.
    :type id: str
    :param default_backend_address_pool: Default backend address pool resource
     of URL path map.
    :type default_backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param default_backend_http_settings: Default backend http settings
     resource of URL path map.
    :type default_backend_http_settings:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param default_redirect_configuration: Default redirect configuration
     resource of URL path map.
    :type default_redirect_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayPathRule]
    :param provisioning_state: Provisioning state of the backend http settings
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'default_redirect_configuration': {'key': 'properties.defaultRedirectConfiguration', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayUrlPathMap, self).__init__(**kwargs)
        self.default_backend_address_pool = kwargs.get('default_backend_address_pool', None)
        self.default_backend_http_settings = kwargs.get('default_backend_http_settings', None)
        self.default_redirect_configuration = kwargs.get('default_redirect_configuration', None)
        self.path_rules = kwargs.get('path_rules', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.type = kwargs.get('type', None)


class ApplicationGatewayWebApplicationFirewallConfiguration(Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the web application firewall is enabled
     or not.
    :type enabled: bool
    :param firewall_mode: Required. Web application firewall mode. Possible
     values include: 'Detection', 'Prevention'
    :type firewall_mode: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallMode
    :param rule_set_type: Required. The type of the web application firewall
     rule set. Possible values are: 'OWASP'.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the rule set type.
    :type rule_set_version: str
    :param disabled_rule_groups: The disabled rule groups.
    :type disabled_rule_groups:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    """

    _validation = {
        'enabled': {'required': True},
        'firewall_mode': {'required': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'disabled_rule_groups': {'key': 'disabledRuleGroups', 'type': '[ApplicationGatewayFirewallDisabledRuleGroup]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayWebApplicationFirewallConfiguration, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.firewall_mode = kwargs.get('firewall_mode', None)
        self.rule_set_type = kwargs.get('rule_set_type', None)
        self.rule_set_version = kwargs.get('rule_set_version', None)
        self.disabled_rule_groups = kwargs.get('disabled_rule_groups', None)


class AzureAsyncOperationResult(Model):
    """The response body contains the status of the specified asynchronous
    operation, indicating whether it has succeeded, is in progress, or has
    failed. Note that this status is distinct from the HTTP status code
    returned for the Get Operation Status operation itself. If the asynchronous
    operation succeeded, the response body includes the HTTP status code for
    the successful request. If the asynchronous operation failed, the response
    body includes the HTTP status code for the failed request and error
    information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are:
     'InProgress', 'Succeeded', and 'Failed'. Possible values include:
     'InProgress', 'Succeeded', 'Failed'
    :type status: str or
     ~azure.mgmt.network.v2017_06_01.models.NetworkOperationStatus
    :param error:
    :type error: ~azure.mgmt.network.v2017_06_01.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(self, **kwargs):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar backend_ip_configurations: Gets collection of references to IP
     addresses defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this
     backend address pool.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar outbound_nat_rule: Gets outbound rules that use this backend address
     pool.
    :vartype outbound_nat_rule:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Get provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'backend_ip_configurations': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'outbound_nat_rule': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackendAddressPool, self).__init__(**kwargs)
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_nat_rule = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class BGPCommunity(Model):
    """Contains bgp community information offered in Service Community resources.

    :param service_supported_region: The region which the service support.
     e.g. For O365, region is Global.
    :type service_supported_region: str
    :param community_name: The name of the bgp community. e.g. Skype.
    :type community_name: str
    :param community_value: The value of the bgp community. For more
     information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :type community_value: str
    :param community_prefixes: The prefixes that the bgp community contains.
    :type community_prefixes: list[str]
    :param is_authorized_to_use: Customer is authorized to use bgp community
     or not.
    :type is_authorized_to_use: bool
    :param service_group: The service group of the bgp community contains.
    :type service_group: str
    """

    _attribute_map = {
        'service_supported_region': {'key': 'serviceSupportedRegion', 'type': 'str'},
        'community_name': {'key': 'communityName', 'type': 'str'},
        'community_value': {'key': 'communityValue', 'type': 'str'},
        'community_prefixes': {'key': 'communityPrefixes', 'type': '[str]'},
        'is_authorized_to_use': {'key': 'isAuthorizedToUse', 'type': 'bool'},
        'service_group': {'key': 'serviceGroup', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BGPCommunity, self).__init__(**kwargs)
        self.service_supported_region = kwargs.get('service_supported_region', None)
        self.community_name = kwargs.get('community_name', None)
        self.community_value = kwargs.get('community_value', None)
        self.community_prefixes = kwargs.get('community_prefixes', None)
        self.is_authorized_to_use = kwargs.get('is_authorized_to_use', None)
        self.service_group = kwargs.get('service_group', None)


class BgpPeerStatus(Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar local_address: The virtual network gateway's local address
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer
    :vartype asn: int
    :ivar state: The BGP peer state. Possible values include: 'Unknown',
     'Stopped', 'Idle', 'Connecting', 'Connected'
    :vartype state: str or ~azure.mgmt.network.v2017_06_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer
    :vartype routes_received: long
    :ivar messages_sent: The number of BGP messages sent
    :vartype messages_sent: long
    :ivar messages_received: The number of BGP messages received
    :vartype messages_received: long
    """

    _validation = {
        'local_address': {'readonly': True},
        'neighbor': {'readonly': True},
        'asn': {'readonly': True},
        'state': {'readonly': True},
        'connected_duration': {'readonly': True},
        'routes_received': {'readonly': True},
        'messages_sent': {'readonly': True},
        'messages_received': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'connected_duration': {'key': 'connectedDuration', 'type': 'str'},
        'routes_received': {'key': 'routesReceived', 'type': 'long'},
        'messages_sent': {'key': 'messagesSent', 'type': 'long'},
        'messages_received': {'key': 'messagesReceived', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(BgpPeerStatus, self).__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(Model):
    """Response for list BGP peer status API service call.

    :param value: List of BGP peers
    :type value: list[~azure.mgmt.network.v2017_06_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpPeerStatus]'},
    }

    def __init__(self, **kwargs):
        super(BgpPeerStatusListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param service_name: The name of the bgp community. e.g. Skype.
    :type service_name: str
    :param bgp_communities: Get a list of bgp communities.
    :type bgp_communities:
     list[~azure.mgmt.network.v2017_06_01.models.BGPCommunity]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': '[BGPCommunity]'},
    }

    def __init__(self, **kwargs):
        super(BgpServiceCommunity, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.bgp_communities = kwargs.get('bgp_communities', None)


class BgpSettings(Model):
    """BGP settings details.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of
     this BGP speaker.
    :type bgp_peering_address: str
    :param peer_weight: The weight added to routes learned from this BGP
     speaker.
    :type peer_weight: int
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = kwargs.get('asn', None)
        self.bgp_peering_address = kwargs.get('bgp_peering_address', None)
        self.peer_weight = kwargs.get('peer_weight', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConnectionResetSharedKey(Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :param key_length: Required. The virtual network connection reset shared
     key length, should between 1 and 128.
    :type key_length: int
    """

    _validation = {
        'key_length': {'required': True, 'maximum': 128, 'minimum': 1},
    }

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = kwargs.get('key_length', None)


class ConnectionSharedKey(Model):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The virtual network connection shared key value.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConnectionSharedKey, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ConnectivityDestination(Model):
    """Parameters that define destination of connection.

    :param resource_id: The ID of the resource to which a connection attempt
     will be made.
    :type resource_id: str
    :param address: The IP address or URI the resource to which a connection
     attempt will be made.
    :type address: str
    :param port: Port on which check connectivity will be performed.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.address = kwargs.get('address', None)
        self.port = kwargs.get('port', None)


class ConnectivityHop(Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues:
     list[~azure.mgmt.network.v2017_06_01.models.ConnectivityIssue]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'address': {'readonly': True},
        'resource_id': {'readonly': True},
        'next_hop_ids': {'readonly': True},
        'issues': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'next_hop_ids': {'key': 'nextHopIds', 'type': '[str]'},
        'issues': {'key': 'issues', 'type': '[ConnectivityIssue]'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityHop, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops:
     list[~azure.mgmt.network.v2017_06_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Possible values include:
     'Unknown', 'Connected', 'Disconnected', 'Degraded'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        'hops': {'readonly': True},
        'connection_status': {'readonly': True},
        'avg_latency_in_ms': {'readonly': True},
        'min_latency_in_ms': {'readonly': True},
        'max_latency_in_ms': {'readonly': True},
        'probes_sent': {'readonly': True},
        'probes_failed': {'readonly': True},
    }

    _attribute_map = {
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityInformation, self).__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(Model):
    """Information about an issue encountered in the process of checking for
    connectivity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the issue. Possible values include: 'Local',
     'Inbound', 'Outbound'
    :vartype origin: str or ~azure.mgmt.network.v2017_06_01.models.Origin
    :ivar severity: The severity of the issue. Possible values include:
     'Error', 'Warning'
    :vartype severity: str or ~azure.mgmt.network.v2017_06_01.models.Severity
    :ivar type: The type of issue. Possible values include: 'Unknown',
     'AgentStopped', 'GuestFirewall', 'DnsResolution', 'SocketBind',
     'NetworkSecurityRule', 'UserDefinedRoute', 'PortThrottled', 'Platform'
    :vartype type: str or ~azure.mgmt.network.v2017_06_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        'origin': {'readonly': True},
        'severity': {'readonly': True},
        'type': {'readonly': True},
        'context': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'context': {'key': 'context', 'type': '[{str}]'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityIssue, self).__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :param source: Required.
    :type source: ~azure.mgmt.network.v2017_06_01.models.ConnectivitySource
    :param destination: Required.
    :type destination:
     ~azure.mgmt.network.v2017_06_01.models.ConnectivityDestination
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectivitySource'},
        'destination': {'key': 'destination', 'type': 'ConnectivityDestination'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityParameters, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.destination = kwargs.get('destination', None)


class ConnectivitySource(Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource from which a
     connectivity check will be initiated.
    :type resource_id: str
    :param port: The source port from which a connectivity check will be
     performed.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConnectivitySource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.port = kwargs.get('port', None)


class DhcpOptions(Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in
    the virtual network. Standard DHCP option for a subnet overrides VNET DHCP
    options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)


class DnsNameAvailabilityResult(Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)


class EffectiveNetworkSecurityGroup(Model):
    """Effective network security group.

    :param network_security_group: The ID of network security group that is
     applied.
    :type network_security_group:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param association: Associated resources.
    :type association:
     ~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroupAssociation
    :param effective_security_rules: A collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
    :param tag_map: Mapping of tags to list of IP Addresses included within
     the tag.
    :type tag_map: dict[str, list[str]]
    """

    _attribute_map = {
        'network_security_group': {'key': 'networkSecurityGroup', 'type': 'SubResource'},
        'association': {'key': 'association', 'type': 'EffectiveNetworkSecurityGroupAssociation'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
        'tag_map': {'key': 'tagMap', 'type': '{[str]}'},
    }

    def __init__(self, **kwargs):
        super(EffectiveNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.association = kwargs.get('association', None)
        self.effective_security_rules = kwargs.get('effective_security_rules', None)
        self.tag_map = kwargs.get('tag_map', None)


class EffectiveNetworkSecurityGroupAssociation(Model):
    """The effective network security group association.

    :param subnet: The ID of the subnet if assigned.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param network_interface: The ID of the network interface if assigned.
    :type network_interface:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'network_interface': {'key': 'networkInterface', 'type': 'SubResource'},
    }

    def __init__(self, **kwargs):
        super(EffectiveNetworkSecurityGroupAssociation, self).__init__(**kwargs)
        self.subnet = kwargs.get('subnet', None)
        self.network_interface = kwargs.get('network_interface', None)


class EffectiveNetworkSecurityGroupListResult(Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: A list of effective network security groups.
    :type value:
     list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveNetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EffectiveNetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EffectiveNetworkSecurityRule(Model):
    """Effective network security rules.

    :param name: The name of the security rule specified by the user (if
     created by the user).
    :type name: str
    :param protocol: The network protocol this rule applies to. Possible
     values are: 'Tcp', 'Udp', and 'All'. Possible values include: 'Tcp',
     'Udp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.EffectiveSecurityRuleProtocol
    :param source_port_range: The source port or range.
    :type source_port_range: str
    :param destination_port_range: The destination port or range.
    :type destination_port_range: str
    :param source_port_ranges: The source port ranges. Expected values include
     a single integer between 0 and 65535, a range using '-' as separator (e.g.
     100-400), or an asterisk (*)
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges. Expected
     values include a single integer between 0 and 65535, a range using '-' as
     separator (e.g. 100-400), or an asterisk (*)
    :type destination_port_ranges: list[str]
    :param source_address_prefix: The source address prefix.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix.
    :type destination_address_prefix: str
    :param source_address_prefixes: The source address prefixes. Expected
     values include CIDR IP ranges, Default Tags (VirtualNetwork,
     AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
    :type source_address_prefixes: list[str]
    :param destination_address_prefixes: The destination address prefixes.
     Expected values include CIDR IP ranges, Default Tags (VirtualNetwork,
     AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
    :type destination_address_prefixes: list[str]
    :param expanded_source_address_prefix: The expanded source address prefix.
    :type expanded_source_address_prefix: list[str]
    :param expanded_destination_address_prefix: Expanded destination address
     prefix.
    :type expanded_destination_address_prefix: list[str]
    :param access: Whether network traffic is allowed or denied. Possible
     values are: 'Allow' and 'Deny'. Possible values include: 'Allow', 'Deny'
    :type access: str or
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
    :param priority: The priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. Possible values are: 'Inbound
     and Outbound'. Possible values include: 'Inbound', 'Outbound'
    :type direction: str or
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'expanded_source_address_prefix': {'key': 'expandedSourceAddressPrefix', 'type': '[str]'},
        'expanded_destination_address_prefix': {'key': 'expandedDestinationAddressPrefix', 'type': '[str]'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EffectiveNetworkSecurityRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.source_port_range = kwargs.get('source_port_range', None)
        self.destination_port_range = kwargs.get('destination_port_range', None)
        self.source_port_ranges = kwargs.get('source_port_ranges', None)
        self.destination_port_ranges = kwargs.get('destination_port_ranges', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.destination_address_prefix = kwargs.get('destination_address_prefix', None)
        self.source_address_prefixes = kwargs.get('source_address_prefixes', None)
        self.destination_address_prefixes = kwargs.get('destination_address_prefixes', None)
        self.expanded_source_address_prefix = kwargs.get('expanded_source_address_prefix', None)
        self.expanded_destination_address_prefix = kwargs.get('expanded_destination_address_prefix', None)
        self.access = kwargs.get('access', None)
        self.priority = kwargs.get('priority', None)
        self.direction = kwargs.get('direction', None)


class EffectiveRoute(Model):
    """Effective Route.

    :param name: The name of the user defined route. This is optional.
    :type name: str
    :param source: Who created the route. Possible values are: 'Unknown',
     'User', 'VirtualNetworkGateway', and 'Default'. Possible values include:
     'Unknown', 'User', 'VirtualNetworkGateway', 'Default'
    :type source: str or
     ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteSource
    :param state: The value of effective route. Possible values are: 'Active'
     and 'Invalid'. Possible values include: 'Active', 'Invalid'
    :type state: str or
     ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteState
    :param address_prefix: The address prefixes of the effective routes in
     CIDR notation.
    :type address_prefix: list[str]
    :param next_hop_ip_address: The IP address of the next hop of the
     effective route.
    :type next_hop_ip_address: list[str]
    :param next_hop_type: The type of Azure hop the packet should be sent to.
     Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet',
     'VirtualAppliance', and 'None'. Possible values include:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance',
     'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'address_prefix': {'key': 'addressPrefix', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EffectiveRoute, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.source = kwargs.get('source', None)
        self.state = kwargs.get('state', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)


class EffectiveRouteListResult(Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: A list of effective routes.
    :type value: list[~azure.mgmt.network.v2017_06_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveRoute]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EffectiveRouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EndpointServiceResult, self).__init__(**kwargs)
        self.name = None
        self.type = None


class Error(Model):
    """Error.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.network.v2017_06_01.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)


class ErrorDetails(Model):
    """ErrorDetails.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSku
    :param allow_classic_operations: Allow classic operations
    :type allow_classic_operations: bool
    :param circuit_provisioning_state: The CircuitProvisioningState state of
     the resource.
    :type circuit_provisioning_state: str
    :param service_provider_provisioning_state: The
     ServiceProviderProvisioningState state of the resource. Possible values
     are 'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'.
     Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned',
     'Deprovisioning'
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :param service_key: The ServiceKey.
    :type service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitServiceProviderProperties
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'allow_classic_operations': {'key': 'properties.allowClassicOperations', 'type': 'bool'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuit, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.allow_classic_operations = kwargs.get('allow_classic_operations', None)
        self.circuit_provisioning_state = kwargs.get('circuit_provisioning_state', None)
        self.service_provider_provisioning_state = kwargs.get('service_provider_provisioning_state', None)
        self.authorizations = kwargs.get('authorizations', None)
        self.peerings = kwargs.get('peerings', None)
        self.service_key = kwargs.get('service_key', None)
        self.service_provider_notes = kwargs.get('service_provider_notes', None)
        self.service_provider_properties = kwargs.get('service_provider_properties', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.gateway_manager_etag = kwargs.get('gateway_manager_etag', None)
        self.etag = None


class ExpressRouteCircuitArpTable(Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param age: Age
    :type age: int
    :param interface: Interface
    :type interface: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'age': {'key': 'age', 'type': 'int'},
        'interface': {'key': 'interface', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.age = kwargs.get('age', None)
        self.interface = kwargs.get('interface', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.mac_address = kwargs.get('mac_address', None)


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param authorization_use_status: AuthorizationUseStatus. Possible values
     are: 'Available' and 'InUse'. Possible values include: 'Available',
     'InUse'
    :type authorization_use_status: str or
     ~azure.mgmt.network.v2017_06_01.models.AuthorizationUseStatus
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitAuthorization, self).__init__(**kwargs)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.authorization_use_status = kwargs.get('authorization_use_status', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = None


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param peering_type: The PeeringType. Possible values are:
     'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'.
     Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering',
     'MicrosoftPeering'
    :type peering_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringType
    :param state: The state of peering. Possible values are: 'Disabled' and
     'Enabled'. Possible values include: 'Disabled', 'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
    :param azure_asn: The Azure ASN.
    :type azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: int
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param primary_azure_port: The primary port.
    :type primary_azure_port: str
    :param secondary_azure_port: The secondary port.
    :type secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
    :param stats: Gets peering stats.
    :type stats:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitStats
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :param last_modified_by: Gets whether the provider or the customer last
     modified the peering.
    :type last_modified_by: str
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'int'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'route_filter': {'key': 'properties.routeFilter', 'type': 'RouteFilter'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitPeering, self).__init__(**kwargs)
        self.peering_type = kwargs.get('peering_type', None)
        self.state = kwargs.get('state', None)
        self.azure_asn = kwargs.get('azure_asn', None)
        self.peer_asn = kwargs.get('peer_asn', None)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.primary_azure_port = kwargs.get('primary_azure_port', None)
        self.secondary_azure_port = kwargs.get('secondary_azure_port', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.vlan_id = kwargs.get('vlan_id', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.stats = kwargs.get('stats', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.gateway_manager_etag = kwargs.get('gateway_manager_etag', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.route_filter = kwargs.get('route_filter', None)
        self.ipv6_peering_config = kwargs.get('ipv6_peering_config', None)
        self.name = kwargs.get('name', None)
        self.etag = None


class ExpressRouteCircuitPeeringConfig(Model):
    """Specifies the peering configuration.

    :param advertised_public_prefixes: The reference of
     AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_communities: The communities of bgp peering. Specified
     for microsoft peering
    :type advertised_communities: list[str]
    :param advertised_public_prefixes_state: AdvertisedPublicPrefixState of
     the Peering resource. Possible values are 'NotConfigured', 'Configuring',
     'Configured', and 'ValidationNeeded'. Possible values include:
     'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
    :type advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param legacy_mode: The legacy mode of the peering.
    :type legacy_mode: int
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the
     configuration.
    :type routing_registry_name: str
    """

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_communities': {'key': 'advertisedCommunities', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'legacy_mode': {'key': 'legacyMode', 'type': 'int'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = kwargs.get('advertised_public_prefixes', None)
        self.advertised_communities = kwargs.get('advertised_communities', None)
        self.advertised_public_prefixes_state = kwargs.get('advertised_public_prefixes_state', None)
        self.legacy_mode = kwargs.get('legacy_mode', None)
        self.customer_asn = kwargs.get('customer_asn', None)
        self.routing_registry_name = kwargs.get('routing_registry_name', None)


class ExpressRouteCircuitRoutesTable(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param network: network
    :type network: str
    :param next_hop: nextHop
    :type next_hop: str
    :param loc_prf: locPrf
    :type loc_prf: str
    :param weight: weight.
    :type weight: int
    :param path: path
    :type path: str
    """

    _attribute_map = {
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'loc_prf': {'key': 'locPrf', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.network = kwargs.get('network', None)
        self.next_hop = kwargs.get('next_hop', None)
        self.loc_prf = kwargs.get('loc_prf', None)
        self.weight = kwargs.get('weight', None)
        self.path = kwargs.get('path', None)


class ExpressRouteCircuitRoutesTableSummary(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: Neighbor
    :type neighbor: str
    :param v: BGP version number spoken to the neighbor.
    :type v: int
    :param as_property: Autonomous system number.
    :type as_property: int
    :param up_down: The length of time that the BGP session has been in the
     Established state, or the current status if not in the Established state.
    :type up_down: str
    :param state_pfx_rcd: Current state of the BGP session, and the number of
     prefixes that have been received from a neighbor or peer group.
    :type state_pfx_rcd: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'v': {'key': 'v', 'type': 'int'},
        'as_property': {'key': 'as', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_pfx_rcd': {'key': 'statePfxRcd', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = kwargs.get('neighbor', None)
        self.v = kwargs.get('v', None)
        self.as_property = kwargs.get('as_property', None)
        self.up_down = kwargs.get('up_down', None)
        self.state_pfx_rcd = kwargs.get('state_pfx_rcd', None)


class ExpressRouteCircuitsArpTableListResult(Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: Gets list of the ARP table.
    :type value:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitServiceProviderProperties(Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = kwargs.get('service_provider_name', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)


class ExpressRouteCircuitSku(Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values are 'Standard' and
     'Premium'. Possible values include: 'Standard', 'Premium', 'Transport'
    :type tier: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values are: 'UnlimitedData'
     and 'MeteredData'. Possible values include: 'UnlimitedData', 'MeteredData'
    :type family: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.family = kwargs.get('family', None)


class ExpressRouteCircuitsRoutesTableListResult(Model):
    """Response for ListRoutesTable associated with the Express Route Circuits
    API.

    :param value: The list of routes table.
    :type value:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitsRoutesTableSummaryListResult(Model):
    """Response for ListRoutesTable associated with the Express Route Circuits
    API.

    :param value: A list of the routes table.
    :type value:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTableSummary]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitStats(Model):
    """Contains stats associated with the peering.

    :param primarybytes_in: Gets BytesIn of the peering.
    :type primarybytes_in: long
    :param primarybytes_out: Gets BytesOut of the peering.
    :type primarybytes_out: long
    :param secondarybytes_in: Gets BytesIn of the peering.
    :type secondarybytes_in: long
    :param secondarybytes_out: Gets BytesOut of the peering.
    :type secondarybytes_out: long
    """

    _attribute_map = {
        'primarybytes_in': {'key': 'primarybytesIn', 'type': 'long'},
        'primarybytes_out': {'key': 'primarybytesOut', 'type': 'long'},
        'secondarybytes_in': {'key': 'secondarybytesIn', 'type': 'long'},
        'secondarybytes_out': {'key': 'secondarybytesOut', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.primarybytes_in = kwargs.get('primarybytes_in', None)
        self.primarybytes_out = kwargs.get('primarybytes_out', None)
        self.secondarybytes_in = kwargs.get('secondarybytes_in', None)
        self.secondarybytes_out = kwargs.get('secondarybytes_out', None)


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: Get a list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: Gets bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :param provisioning_state: Gets the provisioning state of the resource.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteServiceProvider, self).__init__(**kwargs)
        self.peering_locations = kwargs.get('peering_locations', None)
        self.bandwidths_offered = kwargs.get('bandwidths_offered', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ExpressRouteServiceProviderBandwidthsOffered(Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = kwargs.get('offer_name', None)
        self.value_in_mbps = kwargs.get('value_in_mbps', None)


class FlowLogInformation(Model):
    """Information on the configuration of flow log.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the resource to configure
     for flow logging.
    :type target_resource_id: str
    :param storage_id: Required. ID of the storage account which is used to
     store the flow log.
    :type storage_id: str
    :param enabled: Required. Flag to enable/disable flow logging.
    :type enabled: bool
    :param retention_policy:
    :type retention_policy:
     ~azure.mgmt.network.v2017_06_01.models.RetentionPolicyParameters
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicyParameters'},
    }

    def __init__(self, **kwargs):
        super(FlowLogInformation, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.storage_id = kwargs.get('storage_id', None)
        self.enabled = kwargs.get('enabled', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class FlowLogStatusParameters(Model):
    """Parameters that define a resource to query flow log status.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource where getting the
     flow logging status.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FlowLogStatusParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar inbound_nat_rules: Read only. Inbound rules URIs that use this
     frontend IP.
    :vartype inbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar inbound_nat_pools: Read only. Inbound pools URIs that use this
     frontend IP.
    :vartype inbound_nat_pools:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar outbound_nat_rules: Read only. Outbound rules URIs that use this
     frontend IP.
    :vartype outbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar load_balancing_rules: Gets load balancing rules URIs that use this
     frontend IP.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method.
     Possible values are: 'Static' and 'Dynamic'. Possible values include:
     'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :param public_ip_address: The reference of the Public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param zones: A list of availability zones denoting the IP allocated for
     the resource needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'inbound_nat_rules': {'readonly': True},
        'inbound_nat_pools': {'readonly': True},
        'outbound_nat_rules': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(FrontendIPConfiguration, self).__init__(**kwargs)
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_nat_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.zones = kwargs.get('zones', None)


class GatewayRoute(Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar local_address: The gateway's local address
    :vartype local_address: str
    :ivar network: The route's network prefix
    :vartype network: str
    :ivar next_hop: The route's next hop
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from
    :vartype source_peer: str
    :ivar origin: The source this route was learned from
    :vartype origin: str
    :ivar as_path: The route's AS path sequence
    :vartype as_path: str
    :ivar weight: The route's weight
    :vartype weight: int
    """

    _validation = {
        'local_address': {'readonly': True},
        'network': {'readonly': True},
        'next_hop': {'readonly': True},
        'source_peer': {'readonly': True},
        'origin': {'readonly': True},
        'as_path': {'readonly': True},
        'weight': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'source_peer': {'key': 'sourcePeer', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(GatewayRoute, self).__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(Model):
    """List of virtual network gateway routes.

    :param value: List of gateway routes
    :type value: list[~azure.mgmt.network.v2017_06_01.models.GatewayRoute]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayRoute]'},
    }

    def __init__(self, **kwargs):
        super(GatewayRouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param protocol: Required. The transport protocol for the endpoint.
     Possible values are: 'Udp' or 'Tcp'. Possible values include: 'Udp', 'Tcp'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :param frontend_port_range_start: Required. The first port number in the
     range of external ports that will be used to provide Inbound Nat to NICs
     associated with a load balancer. Acceptable values range between 1 and
     65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: Required. The last port number in the
     range of external ports that will be used to provide Inbound Nat to NICs
     associated with a load balancer. Acceptable values range between 1 and
     65535.
    :type frontend_port_range_end: int
    :param backend_port: Required. The port used for internal connections on
     the endpoint. Acceptable values are between 1 and 65535.
    :type backend_port: int
    :param provisioning_state: Gets the provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'protocol': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
        'backend_port': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InboundNatPool, self).__init__(**kwargs)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port_range_start = kwargs.get('frontend_port_range_start', None)
        self.frontend_port_range_end = kwargs.get('frontend_port_range_end', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address
     defined on a network interface of a VM. Traffic sent to the frontend port
     of each of the frontend IP configurations is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration
    :param protocol: The transport protocol for the endpoint. Possible values
     are: 'Udp' or 'Tcp'. Possible values include: 'Udp', 'Tcp'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for
     each rule must be unique within the Load Balancer. Acceptable values range
     from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable
     values range from 1 to 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
     The value can be set between 4 and 30 minutes. The default value is 4
     minutes. This element is only used when the protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the
     floating IP capability required to configure a SQL AlwaysOn Availability
     Group. This setting is required when using the SQL AlwaysOn Availability
     Groups in SQL server. This setting can't be changed after you create the
     endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'backend_ip_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InboundNatRule, self).__init__(**kwargs)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_ip_configuration = None
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class IPAddressAvailabilityResult(Model):
    """Response for CheckIPAddressAvailability API service call.

    :param available: Private IP address availability.
    :type available: bool
    :param available_ip_addresses: Contains other available private IP
     addresses if the asked for address is taken.
    :type available_ip_addresses: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
        'available_ip_addresses': {'key': 'availableIPAddresses', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(IPAddressAvailabilityResult, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)
        self.available_ip_addresses = kwargs.get('available_ip_addresses', None)


class IPConfiguration(SubResource):
    """IP configuration.

    :param id: Resource ID.
    :type id: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method.
     Possible values are 'Static' and 'Dynamic'. Possible values include:
     'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IPConfiguration, self).__init__(**kwargs)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class IpsecPolicy(Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to
     site VPN tunnel.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) payload size in KB for a site to
     site VPN tunnel.
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE
     phase 1). Possible values include: 'None', 'DES', 'DES3', 'AES128',
     'AES192', 'AES256', 'GCMAES128', 'GCMAES192', 'GCMAES256'
    :type ipsec_encryption: str or
     ~azure.mgmt.network.v2017_06_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase
     1). Possible values include: 'MD5', 'SHA1', 'SHA256', 'GCMAES128',
     'GCMAES192', 'GCMAES256'
    :type ipsec_integrity: str or
     ~azure.mgmt.network.v2017_06_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase
     2). Possible values include: 'DES', 'DES3', 'AES128', 'AES192', 'AES256'
    :type ike_encryption: str or
     ~azure.mgmt.network.v2017_06_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2).
     Possible values include: 'MD5', 'SHA1', 'SHA256', 'SHA384'
    :type ike_integrity: str or
     ~azure.mgmt.network.v2017_06_01.models.IkeIntegrity
    :param dh_group: Required. The DH Groups used in IKE Phase 1 for initial
     SA. Possible values include: 'None', 'DHGroup1', 'DHGroup2', 'DHGroup14',
     'DHGroup2048', 'ECP256', 'ECP384', 'DHGroup24'
    :type dh_group: str or ~azure.mgmt.network.v2017_06_01.models.DhGroup
    :param pfs_group: Required. The DH Groups used in IKE Phase 2 for new
     child SA. Possible values include: 'None', 'PFS1', 'PFS2', 'PFS2048',
     'ECP256', 'ECP384', 'PFS24'
    :type pfs_group: str or ~azure.mgmt.network.v2017_06_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpsecPolicy, self).__init__(**kwargs)
        self.sa_life_time_seconds = kwargs.get('sa_life_time_seconds', None)
        self.sa_data_size_kilobytes = kwargs.get('sa_data_size_kilobytes', None)
        self.ipsec_encryption = kwargs.get('ipsec_encryption', None)
        self.ipsec_integrity = kwargs.get('ipsec_integrity', None)
        self.ike_encryption = kwargs.get('ike_encryption', None)
        self.ike_integrity = kwargs.get('ike_integrity', None)
        self.dh_group = kwargs.get('dh_group', None)
        self.pfs_group = kwargs.get('pfs_group', None)


class Ipv6ExpressRouteCircuitPeeringConfig(Model):
    """Contains IPv6 peering config.

    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
    :param state: The state of peering. Possible values are: 'Disabled' and
     'Enabled'. Possible values include: 'Disabled', 'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        'primary_peer_address_prefix': {'key': 'primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'secondaryPeerAddressPrefix', 'type': 'str'},
        'microsoft_peering_config': {'key': 'microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'route_filter': {'key': 'routeFilter', 'type': 'RouteFilter'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Ipv6ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.route_filter = kwargs.get('route_filter', None)
        self.state = kwargs.get('state', None)


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param frontend_ip_configurations: Object representing the frontend IPs to
     be used for the load balancer
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by
     a load balancer
    :type backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load
     balancing rules Gets the provisioning
    :type load_balancing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer
    :type probes: list[~azure.mgmt.network.v2017_06_01.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load
     balancer. Defining inbound NAT rules on your load balancer is mutually
     exclusive with defining an inbound NAT pool. Inbound NAT pools are
     referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an Inbound NAT pool. They
     have to reference individual inbound NAT rules.
    :type inbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT
     to a single backend port on NICs associated with a load balancer. Inbound
     NAT rules are created automatically for each NIC associated with the Load
     Balancer using an external port from this range. Defining an Inbound NAT
     pool on your Load Balancer is mutually exclusive with defining inbound Nat
     rules. Inbound NAT pools are referenced from virtual machine scale sets.
     NICs that are associated with individual virtual machines cannot reference
     an inbound NAT pool. They have to reference individual inbound NAT rules.
    :type inbound_nat_pools:
     list[~azure.mgmt.network.v2017_06_01.models.InboundNatPool]
    :param outbound_nat_rules: The outbound NAT rules.
    :type outbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.OutboundNatRule]
    :param resource_guid: The resource GUID property of the load balancer
     resource.
    :type resource_guid: str
    :param provisioning_state: Gets the provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LoadBalancer, self).__init__(**kwargs)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.load_balancing_rules = kwargs.get('load_balancing_rules', None)
        self.probes = kwargs.get('probes', None)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)
        self.outbound_nat_rules = kwargs.get('outbound_nat_rules', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound
     traffic is randomly load balanced across IPs in the backend IPs.
    :type backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param probe: The reference of the load balancer probe used by the load
     balancing rule.
    :type probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param protocol: Required. The transport protocol for the external
     endpoint. Possible values are 'Udp' or 'Tcp'. Possible values include:
     'Udp', 'Tcp'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule.
     Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
     Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
    :type load_distribution: str or
     ~azure.mgmt.network.v2017_06_01.models.LoadDistribution
    :param frontend_port: Required. The port for the external endpoint. Port
     numbers for each rule must be unique within the Load Balancer. Acceptable
     values are between 1 and 65534.
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the
     endpoint. Acceptable values are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
     The value can be set between 4 and 30 minutes. The default value is 4
     minutes. This element is only used when the protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the
     floating IP capability required to configure a SQL AlwaysOn Availability
     Group. This setting is required when using the SQL AlwaysOn Availability
     Groups in SQL server. This setting can't be changed after you create the
     endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'protocol': {'required': True},
        'frontend_port': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LoadBalancingRule, self).__init__(**kwargs)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.probe = kwargs.get('probe', None)
        self.protocol = kwargs.get('protocol', None)
        self.load_distribution = kwargs.get('load_distribution', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space:
     ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
    :param resource_guid: The resource GUID property of the
     LocalNetworkGateway resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the
     LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting',
     and 'Failed'.
    :vartype provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocalNetworkGateway, self).__init__(**kwargs)
        self.local_network_address_space = kwargs.get('local_network_address_space', None)
        self.gateway_ip_address = kwargs.get('gateway_ip_address', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = None
        self.etag = kwargs.get('etag', None)


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_machine: The reference of a virtual machine.
    :type virtual_machine: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param network_security_group: The reference of the NetworkSecurityGroup
     resource.
    :type network_security_group:
     ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
    :param ip_configurations: A list of IPConfigurations of the network
     interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceDnsSettings
    :param mac_address: The MAC address of the network interface.
    :type mac_address: str
    :param primary: Gets whether this is a primary network interface on a
     virtual machine.
    :type primary: bool
    :param enable_accelerated_networking: If the network interface is
     accelerated networking enabled.
    :type enable_accelerated_networking: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on
     this network interface.
    :type enable_ip_forwarding: bool
    :param resource_guid: The resource GUID property of the network interface
     resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterface, self).__init__(**kwargs)
        self.virtual_machine = kwargs.get('virtual_machine', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.mac_address = kwargs.get('mac_address', None)
        self.primary = kwargs.get('primary', None)
        self.enable_accelerated_networking = kwargs.get('enable_accelerated_networking', None)
        self.enable_ip_forwarding = kwargs.get('enable_ip_forwarding', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class NetworkInterfaceAssociation(Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfaceAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = kwargs.get('security_rules', None)


class NetworkInterfaceDnsSettings(Model):
    """DNS settings of a network interface.

    :param dns_servers: List of DNS servers IP addresses. Use
     'AzureProvidedDNS' to switch to azure provided DNS resolution.
     'AzureProvidedDNS' value cannot be combined with other IPs, it must be the
     only value in dnsServers collection.
    :type dns_servers: list[str]
    :param applied_dns_servers: If the VM that uses this NIC is part of an
     Availability Set, then this list will have the union of all DNS servers
     from all NICs that are part of the Availability Set. This property is what
     is configured on each of those VMs.
    :type applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for
     internal communications between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :param internal_fqdn: Fully qualified DNS name supporting internal
     communications between VMs in the same virtual network.
    :type internal_fqdn: str
    :param internal_domain_name_suffix: Even if internalDnsNameLabel is not
     specified, a DNS entry is created for the primary NIC of the VM. This DNS
     name can be constructed by concatenating the VM name with the value of
     internalDomainNameSuffix.
    :type internal_domain_name_suffix: str
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
        'internal_domain_name_suffix': {'key': 'internalDomainNameSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)
        self.applied_dns_servers = kwargs.get('applied_dns_servers', None)
        self.internal_dns_name_label = kwargs.get('internal_dns_name_label', None)
        self.internal_fqdn = kwargs.get('internal_fqdn', None)
        self.internal_domain_name_suffix = kwargs.get('internal_domain_name_suffix', None)


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    :param id: Resource ID.
    :type id: str
    :param application_gateway_backend_address_pools: The reference of
     ApplicationGatewayBackendAddressPool resource.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
    :param load_balancer_backend_address_pools: The reference of
     LoadBalancerBackendAddressPool resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of
     LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
    :param private_ip_address: Private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: Defines how a private IP address is
     assigned. Possible values are: 'Static' and 'Dynamic'. Possible values
     include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param private_ip_address_version: Available from Api-Version 2016-03-30
     onwards, it represents whether the specific ipconfiguration is IPv4 or
     IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     Possible values include: 'IPv4', 'IPv6'
    :type private_ip_address_version: str or
     ~azure.mgmt.network.v2017_06_01.models.IPVersion
    :param subnet: Subnet bound to the IP configuration.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :param primary: Gets whether this is a primary customer address on the
     network interface.
    :type primary: bool
    :param public_ip_address: Public IP address bound to the IP configuration.
    :type public_ip_address:
     ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :param provisioning_state: The provisioning state of the network interface
     IP configuration. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfaceIPConfiguration, self).__init__(**kwargs)
        self.application_gateway_backend_address_pools = kwargs.get('application_gateway_backend_address_pools', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_rules = kwargs.get('load_balancer_inbound_nat_rules', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param security_rules: A collection of security rules of the network
     security group.
    :type security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :param default_security_rules: The default security rules of network
     security group.
    :type default_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network
     interfaces.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :param resource_guid: The resource GUID property of the network security
     group resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'subnets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkSecurityGroup, self).__init__(**kwargs)
        self.security_rules = kwargs.get('security_rules', None)
        self.default_security_rules = kwargs.get('default_security_rules', None)
        self.network_interfaces = None
        self.subnets = None
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkWatcher, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.provisioning_state = None


class NextHopParameters(Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The resource identifier of the target
     resource against which the action is to be performed.
    :type target_resource_id: str
    :param source_ip_address: Required. The source IP address.
    :type source_ip_address: str
    :param destination_ip_address: Required. The destination IP address.
    :type destination_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP
     forwarding is enabled on any of the nics, then this parameter must be
     specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'source_ip_address': {'required': True},
        'destination_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'destination_ip_address': {'key': 'destinationIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NextHopParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.source_ip_address = kwargs.get('source_ip_address', None)
        self.destination_ip_address = kwargs.get('destination_ip_address', None)
        self.target_nic_resource_id = kwargs.get('target_nic_resource_id', None)


class NextHopResult(Model):
    """The information about next hop from the specified VM.

    :param next_hop_type: Next hop type. Possible values include: 'Internet',
     'VirtualAppliance', 'VirtualNetworkGateway', 'VnetLocal',
     'HyperNetGateway', 'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2017_06_01.models.NextHopType
    :param next_hop_ip_address: Next hop IP Address
    :type next_hop_ip_address: str
    :param route_table_id: The resource identifier for the route table
     associated with the route being returned. If the route being returned does
     not correspond to any user created routes then this field will be the
     string 'System Route'.
    :type route_table_id: str
    """

    _attribute_map = {
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
        'route_table_id': {'key': 'routeTableId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NextHopResult, self).__init__(**kwargs)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.route_table_id = kwargs.get('route_table_id', None)


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param allocated_outbound_ports: The number of outbound ports to be used
     for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: The Frontend IP addresses of the load
     balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param backend_address_pool: Required. A reference to a pool of DIPs.
     Outbound traffic is randomly load balanced across IPs in the backend IPs.
    :type backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param provisioning_state: Gets the provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'backend_address_pool': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OutboundNatRule, self).__init__(**kwargs)
        self.allocated_outbound_ports = kwargs.get('allocated_outbound_ports', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class PacketCapture(Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required.
    :type storage_location:
     ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters:
     list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(self, **kwargs):
        super(PacketCapture, self).__init__(**kwargs)
        self.target = kwargs.get('target', None)
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs.get('storage_location', None)
        self.filters = kwargs.get('filters', None)


class PacketCaptureFilter(Model):
    """Filter that is applied to packet capture request. Multiple filters can be
    applied.

    :param protocol: Protocol to be filtered on. Possible values include:
     'TCP', 'UDP', 'Any'. Default value: "Any" .
    :type protocol: str or ~azure.mgmt.network.v2017_06_01.models.PcProtocol
    :param local_ip_address: Local IP Address to be filtered on. Notation:
     "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
     "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently
     supported. Mixing ranges with multiple entries not currently supported.
     Default = null.
    :type local_ip_address: str
    :param remote_ip_address: Local IP Address to be filtered on. Notation:
     "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
     "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently
     supported. Mixing ranges with multiple entries not currently supported.
     Default = null.
    :type remote_ip_address: str
    :param local_port: Local port to be filtered on. Notation: "80" for single
     port entry."80-85" for range. "80;443;" for multiple entries. Multiple
     ranges not currently supported. Mixing ranges with multiple entries not
     currently supported. Default = null.
    :type local_port: str
    :param remote_port: Remote port to be filtered on. Notation: "80" for
     single port entry."80-85" for range. "80;443;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple
     entries not currently supported. Default = null.
    :type remote_port: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PacketCaptureFilter, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', "Any")
        self.local_ip_address = kwargs.get('local_ip_address', None)
        self.remote_ip_address = kwargs.get('remote_ip_address', None)
        self.local_port = kwargs.get('local_port', None)
        self.remote_port = kwargs.get('remote_port', None)


class PacketCaptureParameters(Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required.
    :type storage_location:
     ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters:
     list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(self, **kwargs):
        super(PacketCaptureParameters, self).__init__(**kwargs)
        self.target = kwargs.get('target', None)
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs.get('storage_location', None)
        self.filters = kwargs.get('filters', None)


class PacketCaptureQueryStatusResult(Model):
    """Status of packet capture session.

    :param name: The name of the packet capture resource.
    :type name: str
    :param id: The ID of the packet capture resource.
    :type id: str
    :param capture_start_time: The start time of the packet capture session.
    :type capture_start_time: datetime
    :param packet_capture_status: The status of the packet capture session.
     Possible values include: 'NotStarted', 'Running', 'Stopped', 'Error',
     'Unknown'
    :type packet_capture_status: str or
     ~azure.mgmt.network.v2017_06_01.models.PcStatus
    :param stop_reason: The reason the current packet capture session was
     stopped.
    :type stop_reason: str
    :param packet_capture_error: List of errors of packet capture session.
    :type packet_capture_error: list[str or
     ~azure.mgmt.network.v2017_06_01.models.PcError]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'capture_start_time': {'key': 'captureStartTime', 'type': 'iso-8601'},
        'packet_capture_status': {'key': 'packetCaptureStatus', 'type': 'str'},
        'stop_reason': {'key': 'stopReason', 'type': 'str'},
        'packet_capture_error': {'key': 'packetCaptureError', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PacketCaptureQueryStatusResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.capture_start_time = kwargs.get('capture_start_time', None)
        self.packet_capture_status = kwargs.get('packet_capture_status', None)
        self.stop_reason = kwargs.get('stop_reason', None)
        self.packet_capture_error = kwargs.get('packet_capture_error', None)


class PacketCaptureResult(Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :param etag:  Default value: "A unique read-only string that changes
     whenever the resource is updated." .
    :type etag: str
    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required.
    :type storage_location:
     ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :param filters:
    :type filters:
     list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    :param provisioning_state: The provisioning state of the packet capture
     session. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PacketCaptureResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = kwargs.get('etag', "A unique read-only string that changes whenever the resource is updated.")
        self.target = kwargs.get('target', None)
        self.bytes_to_capture_per_packet = kwargs.get('bytes_to_capture_per_packet', 0)
        self.total_bytes_per_session = kwargs.get('total_bytes_per_session', 1073741824)
        self.time_limit_in_seconds = kwargs.get('time_limit_in_seconds', 18000)
        self.storage_location = kwargs.get('storage_location', None)
        self.filters = kwargs.get('filters', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PacketCaptureStorageLocation(Model):
    """Describes the storage location for a packet capture session.

    :param storage_id: The ID of the storage account to save the packet
     capture session. Required if no local file path is provided.
    :type storage_id: str
    :param storage_path: The URI of the storage path to save the packet
     capture. Must be a well-formed URI describing the location to save the
     packet capture.
    :type storage_path: str
    :param file_path: A valid local path on the targeting VM. Must include the
     name of the capture file (*.cap). For linux virtual machine it must start
     with /var/captures. Required if no storage ID is provided, otherwise
     optional.
    :type file_path: str
    """

    _attribute_map = {
        'storage_id': {'key': 'storageId', 'type': 'str'},
        'storage_path': {'key': 'storagePath', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PacketCaptureStorageLocation, self).__init__(**kwargs)
        self.storage_id = kwargs.get('storage_id', None)
        self.storage_path = kwargs.get('storage_path', None)
        self.file_path = kwargs.get('file_path', None)


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param rules: Collection of RouteFilterRules contained within a route
     filter.
    :type rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
    :param peerings: A collection of references to express route circuit
     peerings.
    :type peerings:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(PatchRouteFilter, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)
        self.peerings = kwargs.get('peerings', None)
        self.provisioning_state = None
        self.name = None
        self.etag = None
        self.type = None
        self.tags = kwargs.get('tags', None)


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param access: Required. The access type of the rule. Valid values are:
     'Allow', 'Deny'. Possible values include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :ivar route_filter_rule_type: Required. The rule type of the rule. Valid
     value is: 'Community'. Default value: "Community" .
    :vartype route_filter_rule_type: str
    :param communities: Required. The collection for bgp community values to
     filter on. e.g. ['12076:5010','12076:5020']
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'access': {'required': True},
        'route_filter_rule_type': {'required': True, 'constant': True},
        'communities': {'required': True},
        'provisioning_state': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    route_filter_rule_type = "Community"

    def __init__(self, **kwargs):
        super(PatchRouteFilterRule, self).__init__(**kwargs)
        self.access = kwargs.get('access', None)
        self.communities = kwargs.get('communities', None)
        self.provisioning_state = None
        self.name = None
        self.etag = None
        self.tags = kwargs.get('tags', None)


class Probe(SubResource):
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :param protocol: Required. The protocol of the end point. Possible values
     are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required
     for the probe to be successful. If 'Http' is specified, a 200 OK response
     from the specifies URI is required for the probe to be successful.
     Possible values include: 'Http', 'Tcp'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.ProbeProtocol
    :param port: Required. The port for communicating the probe. Possible
     values range from 1 to 65535, inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently
     to probe the endpoint for health status. Typically, the interval is
     slightly less than half the allocated timeout period (in seconds) which
     allows two full probes before taking the instance out of rotation. The
     default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will
     result in stopping further traffic from being delivered to the endpoint.
     This values allows endpoints to be taken out of rotation faster or slower
     than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the
     VM. Path is required if a protocol is set to http. Otherwise, it is not
     allowed. There is no default value.
    :type request_path: str
    :param provisioning_state: Gets the provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'load_balancing_rules': {'readonly': True},
        'protocol': {'required': True},
        'port': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Probe, self).__init__(**kwargs)
        self.load_balancing_rules = None
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.number_of_probes = kwargs.get('number_of_probes', None)
        self.request_path = kwargs.get('request_path', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param public_ip_allocation_method: The public IP allocation method.
     Possible values are: 'Static' and 'Dynamic'. Possible values include:
     'Static', 'Dynamic'
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param public_ip_address_version: The public IP address version. Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: 'IPv4', 'IPv6'
    :type public_ip_address_version: str or
     ~azure.mgmt.network.v2017_06_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP
     address.
    :vartype ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public
     IP address.
    :type dns_settings:
     ~azure.mgmt.network.v2017_06_01.models.PublicIPAddressDnsSettings
    :param ip_address: The IP address associated with the public IP address
     resource.
    :type ip_address: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param resource_guid: The resource GUID property of the public IP
     resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param zones: A list of availability zones denoting the IP allocated for
     the resource needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'ip_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PublicIPAddress, self).__init__(**kwargs)
        self.public_ip_allocation_method = kwargs.get('public_ip_allocation_method', None)
        self.public_ip_address_version = kwargs.get('public_ip_address_version', None)
        self.ip_configuration = None
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)
        self.zones = kwargs.get('zones', None)


class PublicIPAddressDnsSettings(Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: Gets or sets the Domain name label.The
     concatenation of the domain name label and the regionalized DNS zone make
     up the fully qualified domain name associated with the public IP address.
     If a domain name label is specified, an A DNS record is created for the
     public IP in the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: Gets the FQDN, Fully qualified domain name of the A DNS
     record associated with the public IP. This is the concatenation of the
     domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully
     qualified domain name that resolves to this public IP address. If the
     reverseFqdn is specified, then a PTR DNS record is created pointing from
     the IP address in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = kwargs.get('domain_name_label', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.reverse_fqdn = kwargs.get('reverse_fqdn', None)


class QueryTroubleshootingParameters(Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource ID to query the
     troubleshooting result.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QueryTroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource
    :type link: str
    :ivar provisioning_state: Provisioning state of the ResourceNavigationLink
     resource.
    :vartype provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceNavigationLink, self).__init__(**kwargs)
        self.linked_resource_type = kwargs.get('linked_resource_type', None)
        self.link = kwargs.get('link', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.etag = None


class RetentionPolicyParameters(Model):
    """Parameters that define the retention policy for flow log.

    :param days: Number of days to retain flow log records. Default value: 0 .
    :type days: int
    :param enabled: Flag to enable/disable retention. Default value: False .
    :type enabled: bool
    """

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RetentionPolicyParameters, self).__init__(**kwargs)
        self.days = kwargs.get('days', 0)
        self.enabled = kwargs.get('enabled', False)


class Route(SubResource):
    """Route resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: Required. The type of Azure hop the packet should be
     sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal',
     'Internet', 'VirtualAppliance', and 'None'. Possible values include:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance',
     'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to.
     Next hop values are only allowed in routes where the next hop type is
     VirtualAppliance.
    :type next_hop_ip_address: str
    :param provisioning_state: The provisioning state of the resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'next_hop_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Route, self).__init__(**kwargs)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param rules: Collection of RouteFilterRules contained within a route
     filter.
    :type rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
    :param peerings: A collection of references to express route circuit
     peerings.
    :type peerings:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    :ivar etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RouteFilter, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)
        self.peerings = kwargs.get('peerings', None)
        self.provisioning_state = None
        self.etag = None


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param access: Required. The access type of the rule. Valid values are:
     'Allow', 'Deny'. Possible values include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :ivar route_filter_rule_type: Required. The rule type of the rule. Valid
     value is: 'Community'. Default value: "Community" .
    :vartype route_filter_rule_type: str
    :param communities: Required. The collection for bgp community values to
     filter on. e.g. ['12076:5010','12076:5020']
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param location: Resource location.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'access': {'required': True},
        'route_filter_rule_type': {'required': True, 'constant': True},
        'communities': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    route_filter_rule_type = "Community"

    def __init__(self, **kwargs):
        super(RouteFilterRule, self).__init__(**kwargs)
        self.access = kwargs.get('access', None)
        self.communities = kwargs.get('communities', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.etag = None
        self.tags = kwargs.get('tags', None)


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2017_06_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :param provisioning_state: The provisioning state of the resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RouteTable, self).__init__(**kwargs)
        self.routes = kwargs.get('routes', None)
        self.subnets = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class SecurityGroupNetworkInterface(Model):
    """Network interface and all its associated security rules.

    :param id: ID of the network interface.
    :type id: str
    :param security_rule_associations:
    :type security_rule_associations:
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rule_associations': {'key': 'securityRuleAssociations', 'type': 'SecurityRuleAssociations'},
    }

    def __init__(self, **kwargs):
        super(SecurityGroupNetworkInterface, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.security_rule_associations = kwargs.get('security_rule_associations', None)


class SecurityGroupViewParameters(Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ID of the target VM.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityGroupViewParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class SecurityGroupViewResult(Model):
    """The information about security rules applied to the specified VM.

    :param network_interfaces: List of network interfaces on the specified VM.
    :type network_interfaces:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[SecurityGroupNetworkInterface]'},
    }

    def __init__(self, **kwargs):
        super(SecurityGroupViewResult, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class SecurityRule(SubResource):
    """Network security rule.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Required. Network protocol this rule applies to. Possible
     values are 'Tcp', 'Udp', and '*'. Possible values include: 'Tcp', 'Udp',
     '*'
    :type protocol: str or
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range
     between 0 and 65535. Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or
     range between 0 and 65535. Asterisk '*' can also be used to match all
     ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*'
     can also be used to match all source IPs. Default tags such as
     'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If
     this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param source_address_prefixes: The CIDR or source IP ranges.
    :type source_address_prefixes: list[str]
    :param destination_address_prefix: The destination address prefix. CIDR or
     destination IP range. Asterisk '*' can also be used to match all source
     IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and
     'Internet' can also be used.
    :type destination_address_prefix: str
    :param destination_address_prefixes: The destination address prefixes.
     CIDR or destination IP ranges.
    :type destination_address_prefixes: list[str]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Required. The network traffic is allowed or denied.
     Possible values are: 'Allow' and 'Deny'. Possible values include: 'Allow',
     'Deny'
    :type access: str or
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100
     and 4096. The priority number must be unique for each rule in the
     collection. The lower the priority number, the higher the priority of the
     rule.
    :type priority: int
    :param direction: Required. The direction of the rule. The direction
     specifies if rule will be evaluated on incoming or outgoing traffic.
     Possible values are: 'Inbound' and 'Outbound'. Possible values include:
     'Inbound', 'Outbound'
    :type direction: str or
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
    :param provisioning_state: The provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'protocol': {'required': True},
        'access': {'required': True},
        'direction': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'properties.sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'destination_address_prefixes': {'key': 'properties.destinationAddressPrefixes', 'type': '[str]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityRule, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.protocol = kwargs.get('protocol', None)
        self.source_port_range = kwargs.get('source_port_range', None)
        self.destination_port_range = kwargs.get('destination_port_range', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.source_address_prefixes = kwargs.get('source_address_prefixes', None)
        self.destination_address_prefix = kwargs.get('destination_address_prefix', None)
        self.destination_address_prefixes = kwargs.get('destination_address_prefixes', None)
        self.source_port_ranges = kwargs.get('source_port_ranges', None)
        self.destination_port_ranges = kwargs.get('destination_port_ranges', None)
        self.access = kwargs.get('access', None)
        self.priority = kwargs.get('priority', None)
        self.direction = kwargs.get('direction', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class SecurityRuleAssociations(Model):
    """All security rules associated with the network interface.

    :param network_interface_association:
    :type network_interface_association:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceAssociation
    :param subnet_association:
    :type subnet_association:
     ~azure.mgmt.network.v2017_06_01.models.SubnetAssociation
    :param default_security_rules: Collection of default security rules of the
     network security group.
    :type default_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :param effective_security_rules: Collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        'network_interface_association': {'key': 'networkInterfaceAssociation', 'type': 'NetworkInterfaceAssociation'},
        'subnet_association': {'key': 'subnetAssociation', 'type': 'SubnetAssociation'},
        'default_security_rules': {'key': 'defaultSecurityRules', 'type': '[SecurityRule]'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
    }

    def __init__(self, **kwargs):
        super(SecurityRuleAssociations, self).__init__(**kwargs)
        self.network_interface_association = kwargs.get('network_interface_association', None)
        self.subnet_association = kwargs.get('subnet_association', None)
        self.default_security_rules = kwargs.get('default_security_rules', None)
        self.effective_security_rules = kwargs.get('effective_security_rules', None)


class ServiceEndpointPropertiesFormat(Model):
    """The service endpoint properties.

    :param service: The type of the endpoint service.
    :type service: str
    :param locations: A list of locations.
    :type locations: list[str]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceEndpointPropertiesFormat, self).__init__(**kwargs)
        self.service = kwargs.get('service', None)
        self.locations = kwargs.get('locations', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param network_security_group: The reference of the NetworkSecurityGroup
     resource.
    :type network_security_group:
     ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
    :param route_table: The reference of the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2017_06_01.models.RouteTable
    :param service_endpoints: An array of service endpoints.
    :type service_endpoints:
     list[~azure.mgmt.network.v2017_06_01.models.ServiceEndpointPropertiesFormat]
    :ivar ip_configurations: Gets an array of references to the network
     interface IP configurations using subnet.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.IPConfiguration]
    :param resource_navigation_links: Gets an array of references to the
     external resources using subnet.
    :type resource_navigation_links:
     list[~azure.mgmt.network.v2017_06_01.models.ResourceNavigationLink]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'ip_configurations': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'service_endpoints': {'key': 'properties.serviceEndpoints', 'type': '[ServiceEndpointPropertiesFormat]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'resource_navigation_links': {'key': 'properties.resourceNavigationLinks', 'type': '[ResourceNavigationLink]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Subnet, self).__init__(**kwargs)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.route_table = kwargs.get('route_table', None)
        self.service_endpoints = kwargs.get('service_endpoints', None)
        self.ip_configurations = None
        self.resource_navigation_links = kwargs.get('resource_navigation_links', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class SubnetAssociation(Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(self, **kwargs):
        super(SubnetAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = kwargs.get('security_rules', None)


class Topology(Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially
     created for the resource group.
    :vartype created_date_time: datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: datetime
    :param resources:
    :type resources:
     list[~azure.mgmt.network.v2017_06_01.models.TopologyResource]
    """

    _validation = {
        'id': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'resources': {'key': 'resources', 'type': '[TopologyResource]'},
    }

    def __init__(self, **kwargs):
        super(Topology, self).__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = kwargs.get('resources', None)


class TopologyAssociation(Model):
    """Resources that have an association with the parent resource.

    :param name: The name of the resource that is associated with the parent
     resource.
    :type name: str
    :param resource_id: The ID of the resource that is associated with the
     parent resource.
    :type resource_id: str
    :param association_type: The association type of the child resource to the
     parent resource. Possible values include: 'Associated', 'Contains'
    :type association_type: str or
     ~azure.mgmt.network.v2017_06_01.models.AssociationType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'association_type': {'key': 'associationType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopologyAssociation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.association_type = kwargs.get('association_type', None)


class TopologyParameters(Model):
    """Parameters that define the representation of topology.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group_name: Required. The name of the target
     resource group to perform topology on.
    :type target_resource_group_name: str
    """

    _validation = {
        'target_resource_group_name': {'required': True},
    }

    _attribute_map = {
        'target_resource_group_name': {'key': 'targetResourceGroupName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopologyParameters, self).__init__(**kwargs)
        self.target_resource_group_name = kwargs.get('target_resource_group_name', None)


class TopologyResource(Model):
    """The network resource topology information for the given resource group.

    :param name: Name of the resource.
    :type name: str
    :param id: ID of the resource.
    :type id: str
    :param location: Resource location.
    :type location: str
    :param associations: Holds the associations the resource has with other
     resources in the resource group.
    :type associations:
     list[~azure.mgmt.network.v2017_06_01.models.TopologyAssociation]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'associations': {'key': 'associations', 'type': '[TopologyAssociation]'},
    }

    def __init__(self, **kwargs):
        super(TopologyResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.location = kwargs.get('location', None)
        self.associations = kwargs.get('associations', None)


class TroubleshootingDetails(Model):
    """Information gained from troubleshooting of specified resource.

    :param id: The id of the get troubleshoot operation.
    :type id: str
    :param reason_type: Reason type of failure.
    :type reason_type: str
    :param summary: A summary of troubleshooting.
    :type summary: str
    :param detail: Details on troubleshooting results.
    :type detail: str
    :param recommended_actions: List of recommended actions.
    :type recommended_actions:
     list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'str'},
        'recommended_actions': {'key': 'recommendedActions', 'type': '[TroubleshootingRecommendedActions]'},
    }

    def __init__(self, **kwargs):
        super(TroubleshootingDetails, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.reason_type = kwargs.get('reason_type', None)
        self.summary = kwargs.get('summary', None)
        self.detail = kwargs.get('detail', None)
        self.recommended_actions = kwargs.get('recommended_actions', None)


class TroubleshootingParameters(Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource to troubleshoot.
    :type target_resource_id: str
    :param storage_id: Required. The ID for the storage account to save the
     troubleshoot result.
    :type storage_id: str
    :param storage_path: Required. The path to the blob to save the
     troubleshoot result in.
    :type storage_path: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'storage_path': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'storage_path': {'key': 'properties.storagePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.storage_id = kwargs.get('storage_id', None)
        self.storage_path = kwargs.get('storage_path', None)


class TroubleshootingRecommendedActions(Model):
    """Recommended actions based on discovered issues.

    :param action_id: ID of the recommended action.
    :type action_id: str
    :param action_text: Description of recommended actions.
    :type action_text: str
    :param action_uri: The uri linking to a documentation for the recommended
     troubleshooting actions.
    :type action_uri: str
    :param action_uri_text: The information from the URI for the recommended
     troubleshooting actions.
    :type action_uri_text: str
    """

    _attribute_map = {
        'action_id': {'key': 'actionId', 'type': 'str'},
        'action_text': {'key': 'actionText', 'type': 'str'},
        'action_uri': {'key': 'actionUri', 'type': 'str'},
        'action_uri_text': {'key': 'actionUriText', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TroubleshootingRecommendedActions, self).__init__(**kwargs)
        self.action_id = kwargs.get('action_id', None)
        self.action_text = kwargs.get('action_text', None)
        self.action_uri = kwargs.get('action_uri', None)
        self.action_uri_text = kwargs.get('action_uri_text', None)


class TroubleshootingResult(Model):
    """Troubleshooting information gained from specified resource.

    :param start_time: The start time of the troubleshooting.
    :type start_time: datetime
    :param end_time: The end time of the troubleshooting.
    :type end_time: datetime
    :param code: The result code of the troubleshooting.
    :type code: str
    :param results: Information from troubleshooting.
    :type results:
     list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'results': {'key': 'results', 'type': '[TroubleshootingDetails]'},
    }

    def __init__(self, **kwargs):
        super(TroubleshootingResult, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.code = kwargs.get('code', None)
        self.results = kwargs.get('results', None)


class TunnelConnectionHealth(Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual network Gateway connection status.
     Possible values include: 'Unknown', 'Connecting', 'Connected',
     'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this
     connection
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this
     connection
    :vartype egress_bytes_transferred: long
    :ivar last_connection_established_utc_time: The time at which connection
     was established in Utc format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        'tunnel': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'last_connection_established_utc_time': {'readonly': True},
    }

    _attribute_map = {
        'tunnel': {'key': 'tunnel', 'type': 'str'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'last_connection_established_utc_time': {'key': 'lastConnectionEstablishedUtcTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TunnelConnectionHealth, self).__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class Usage(Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of measurement. Default
     value: "Count" .
    :vartype unit: str
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2017_06_01.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class UsageName(Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class VerificationIPFlowParameters(Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to
     perform next-hop on.
    :type target_resource_id: str
    :param direction: Required. The direction of the packet represented as a
     5-tuple. Possible values include: 'Inbound', 'Outbound'
    :type direction: str or ~azure.mgmt.network.v2017_06_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Possible values
     include: 'TCP', 'UDP'
    :type protocol: str or ~azure.mgmt.network.v2017_06_01.models.Protocol
    :param local_port: Required. The local port. Acceptable values are a
     single integer in the range (0-65535). Support for * for the source port,
     which depends on the direction.
    :type local_port: str
    :param remote_port: Required. The remote port. Acceptable values are a
     single integer in the range (0-65535). Support for * for the source port,
     which depends on the direction.
    :type remote_port: str
    :param local_ip_address: Required. The local IP address. Acceptable values
     are valid IPv4 addresses.
    :type local_ip_address: str
    :param remote_ip_address: Required. The remote IP address. Acceptable
     values are valid IPv4 addresses.
    :type remote_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP
     forwarding is enabled on any of them, then this parameter must be
     specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'direction': {'required': True},
        'protocol': {'required': True},
        'local_port': {'required': True},
        'remote_port': {'required': True},
        'local_ip_address': {'required': True},
        'remote_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerificationIPFlowParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.direction = kwargs.get('direction', None)
        self.protocol = kwargs.get('protocol', None)
        self.local_port = kwargs.get('local_port', None)
        self.remote_port = kwargs.get('remote_port', None)
        self.local_ip_address = kwargs.get('local_ip_address', None)
        self.remote_ip_address = kwargs.get('remote_ip_address', None)
        self.target_nic_resource_id = kwargs.get('target_nic_resource_id', None)


class VerificationIPFlowResult(Model):
    """Results of IP flow verification on the target resource.

    :param access: Indicates whether the traffic is allowed or denied.
     Possible values include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :param rule_name: Name of the rule. If input is not matched against any
     security rule, it is not displayed.
    :type rule_name: str
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerificationIPFlowResult, self).__init__(**kwargs)
        self.access = kwargs.get('access', None)
        self.rule_name = kwargs.get('rule_name', None)


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param address_space: The AddressSpace that contains an array of IP
     address ranges that can be used by subnets.
    :type address_space: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers
     available to VMs deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2017_06_01.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :param virtual_network_peerings: A list of peerings in a Virtual Network.
    :type virtual_network_peerings:
     list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeering]
    :param resource_guid: The resourceGuid property of the Virtual Network
     resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'virtual_network_peerings': {'key': 'properties.virtualNetworkPeerings', 'type': '[VirtualNetworkPeering]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetwork, self).__init__(**kwargs)
        self.address_space = kwargs.get('address_space', None)
        self.dhcp_options = kwargs.get('dhcp_options', None)
        self.subnets = kwargs.get('subnets', None)
        self.virtual_network_peerings = kwargs.get('virtual_network_peerings', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)


class VirtualNetworkConnectionGatewayReference(Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of VirtualNetworkGateway or
     LocalNetworkGateway resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkConnectionGatewayReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible
     values are: 'Vpn' and 'ExpressRoute'. Possible values include: 'Vpn',
     'ExpressRoute'
    :type gateway_type: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values
     are: 'PolicyBased' and 'RouteBased'. Possible values include:
     'PolicyBased', 'RouteBased'
    :type vpn_type: str or ~azure.mgmt.network.v2017_06_01.models.VpnType
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway
     or not.
    :type enable_bgp: bool
    :param active_active: ActiveActive flag
    :type active_active: bool
    :param gateway_default_site: The reference of the LocalNetworkGateway
     resource which represents local network site having default routes. Assign
     Null value in case of removing existing default site setting.
    :type gateway_default_site:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param sku: The reference of the VirtualNetworkGatewaySku resource which
     represents the SKU selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference of the
     VpnClientConfiguration resource which represents the P2S VpnClient
     configurations.
    :type vpn_client_configuration:
     ~azure.mgmt.network.v2017_06_01.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
    :param resource_guid: The resource GUID property of the
     VirtualNetworkGateway resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the
     VirtualNetworkGateway resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'active_active': {'key': 'properties.activeActive', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGateway, self).__init__(**kwargs)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.gateway_type = kwargs.get('gateway_type', None)
        self.vpn_type = kwargs.get('vpn_type', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.active_active = kwargs.get('active_active', None)
        self.gateway_default_site = kwargs.get('gateway_default_site', None)
        self.sku = kwargs.get('sku', None)
        self.vpn_client_configuration = kwargs.get('vpn_client_configuration', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = None
        self.etag = kwargs.get('etag', None)


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual
     network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
    :param virtual_network_gateway2: The reference to virtual network gateway
     resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
    :param local_network_gateway2: The reference to local network gateway
     resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.LocalNetworkGateway
    :param connection_type: Required. Gateway connection type. Possible values
     are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values
     include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :type connection_type: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual network Gateway connection status.
     Possible values are 'Unknown', 'Connecting', 'Connected' and
     'NotConnected'. Possible values include: 'Unknown', 'Connecting',
     'Connected', 'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection
     health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2017_06_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this
     connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this
     connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param enable_bgp: EnableBgp flag
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
    :param resource_guid: The resource GUID property of the
     VirtualNetworkGatewayConnection resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the
     VirtualNetworkGatewayConnection resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnection, self).__init__(**kwargs)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs.get('virtual_network_gateway1', None)
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs.get('connection_type', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = None
        self.etag = kwargs.get('etag', None)


class VirtualNetworkGatewayConnectionListEntity(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual
     network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :param virtual_network_gateway2: The reference to virtual network gateway
     resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :param local_network_gateway2: The reference to local network gateway
     resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :param connection_type: Required. Gateway connection type. Possible values
     are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values
     include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :type connection_type: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual network Gateway connection status.
     Possible values are 'Unknown', 'Connecting', 'Connected' and
     'NotConnected'. Possible values include: 'Unknown', 'Connecting',
     'Connected', 'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection
     health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2017_06_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this
     connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this
     connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param enable_bgp: EnableBgp flag
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
    :param resource_guid: The resource GUID property of the
     VirtualNetworkGatewayConnection resource.
    :type resource_guid: str
    :ivar provisioning_state: The provisioning state of the
     VirtualNetworkGatewayConnection resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnectionListEntity, self).__init__(**kwargs)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs.get('virtual_network_gateway1', None)
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs.get('connection_type', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.use_policy_based_traffic_selectors = kwargs.get('use_policy_based_traffic_selectors', None)
        self.ipsec_policies = kwargs.get('ipsec_policies', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = None
        self.etag = kwargs.get('etag', None)


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param private_ip_allocation_method: The private IP allocation method.
     Possible values are: 'Static' and 'Dynamic'. Possible values include:
     'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the public IP
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(**kwargs)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class VirtualNetworkGatewaySku(Model):
    """VirtualNetworkGatewaySku details.

    :param name: Gateway SKU name. Possible values include: 'Basic',
     'HighPerformance', 'Standard', 'UltraPerformance', 'VpnGw1', 'VpnGw2',
     'VpnGw3'
    :type name: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway SKU tier. Possible values include: 'Basic',
     'HighPerformance', 'Standard', 'UltraPerformance', 'VpnGw1', 'VpnGw2',
     'VpnGw3'
    :type tier: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuTier
    :param capacity: The capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class VirtualNetworkPeering(SubResource):
    """Peerings in a virtual network resource.

    :param id: Resource ID.
    :type id: str
    :param allow_virtual_network_access: Whether the VMs in the linked virtual
     network space would be able to access all the VMs in local Virtual network
     space.
    :type allow_virtual_network_access: bool
    :param allow_forwarded_traffic: Whether the forwarded traffic from the VMs
     in the remote virtual network will be allowed/disallowed.
    :type allow_forwarded_traffic: bool
    :param allow_gateway_transit: If gateway links can be used in remote
     virtual networking to link to this virtual network.
    :type allow_gateway_transit: bool
    :param use_remote_gateways: If remote gateways can be used on this virtual
     network. If the flag is set to true, and allowGatewayTransit on remote
     peering is also true, virtual network will use gateways of remote virtual
     network for transit. Only one peering can have this flag set to true. This
     flag cannot be set if virtual network already has a gateway.
    :type use_remote_gateways: bool
    :param remote_virtual_network: The reference of the remote virtual
     network.
    :type remote_virtual_network:
     ~azure.mgmt.network.v2017_06_01.models.SubResource
    :param peering_state: The status of the virtual network peering. Possible
     values are 'Initiated', 'Connected', and 'Disconnected'. Possible values
     include: 'Initiated', 'Connected', 'Disconnected'
    :type peering_state: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeeringState
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'allow_virtual_network_access': {'key': 'properties.allowVirtualNetworkAccess', 'type': 'bool'},
        'allow_forwarded_traffic': {'key': 'properties.allowForwardedTraffic', 'type': 'bool'},
        'allow_gateway_transit': {'key': 'properties.allowGatewayTransit', 'type': 'bool'},
        'use_remote_gateways': {'key': 'properties.useRemoteGateways', 'type': 'bool'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'peering_state': {'key': 'properties.peeringState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkPeering, self).__init__(**kwargs)
        self.allow_virtual_network_access = kwargs.get('allow_virtual_network_access', None)
        self.allow_forwarded_traffic = kwargs.get('allow_forwarded_traffic', None)
        self.allow_gateway_transit = kwargs.get('allow_gateway_transit', None)
        self.use_remote_gateways = kwargs.get('use_remote_gateways', None)
        self.remote_virtual_network = kwargs.get('remote_virtual_network', None)
        self.peering_state = kwargs.get('peering_state', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class VirtualNetworkUsage(Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'
    :vartype unit: str
    """

    _validation = {
        'current_value': {'readonly': True},
        'id': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'id': {'key': 'id', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'float'},
        'name': {'key': 'name', 'type': 'VirtualNetworkUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkUsage, self).__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkUsageName, self).__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VpnClientConfiguration(Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: The reference of the address space
     resource which represents Address space for P2S VpnClient.
    :type vpn_client_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for virtual
     network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for
     Virtual network gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.VpnClientRevokedCertificate]
    :param vpn_client_protocols: VpnClientProtocols for Virtual network
     gateway.
    :type vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.VpnClientProtocol]
    :param radius_server_address: The radius server address property of the
     VirtualNetworkGateway resource for vpn client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the
     VirtualNetworkGateway resource for vpn client connection.
    :type radius_server_secret: str
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
        'vpn_client_protocols': {'key': 'vpnClientProtocols', 'type': '[str]'},
        'radius_server_address': {'key': 'radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'radiusServerSecret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = kwargs.get('vpn_client_address_pool', None)
        self.vpn_client_root_certificates = kwargs.get('vpn_client_root_certificates', None)
        self.vpn_client_revoked_certificates = kwargs.get('vpn_client_revoked_certificates', None)
        self.vpn_client_protocols = kwargs.get('vpn_client_protocols', None)
        self.radius_server_address = kwargs.get('radius_server_address', None)
        self.radius_server_secret = kwargs.get('radius_server_secret', None)


class VpnClientParameters(Model):
    """Vpn Client Parameters for package generation.

    :param processor_architecture: VPN client Processor Architecture. Possible
     values are: 'AMD64' and 'X86'. Possible values include: 'Amd64', 'X86'
    :type processor_architecture: str or
     ~azure.mgmt.network.v2017_06_01.models.ProcessorArchitecture
    :param authentication_method: VPN client Authentication Method. Possible
     values are: 'EAPTLS' and 'EAPMSCHAPv2'. Possible values include: 'EAPTLS',
     'EAPMSCHAPv2'
    :type authentication_method: str or
     ~azure.mgmt.network.v2017_06_01.models.AuthenticationMethod
    :param radius_server_auth_certificate: The public certificate data for the
     radius server authentication certificate as a Base-64 encoded string.
     Required only if external radius authentication has been configured with
     EAPTLS authentication.
    :type radius_server_auth_certificate: str
    :param client_root_certificates: A list of client root certificates public
     certificate data encoded as Base-64 strings. Optional parameter for
     external radius based authentication with EAPTLS.
    :type client_root_certificates: list[str]
    """

    _attribute_map = {
        'processor_architecture': {'key': 'processorArchitecture', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
        'radius_server_auth_certificate': {'key': 'radiusServerAuthCertificate', 'type': 'str'},
        'client_root_certificates': {'key': 'clientRootCertificates', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = kwargs.get('processor_architecture', None)
        self.authentication_method = kwargs.get('authentication_method', None)
        self.radius_server_auth_certificate = kwargs.get('radius_server_auth_certificate', None)
        self.client_root_certificates = kwargs.get('client_root_certificates', None)


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked
     certificate resource. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :vartype provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VpnClientRevokedCertificate, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param public_cert_data: Required. The certificate public data.
    :type public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root
     certificate resource. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :vartype provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _validation = {
        'public_cert_data': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VpnClientRootCertificate, self).__init__(**kwargs)
        self.public_cert_data = kwargs.get('public_cert_data', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
