# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.provider_operations import ProviderOperations
from .operations.global_users_operations import GlobalUsersOperations
from .operations.lab_accounts_operations import LabAccountsOperations
from .operations.operations import Operations
from .operations.gallery_images_operations import GalleryImagesOperations
from .operations.labs_operations import LabsOperations
from .operations.environment_settings_operations import EnvironmentSettingsOperations
from .operations.environments_operations import EnvironmentsOperations
from .operations.users_operations import UsersOperations
from . import models


class ManagedLabsClientConfiguration(AzureConfiguration):
    """Configuration for ManagedLabsClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(ManagedLabsClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-labservices/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class ManagedLabsClient(SDKClient):
    """The Managed Labs Client.

    :ivar config: Configuration for client.
    :vartype config: ManagedLabsClientConfiguration

    :ivar provider_operations: ProviderOperations operations
    :vartype provider_operations: azure.mgmt.labservices.operations.ProviderOperations
    :ivar global_users: GlobalUsers operations
    :vartype global_users: azure.mgmt.labservices.operations.GlobalUsersOperations
    :ivar lab_accounts: LabAccounts operations
    :vartype lab_accounts: azure.mgmt.labservices.operations.LabAccountsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.labservices.operations.Operations
    :ivar gallery_images: GalleryImages operations
    :vartype gallery_images: azure.mgmt.labservices.operations.GalleryImagesOperations
    :ivar labs: Labs operations
    :vartype labs: azure.mgmt.labservices.operations.LabsOperations
    :ivar environment_settings: EnvironmentSettings operations
    :vartype environment_settings: azure.mgmt.labservices.operations.EnvironmentSettingsOperations
    :ivar environments: Environments operations
    :vartype environments: azure.mgmt.labservices.operations.EnvironmentsOperations
    :ivar users: Users operations
    :vartype users: azure.mgmt.labservices.operations.UsersOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ManagedLabsClientConfiguration(credentials, subscription_id, base_url)
        super(ManagedLabsClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-10-15'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.provider_operations = ProviderOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.global_users = GlobalUsersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.lab_accounts = LabAccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.gallery_images = GalleryImagesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.labs = LabsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.environment_settings = EnvironmentSettingsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.environments = EnvironmentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.users = UsersOperations(
            self._client, self.config, self._serialize, self._deserialize)
