# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse

from .. import models


class JobScheduleOperations(object):
    """JobScheduleOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: Client API Version. Constant value: "2019-08-01.10.0".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2019-08-01.10.0"

        self.config = config

    def exists(
            self, job_schedule_id, job_schedule_exists_options=None, custom_headers=None, raw=False, **operation_config):
        """Checks the specified Job Schedule exists.

        :param job_schedule_id: The ID of the Job Schedule which you want to
         check.
        :type job_schedule_id: str
        :param job_schedule_exists_options: Additional parameters for the
         operation
        :type job_schedule_exists_options:
         ~azure.batch.models.JobScheduleExistsOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: bool or ClientRawResponse if raw=true
        :rtype: bool or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_exists_options is not None:
            timeout = job_schedule_exists_options.timeout
        client_request_id = None
        if job_schedule_exists_options is not None:
            client_request_id = job_schedule_exists_options.client_request_id
        return_client_request_id = None
        if job_schedule_exists_options is not None:
            return_client_request_id = job_schedule_exists_options.return_client_request_id
        ocp_date = None
        if job_schedule_exists_options is not None:
            ocp_date = job_schedule_exists_options.ocp_date
        if_match = None
        if job_schedule_exists_options is not None:
            if_match = job_schedule_exists_options.if_match
        if_none_match = None
        if job_schedule_exists_options is not None:
            if_none_match = job_schedule_exists_options.if_none_match
        if_modified_since = None
        if job_schedule_exists_options is not None:
            if_modified_since = job_schedule_exists_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_exists_options is not None:
            if_unmodified_since = job_schedule_exists_options.if_unmodified_since

        # Construct URL
        url = self.exists.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = (response.status_code == 200)
        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                })
            return client_raw_response
        return deserialized
    exists.metadata = {'url': '/jobschedules/{jobScheduleId}'}

    def delete(
            self, job_schedule_id, job_schedule_delete_options=None, custom_headers=None, raw=False, **operation_config):
        """Deletes a Job Schedule from the specified Account.

        When you delete a Job Schedule, this also deletes all Jobs and Tasks
        under that schedule. When Tasks are deleted, all the files in their
        working directories on the Compute Nodes are also deleted (the
        retention period is ignored). The Job Schedule statistics are no longer
        accessible once the Job Schedule is deleted, though they are still
        counted towards Account lifetime statistics.

        :param job_schedule_id: The ID of the Job Schedule to delete.
        :type job_schedule_id: str
        :param job_schedule_delete_options: Additional parameters for the
         operation
        :type job_schedule_delete_options:
         ~azure.batch.models.JobScheduleDeleteOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_delete_options is not None:
            timeout = job_schedule_delete_options.timeout
        client_request_id = None
        if job_schedule_delete_options is not None:
            client_request_id = job_schedule_delete_options.client_request_id
        return_client_request_id = None
        if job_schedule_delete_options is not None:
            return_client_request_id = job_schedule_delete_options.return_client_request_id
        ocp_date = None
        if job_schedule_delete_options is not None:
            ocp_date = job_schedule_delete_options.ocp_date
        if_match = None
        if job_schedule_delete_options is not None:
            if_match = job_schedule_delete_options.if_match
        if_none_match = None
        if job_schedule_delete_options is not None:
            if_none_match = job_schedule_delete_options.if_none_match
        if_modified_since = None
        if job_schedule_delete_options is not None:
            if_modified_since = job_schedule_delete_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_delete_options is not None:
            if_unmodified_since = job_schedule_delete_options.if_unmodified_since

        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response
    delete.metadata = {'url': '/jobschedules/{jobScheduleId}'}

    def get(
            self, job_schedule_id, job_schedule_get_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets information about the specified Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to get.
        :type job_schedule_id: str
        :param job_schedule_get_options: Additional parameters for the
         operation
        :type job_schedule_get_options:
         ~azure.batch.models.JobScheduleGetOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CloudJobSchedule or ClientRawResponse if raw=true
        :rtype: ~azure.batch.models.CloudJobSchedule or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        select = None
        if job_schedule_get_options is not None:
            select = job_schedule_get_options.select
        expand = None
        if job_schedule_get_options is not None:
            expand = job_schedule_get_options.expand
        timeout = None
        if job_schedule_get_options is not None:
            timeout = job_schedule_get_options.timeout
        client_request_id = None
        if job_schedule_get_options is not None:
            client_request_id = job_schedule_get_options.client_request_id
        return_client_request_id = None
        if job_schedule_get_options is not None:
            return_client_request_id = job_schedule_get_options.return_client_request_id
        ocp_date = None
        if job_schedule_get_options is not None:
            ocp_date = job_schedule_get_options.ocp_date
        if_match = None
        if job_schedule_get_options is not None:
            if_match = job_schedule_get_options.if_match
        if_none_match = None
        if job_schedule_get_options is not None:
            if_none_match = job_schedule_get_options.if_none_match
        if_modified_since = None
        if job_schedule_get_options is not None:
            if_modified_since = job_schedule_get_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_get_options is not None:
            if_unmodified_since = job_schedule_get_options.if_unmodified_since

        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CloudJobSchedule', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/jobschedules/{jobScheduleId}'}

    def patch(
            self, job_schedule_id, job_schedule_patch_parameter, job_schedule_patch_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified Job Schedule.

        This replaces only the Job Schedule properties specified in the
        request. For example, if the schedule property is not specified with
        this request, then the Batch service will keep the existing schedule.
        Changes to a Job Schedule only impact Jobs created by the schedule
        after the update has taken place; currently running Jobs are
        unaffected.

        :param job_schedule_id: The ID of the Job Schedule to update.
        :type job_schedule_id: str
        :param job_schedule_patch_parameter: The parameters for the request.
        :type job_schedule_patch_parameter:
         ~azure.batch.models.JobSchedulePatchParameter
        :param job_schedule_patch_options: Additional parameters for the
         operation
        :type job_schedule_patch_options:
         ~azure.batch.models.JobSchedulePatchOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_patch_options is not None:
            timeout = job_schedule_patch_options.timeout
        client_request_id = None
        if job_schedule_patch_options is not None:
            client_request_id = job_schedule_patch_options.client_request_id
        return_client_request_id = None
        if job_schedule_patch_options is not None:
            return_client_request_id = job_schedule_patch_options.return_client_request_id
        ocp_date = None
        if job_schedule_patch_options is not None:
            ocp_date = job_schedule_patch_options.ocp_date
        if_match = None
        if job_schedule_patch_options is not None:
            if_match = job_schedule_patch_options.if_match
        if_none_match = None
        if job_schedule_patch_options is not None:
            if_none_match = job_schedule_patch_options.if_none_match
        if_modified_since = None
        if job_schedule_patch_options is not None:
            if_modified_since = job_schedule_patch_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_patch_options is not None:
            if_unmodified_since = job_schedule_patch_options.if_unmodified_since

        # Construct URL
        url = self.patch.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_schedule_patch_parameter, 'JobSchedulePatchParameter')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    patch.metadata = {'url': '/jobschedules/{jobScheduleId}'}

    def update(
            self, job_schedule_id, job_schedule_update_parameter, job_schedule_update_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified Job Schedule.

        This fully replaces all the updatable properties of the Job Schedule.
        For example, if the schedule property is not specified with this
        request, then the Batch service will remove the existing schedule.
        Changes to a Job Schedule only impact Jobs created by the schedule
        after the update has taken place; currently running Jobs are
        unaffected.

        :param job_schedule_id: The ID of the Job Schedule to update.
        :type job_schedule_id: str
        :param job_schedule_update_parameter: The parameters for the request.
        :type job_schedule_update_parameter:
         ~azure.batch.models.JobScheduleUpdateParameter
        :param job_schedule_update_options: Additional parameters for the
         operation
        :type job_schedule_update_options:
         ~azure.batch.models.JobScheduleUpdateOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_update_options is not None:
            timeout = job_schedule_update_options.timeout
        client_request_id = None
        if job_schedule_update_options is not None:
            client_request_id = job_schedule_update_options.client_request_id
        return_client_request_id = None
        if job_schedule_update_options is not None:
            return_client_request_id = job_schedule_update_options.return_client_request_id
        ocp_date = None
        if job_schedule_update_options is not None:
            ocp_date = job_schedule_update_options.ocp_date
        if_match = None
        if job_schedule_update_options is not None:
            if_match = job_schedule_update_options.if_match
        if_none_match = None
        if job_schedule_update_options is not None:
            if_none_match = job_schedule_update_options.if_none_match
        if_modified_since = None
        if job_schedule_update_options is not None:
            if_modified_since = job_schedule_update_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_update_options is not None:
            if_unmodified_since = job_schedule_update_options.if_unmodified_since

        # Construct URL
        url = self.update.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_schedule_update_parameter, 'JobScheduleUpdateParameter')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    update.metadata = {'url': '/jobschedules/{jobScheduleId}'}

    def disable(
            self, job_schedule_id, job_schedule_disable_options=None, custom_headers=None, raw=False, **operation_config):
        """Disables a Job Schedule.

        No new Jobs will be created until the Job Schedule is enabled again.

        :param job_schedule_id: The ID of the Job Schedule to disable.
        :type job_schedule_id: str
        :param job_schedule_disable_options: Additional parameters for the
         operation
        :type job_schedule_disable_options:
         ~azure.batch.models.JobScheduleDisableOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_disable_options is not None:
            timeout = job_schedule_disable_options.timeout
        client_request_id = None
        if job_schedule_disable_options is not None:
            client_request_id = job_schedule_disable_options.client_request_id
        return_client_request_id = None
        if job_schedule_disable_options is not None:
            return_client_request_id = job_schedule_disable_options.return_client_request_id
        ocp_date = None
        if job_schedule_disable_options is not None:
            ocp_date = job_schedule_disable_options.ocp_date
        if_match = None
        if job_schedule_disable_options is not None:
            if_match = job_schedule_disable_options.if_match
        if_none_match = None
        if job_schedule_disable_options is not None:
            if_none_match = job_schedule_disable_options.if_none_match
        if_modified_since = None
        if job_schedule_disable_options is not None:
            if_modified_since = job_schedule_disable_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_disable_options is not None:
            if_unmodified_since = job_schedule_disable_options.if_unmodified_since

        # Construct URL
        url = self.disable.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    disable.metadata = {'url': '/jobschedules/{jobScheduleId}/disable'}

    def enable(
            self, job_schedule_id, job_schedule_enable_options=None, custom_headers=None, raw=False, **operation_config):
        """Enables a Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to enable.
        :type job_schedule_id: str
        :param job_schedule_enable_options: Additional parameters for the
         operation
        :type job_schedule_enable_options:
         ~azure.batch.models.JobScheduleEnableOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_enable_options is not None:
            timeout = job_schedule_enable_options.timeout
        client_request_id = None
        if job_schedule_enable_options is not None:
            client_request_id = job_schedule_enable_options.client_request_id
        return_client_request_id = None
        if job_schedule_enable_options is not None:
            return_client_request_id = job_schedule_enable_options.return_client_request_id
        ocp_date = None
        if job_schedule_enable_options is not None:
            ocp_date = job_schedule_enable_options.ocp_date
        if_match = None
        if job_schedule_enable_options is not None:
            if_match = job_schedule_enable_options.if_match
        if_none_match = None
        if job_schedule_enable_options is not None:
            if_none_match = job_schedule_enable_options.if_none_match
        if_modified_since = None
        if job_schedule_enable_options is not None:
            if_modified_since = job_schedule_enable_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_enable_options is not None:
            if_unmodified_since = job_schedule_enable_options.if_unmodified_since

        # Construct URL
        url = self.enable.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    enable.metadata = {'url': '/jobschedules/{jobScheduleId}/enable'}

    def terminate(
            self, job_schedule_id, job_schedule_terminate_options=None, custom_headers=None, raw=False, **operation_config):
        """Terminates a Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to terminates.
        :type job_schedule_id: str
        :param job_schedule_terminate_options: Additional parameters for the
         operation
        :type job_schedule_terminate_options:
         ~azure.batch.models.JobScheduleTerminateOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_terminate_options is not None:
            timeout = job_schedule_terminate_options.timeout
        client_request_id = None
        if job_schedule_terminate_options is not None:
            client_request_id = job_schedule_terminate_options.client_request_id
        return_client_request_id = None
        if job_schedule_terminate_options is not None:
            return_client_request_id = job_schedule_terminate_options.return_client_request_id
        ocp_date = None
        if job_schedule_terminate_options is not None:
            ocp_date = job_schedule_terminate_options.ocp_date
        if_match = None
        if job_schedule_terminate_options is not None:
            if_match = job_schedule_terminate_options.if_match
        if_none_match = None
        if job_schedule_terminate_options is not None:
            if_none_match = job_schedule_terminate_options.if_none_match
        if_modified_since = None
        if job_schedule_terminate_options is not None:
            if_modified_since = job_schedule_terminate_options.if_modified_since
        if_unmodified_since = None
        if job_schedule_terminate_options is not None:
            if_unmodified_since = job_schedule_terminate_options.if_unmodified_since

        # Construct URL
        url = self.terminate.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    terminate.metadata = {'url': '/jobschedules/{jobScheduleId}/terminate'}

    def add(
            self, cloud_job_schedule, job_schedule_add_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a Job Schedule to the specified Account.

        :param cloud_job_schedule: The Job Schedule to be added.
        :type cloud_job_schedule: ~azure.batch.models.JobScheduleAddParameter
        :param job_schedule_add_options: Additional parameters for the
         operation
        :type job_schedule_add_options:
         ~azure.batch.models.JobScheduleAddOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_schedule_add_options is not None:
            timeout = job_schedule_add_options.timeout
        client_request_id = None
        if job_schedule_add_options is not None:
            client_request_id = job_schedule_add_options.client_request_id
        return_client_request_id = None
        if job_schedule_add_options is not None:
            return_client_request_id = job_schedule_add_options.return_client_request_id
        ocp_date = None
        if job_schedule_add_options is not None:
            ocp_date = job_schedule_add_options.ocp_date

        # Construct URL
        url = self.add.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(cloud_job_schedule, 'JobScheduleAddParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    add.metadata = {'url': '/jobschedules'}

    def list(
            self, job_schedule_list_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists all of the Job Schedules in the specified Account.

        :param job_schedule_list_options: Additional parameters for the
         operation
        :type job_schedule_list_options:
         ~azure.batch.models.JobScheduleListOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of CloudJobSchedule
        :rtype:
         ~azure.batch.models.CloudJobSchedulePaged[~azure.batch.models.CloudJobSchedule]
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_schedule_list_options is not None:
            filter = job_schedule_list_options.filter
        select = None
        if job_schedule_list_options is not None:
            select = job_schedule_list_options.select
        expand = None
        if job_schedule_list_options is not None:
            expand = job_schedule_list_options.expand
        max_results = None
        if job_schedule_list_options is not None:
            max_results = job_schedule_list_options.max_results
        timeout = None
        if job_schedule_list_options is not None:
            timeout = job_schedule_list_options.timeout
        client_request_id = None
        if job_schedule_list_options is not None:
            client_request_id = job_schedule_list_options.client_request_id
        return_client_request_id = None
        if job_schedule_list_options is not None:
            return_client_request_id = job_schedule_list_options.return_client_request_id
        ocp_date = None
        if job_schedule_list_options is not None:
            ocp_date = job_schedule_list_options.ocp_date

        def prepare_request(next_link=None):
            if not next_link:
                # Construct URL
                url = self.list.metadata['url']
                path_format_arguments = {
                    'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        def internal_paging(next_link=None):
            request = prepare_request(next_link)

            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        header_dict = None
        if raw:
            header_dict = {}
        deserialized = models.CloudJobSchedulePaged(internal_paging, self._deserialize.dependencies, header_dict)

        return deserialized
    list.metadata = {'url': '/jobschedules'}
