/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#include "clusterdialog.h"

#include <QGroupBox>
#include <QRadioButton>
#include <QVBoxLayout>

#include <KLocale>

ClusterDialog::ClusterDialog( QWidget *p_parent )
: KDialog( p_parent )
{
  QGroupBox *mainwidget = new QGroupBox( i18n("Select the cluster which you would like to see" ), this );
  setMainWidget( mainwidget );

  setButtons( KDialog::Ok | KDialog::Cancel );
  enableButtonOk( false );
  m_vbox = new QVBoxLayout( mainwidget );
}

ClusterDialog::~ClusterDialog()
{
}

void ClusterDialog::addCluster( const QStringList &p_cluster )
{
  QString label = p_cluster[ 0 ];
  for ( int i = 1; i < p_cluster.size(); ++i )
  {
    label += ',';
    if ( i % 8 == 0 )
    {
      label += '\n';
    }
    label += p_cluster[ i ];
  }

  QRadioButton *button = new QRadioButton( label, this );
  connect( button, SIGNAL( toggled( bool ) ), SLOT( clusterChosen() ) );
  m_vbox->addWidget( button );

  // create cluster-id
  QString cluster_id = p_cluster[ 0 ];
  for ( int i = 1; i < qMin( p_cluster.size(), 3 ); ++i )
  {
    cluster_id += '-';
    cluster_id += p_cluster[ i ];
  }
  m_buttons[ button ] = cluster_id;
}

void ClusterDialog::reset()
{
  QHash<QRadioButton*,QString>::const_iterator it = m_buttons.begin();
  for ( ; it != m_buttons.end(); ++it )
  {
    m_vbox->removeWidget( it.key() );
    delete it.key();
  }
  m_buttons.clear();
  enableButtonOk( false );
}

QString ClusterDialog::cluster() const
{
  QHash<QRadioButton*,QString>::const_iterator it = m_buttons.begin();
  for ( ; it != m_buttons.end(); ++it )
  {
    if ( it.key()->isChecked() )
    {
      return it.value();
    }
  }

  return QString();
}

void ClusterDialog::clusterChosen()
{
  enableButtonOk( true );
}
