--TEST--
Decimal128: Non-Canonical Parsing - nan
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('180000001364000000000000000000000000000000007C00');
$canonicalExtJson = '{"d" : {"$numberDecimal" : "NaN"}}';
$degenerateExtJson = '{"d" : {"$numberDecimal" : "nan"}}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

// Degenerate extJSON -> Canonical BSON
echo bin2hex(fromJSON($degenerateExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
180000001364000000000000000000000000000000007c00
{"d":{"$numberDecimal":"NaN"}}
180000001364000000000000000000000000000000007c00
180000001364000000000000000000000000000000007c00
===DONE===