/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.SQLServerXAResource;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class SQLServerXAConnection
extends SQLServerPooledConnection
implements XAConnection {
    private SQLServerXAResource XAResource;
    private Logger xaLogger = SQLServerXADataSource.xaLogger;

    SQLServerXAConnection(SQLServerDataSource sQLServerDataSource, String string, String string2) throws SQLException {
        super(sQLServerDataSource, string, string2);
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(sQLServerDataSource.toLogString() + " user:" + string);
        }
    }

    String toLogString() {
        String string = " XAConnectionID:" + this.getRawLoggingID();
        return string;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.XAResource == null) {
            this.XAResource = new SQLServerXAResource((SQLServerConnection)this.getPhysicalConnection());
        }
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toLogString() + this.XAResource.toLogString());
        }
        return this.XAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        SQLServerXAConnection sQLServerXAConnection = this;
        synchronized (sQLServerXAConnection) {
            if (this.XAResource != null) {
                this.XAResource.close();
                this.XAResource = null;
            }
        }
        super.close();
    }
}

