/*
 * @(#)ITFJUnitListenerJDK13UTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.autodoc.v1;

import net.sourceforge.groboutils.autodoc.v1.testserver.junit.*;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.autodoc.v1.junit.AutoDocJUnitListenerUTestI;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the ITFJUnitListener class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:04:45 $
 * @since     March 5, 2002
 */
public class ITFJUnitListenerJDK13UTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ITFJUnitListenerJDK13UTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ITFJUnitListenerJDK13UTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    private MockControl testControl;
    private Test mockTest;
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        this.testControl = EasyMock.controlFor( Test.class );
        this.mockTest = (Test)this.testControl.getMock();
    }


    //-------------------------------------------------------------------------
    // Tests
    

    public void testAddFailure1()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addFailure( (TestData)null, null );
    }
    

    public void testAddFailure1a()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addFailure( (Test)null, null );
    }
    
    
    public void testAddFailure2()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addFailure( (TestData)null,
            new AssertionFailedError( "ignore error") );
    }
    
    
    public void testAddFailure2a()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addFailure( (Test)null,
            new AssertionFailedError( "ignore error") );
    }
    
    
    public void testAddFailure3()
    {
        this.testControl.activate();
        
        createListener().addFailure( this.mockTest,
            new AssertionFailedError( "ignore error") );
        
        this.testControl.verify();
    }
    
    
    public void testAddError1()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addError( (TestData)null, null );
    }
    
    
    public void testAddError1a()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addError( (Test)null, null );
    }
    
    
    public void testAddError2()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addError( (TestData)null, new Throwable(
            "ignore error") );
    }
    
    
    public void testAddError2a()
    {
        DOC.getIT().testsIssue( 526454 );
        
        createListener().addError( (Test)null, new Throwable(
            "ignore error") );
    }
    
    
    public void testAddError3()
    {
        this.testControl.activate();
        
        createListener().addError( this.mockTest,
            new Throwable( "ignore error") );
        
        this.testControl.verify();
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    protected ITFJUnitListener createListener()
    {
        return new ITFJUnitListener();
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = JUnitTestListenerUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new ITFJUnitListener();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

