/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * This interface is used for calling methods on a Xml-Rpc server.
 *
 * @author Elias Ross
 * @version 1.0
 */
public interface XmlRpcClient 
	extends XmlRpcHandler
{

	/**
	 * Set the Xml-Rpc URL to connect to.  This server should support
	 * HTTP/1.1 to handle chunked output.  This must be called before a
	 * request is made, using <code>execute</code>.
	 */
	void setServerURL(java.net.URL url);

	/** 
	 * Generate an Xml-Rpc request and send it to the server. This
	 * method parses the results and return the corresponding Java object.
	 * If <code>setBasicAuthentication</code> was called, it sends this
	 * header.
	 * <p>
	 * Any sort of IO exception should be be wrapped in an
	 * XmlRpcException, but it may be useful to trap for just an IO
	 * failure conditions.  Use the <code>getCause</code> method for
	 * finding out the specific problem.
	 * </p>
	 * @param method This is the method to execute on the remote server.
	 * For Xml-Rpc, this should be in the form <code>handler.method</code>.
	 * @param params This will be closed by this method caller.  It
	 * will be closed, even on exceptions being thrown.
	 * @exception XmlRpcException If the call could not be made because of
	 * higher level problems, which may result from a ParamIterator
	 * failure.
	 * @return ParamIterator, which contains the return parameter list.
	 * This must be closed by the caller when done.
	 */
	ParamIterator execute(String method, ParamIterator params) 
		throws XmlRpcException;
}
