# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
#
#  FreeType high-level python API - Copyright 2011-2015 Nicolas P. Rougier
#  Distributed under the terms of the new BSD license.
#
# -----------------------------------------------------------------------------
"""
Possible values of the language identifier field in the name records of the
TTF 'name' table if the 'platform' identifier code is TT_PLATFORM_MICROSOFT.

TT_MS_LANGID_SANSKRIT_INDIA

TT_MS_LANGID_ENGLISH_UNITED_KINGDOM

TT_MS_LANGID_ENGLISH_BELIZE

TT_MS_LANGID_ARABIC_LEBANON

TT_MS_LANGID_MOLDAVIAN_MOLDAVIA

TT_MS_LANGID_TURKISH_TURKEY

TT_MS_LANGID_WELSH_WALES

TT_MS_LANGID_GERMAN_AUSTRIA

TT_MS_LANGID_DUTCH_BELGIUM

TT_MS_LANGID_YI_CHINA

TT_MS_LANGID_QUECHUA_ECUADOR

TT_MS_LANGID_SPANISH_EL_SALVADOR

TT_MS_LANGID_SWAHILI_KENYA

TT_MS_LANGID_QUECHUA_BOLIVIA

TT_MS_LANGID_SLOVENE_SLOVENIA

TT_MS_LANGID_ORIYA_INDIA

TT_MS_LANGID_FARSI_IRAN

TT_MS_LANGID_ENGLISH_CANADA

TT_MS_LANGID_NEPALI_NEPAL

TT_MS_LANGID_DHIVEHI_MALDIVES

TT_MS_LANGID_GERMAN_LIECHTENSTEI

TT_MS_LANGID_TAMIL_INDIA

TT_MS_LANGID_ARABIC_UAE

TT_MS_LANGID_JAPANESE_JAPAN

TT_MS_LANGID_TAMAZIGHT_MOROCCO

TT_MS_LANGID_FRENCH_FRANCE

TT_MS_LANGID_CHINESE_MACAU

TT_MS_LANGID_VIETNAMESE_VIET_NAM

TT_MS_LANGID_HEBREW_ISRAEL

TT_MS_LANGID_SAMI_NORTHERN_SWEDEN

TT_MS_LANGID_PUNJABI_ARABIC_PAKISTAN

TT_MS_LANGID_SWEDISH_SWEDEN

TT_MS_LANGID_FRENCH_REUNION

TT_MS_LANGID_ARABIC_BAHRAIN

TT_MS_LANGID_ENGLISH_INDIA

TT_MS_LANGID_NEPALI_INDIA

TT_MS_LANGID_THAI_THAILAND

TT_MS_LANGID_ENGLISH_GENERAL

TT_MS_LANGID_SAMI_LULE_NORWAY

TT_MS_LANGID_ARABIC_OMAN

TT_MS_LANGID_SPANISH_HONDURAS

TT_MS_LANGID_ENGLISH_JAMAICA

TT_MS_LANGID_ESTONIAN_ESTONIA

TT_MS_LANGID_FRISIAN_NETHERLANDS

TT_MS_LANGID_LATIN

TT_MS_LANGID_ENGLISH_INDONESIA

TT_MS_LANGID_ENGLISH_IRELAND

TT_MS_LANGID_TIBETAN_CHINA

TT_MS_LANGID_PUNJABI_INDIA

TT_MS_LANGID_FRENCH_MALI

TT_MS_LANGID_GERMAN_LUXEMBOURG

TT_MS_LANGID_SUTU_SOUTH_AFRICA

TT_MS_LANGID_FRENCH_CAMEROON

TT_MS_LANGID_FRENCH_CONGO

TT_MS_LANGID_CLASSIC_LITHUANIAN_LITHUANIA

TT_MS_LANGID_MALAYALAM_INDIA

TT_MS_LANGID_SAMI_SOUTHERN_SWEDEN

TT_MS_LANGID_CHEROKEE_UNITED_STATES

TT_MS_LANGID_SPANISH_GUATEMALA

TT_MS_LANGID_CZECH_CZECH_REPUBLIC

TT_MS_LANGID_MANIPURI_INDIA

TT_MS_LANGID_ENGLISH_AUSTRALIA

TT_MS_LANGID_SPANISH_DOMINICAN_REPUBLIC

TT_MS_LANGID_ARABIC_LIBYA

TT_MS_LANGID_FRENCH_WEST_INDIES

TT_MS_LANGID_ENGLISH_TRINIDAD

TT_MS_LANGID_ARABIC_QATAR

TT_MS_LANGID_SPANISH_COLOMBIA

TT_MS_LANGID_GUARANI_PARAGUAY

TT_MS_LANGID_EDO_NIGERIA

TT_MS_LANGID_SEPEDI_SOUTH_AFRICA

TT_MS_LANGID_ENGLISH_HONG_KONG

TT_MS_LANGID_KOREAN_EXTENDED_WANSUNG_KOREA

TT_MS_LANGID_TATAR_TATARSTAN

TT_MS_LANGID_PASHTO_AFGHANISTAN

TT_MS_LANGID_KASHMIRI_PAKISTAN

TT_MS_LANGID_GALICIAN_SPAIN

TT_MS_LANGID_TAJIK_TAJIKISTAN

TT_MS_LANGID_SAMI_INARI_FINLAND

TT_MS_LANGID_KASHMIRI_SASIA

TT_MS_LANGID_SPANISH_ARGENTINA

TT_MS_LANGID_SAMI_SOUTHERN_NORWAY

TT_MS_LANGID_CROATIAN_CROATIA

TT_MS_LANGID_GUJARATI_INDIA

TT_MS_LANGID_TIBETAN_BHUTAN

TT_MS_LANGID_TIGRIGNA_ETHIOPIA

TT_MS_LANGID_FINNISH_FINLAND

TT_MS_LANGID_ENGLISH_UNITED_STATES

TT_MS_LANGID_ITALIAN_SWITZERLAND

TT_MS_LANGID_ARABIC_EGYPT

TT_MS_LANGID_SPANISH_LATIN_AMERICA

TT_MS_LANGID_LITHUANIAN_LITHUANIA

TT_MS_LANGID_ARABIC_ALGERIA

TT_MS_LANGID_MALAY_MALAYSIA

TT_MS_LANGID_ARABIC_GENERAL

TT_MS_LANGID_CHINESE_PRC

TT_MS_LANGID_BENGALI_BANGLADESH

TT_MS_LANGID_SPANISH_PERU

TT_MS_LANGID_SPANISH_SPAIN_INTERNATIONAL_SORT

TT_MS_LANGID_DIVEHI_MALDIVES

TT_MS_LANGID_LATVIAN_LATVIA

TT_MS_LANGID_TURKMEN_TURKMENISTAN

TT_MS_LANGID_XHOSA_SOUTH_AFRICA

TT_MS_LANGID_KHMER_CAMBODIA

TT_MS_LANGID_NORWEGIAN_NORWAY_NYNORSK

TT_MS_LANGID_ARABIC_MOROCCO

TT_MS_LANGID_FRENCH_SENEGAL

TT_MS_LANGID_YORUBA_NIGERIA

TT_MS_LANGID_CATALAN_SPAIN

TT_MS_LANGID_AFRIKAANS_SOUTH_AFRICA

TT_MS_LANGID_ZULU_SOUTH_AFRICA

TT_MS_LANGID_SPANISH_URUGUAY

TT_MS_LANGID_SPANISH_ECUADOR

TT_MS_LANGID_BOSNIAN_BOSNIA_HERZEGOVINA

TT_MS_LANGID_CHINESE_GENERAL

TT_MS_LANGID_SPANISH_PARAGUAY

TT_MS_LANGID_HINDI_INDIA

TT_MS_LANGID_FRENCH_LUXEMBOURG

TT_MS_LANGID_TSWANA_SOUTH_AFRICA

TT_MS_LANGID_HUNGARIAN_HUNGARY

TT_MS_LANGID_CROATIAN_BOSNIA_HERZEGOVINA

TT_MS_LANGID_ENGLISH_SINGAPORE

TT_MS_LANGID_MALTESE_MALTA

TT_MS_LANGID_SAMI_NORTHERN_FINLAND

TT_MS_LANGID_FRENCH_CANADA

TT_MS_LANGID_SAMI_LULE_SWEDEN

TT_MS_LANGID_KANURI_NIGERIA

TT_MS_LANGID_IRISH_GAELIC_IRELAND

TT_MS_LANGID_ARABIC_SAUDI_ARABIA

TT_MS_LANGID_FRENCH_HAITI

TT_MS_LANGID_SPANISH_PUERTO_RICO

TT_MS_LANGID_BURMESE_MYANMAR

TT_MS_LANGID_POLISH_POLAND

TT_MS_LANGID_PORTUGUESE_PORTUGAL

TT_MS_LANGID_ENGLISH_CARIBBEAN

TT_MS_LANGID_KIRGHIZ_KIRGHIZ_REPUBLIC

TT_MS_LANGID_ICELANDIC_ICELAND

TT_MS_LANGID_BENGALI_INDIA

TT_MS_LANGID_HAUSA_NIGERIA

TT_MS_LANGID_BASQUE_SPAIN

TT_MS_LANGID_UIGHUR_CHINA

TT_MS_LANGID_ENGLISH_MALAYSIA

TT_MS_LANGID_FRENCH_MONACO

TT_MS_LANGID_SPANISH_BOLIVIA

TT_MS_LANGID_SORBIAN_GERMANY

TT_MS_LANGID_SINDHI_INDIA

TT_MS_LANGID_CHINESE_SINGAPORE

TT_MS_LANGID_FRENCH_COTE_D_IVOIRE

TT_MS_LANGID_SPANISH_SPAIN_TRADITIONAL_SORT

TT_MS_LANGID_SERBIAN_SERBIA_CYRILLIC

TT_MS_LANGID_SAMI_SKOLT_FINLAND

TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_CYRILLIC

TT_MS_LANGID_MALAY_BRUNEI_DARUSSALAM

TT_MS_LANGID_ARABIC_JORDAN

TT_MS_LANGID_MONGOLIAN_MONGOLIA_MONGOLIAN

TT_MS_LANGID_SERBIAN_SERBIA_LATIN

TT_MS_LANGID_RUSSIAN_RUSSIA

TT_MS_LANGID_ROMANIAN_ROMANIA

TT_MS_LANGID_FRENCH_NORTH_AFRICA

TT_MS_LANGID_MONGOLIAN_MONGOLIA

TT_MS_LANGID_TSONGA_SOUTH_AFRICA

TT_MS_LANGID_SOMALI_SOMALIA

TT_MS_LANGID_SAAMI_LAPONIA

TT_MS_LANGID_SPANISH_COSTA_RICA

TT_MS_LANGID_ARABIC_SYRIA

TT_MS_LANGID_SPANISH_PANAMA

TT_MS_LANGID_PAPIAMENTU_NETHERLANDS_ANTILLES

TT_MS_LANGID_ASSAMESE_INDIA

TT_MS_LANGID_SCOTTISH_GAELIC_UNITED_KINGDOM

TT_MS_LANGID_DUTCH_NETHERLANDS

TT_MS_LANGID_SINDHI_PAKISTAN

TT_MS_LANGID_MACEDONIAN_MACEDONIA

TT_MS_LANGID_KAZAK_KAZAKSTAN

TT_MS_LANGID_AZERI_AZERBAIJAN_LATIN

TT_MS_LANGID_BELARUSIAN_BELARUS

TT_MS_LANGID_FRENCH_MOROCCO

TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_LATIN

TT_MS_LANGID_ALBANIAN_ALBANIA

TT_MS_LANGID_SINHALESE_SRI_LANKA

TT_MS_LANGID_SPANISH_MEXICO

TT_MS_LANGID_ENGLISH_ZIMBABWE

TT_MS_LANGID_OROMO_ETHIOPIA

TT_MS_LANGID_INDONESIAN_INDONESIA

TT_MS_LANGID_SAMI_NORTHERN_NORWAY

TT_MS_LANGID_UZBEK_UZBEKISTAN_LATIN

TT_MS_LANGID_SLOVAK_SLOVAKIA

TT_MS_LANGID_KASHMIRI_INDIA

TT_MS_LANGID_GERMAN_SWITZERLAND

TT_MS_LANGID_URDU_INDIA

TT_MS_LANGID_FAEROESE_FAEROE_ISLANDS

TT_MS_LANGID_SYRIAC_SYRIA

TT_MS_LANGID_SPANISH_CHILE

TT_MS_LANGID_FILIPINO_PHILIPPINES

TT_MS_LANGID_ARABIC_YEMEN

TT_MS_LANGID_KONKANI_INDIA

TT_MS_LANGID_AMHARIC_ETHIOPIA

TT_MS_LANGID_ENGLISH_NEW_ZEALAND

TT_MS_LANGID_RHAETO_ROMANIC_SWITZERLAND

TT_MS_LANGID_ARABIC_TUNISIA

TT_MS_LANGID_SOTHO_SOUTHERN_SOUTH_AFRICA

TT_MS_LANGID_QUECHUA_PERU

TT_MS_LANGID_DANISH_DENMARK

TT_MS_LANGID_ENGLISH_PHILIPPINES

TT_MS_LANGID_SPANISH_NICARAGUA

TT_MS_LANGID_INUKTITUT_CANADA

TT_MS_LANGID_UKRAINIAN_UKRAINE

TT_MS_LANGID_NORWEGIAN_NORWAY_BOKMAL

TT_MS_LANGID_UZBEK_UZBEKISTAN_CYRILLIC

TT_MS_LANGID_FRENCH_BELGIUM

TT_MS_LANGID_ENGLISH_SOUTH_AFRICA

TT_MS_LANGID_HAWAIIAN_UNITED_STATES

TT_MS_LANGID_ARABIC_IRAQ

TT_MS_LANGID_KANNADA_INDIA

TT_MS_LANGID_DZONGHKA_BHUTAN

TT_MS_LANGID_CHINESE_TAIWAN

TT_MS_LANGID_SPANISH_UNITED_STATES

TT_MS_LANGID_ARMENIAN_ARMENIA

TT_MS_LANGID_LAO_LAOS

TT_MS_LANGID_TIGRIGNA_ERYTREA

TT_MS_LANGID_MARATHI_INDIA

TT_MS_LANGID_ARABIC_KUWAIT

TT_MS_LANGID_TAMAZIGHT_MOROCCO_LATIN

TT_MS_LANGID_PORTUGUESE_BRAZIL

TT_MS_LANGID_TIGRIGNA_ERYTHREA

TT_MS_LANGID_GREEK_GREECE

TT_MS_LANGID_URDU_PAKISTAN

TT_MS_LANGID_KIRGHIZ_KIRGHIZSTAN

TT_MS_LANGID_YIDDISH_GERMANY

TT_MS_LANGID_GERMAN_GERMANY

TT_MS_LANGID_TELUGU_INDIA

TT_MS_LANGID_AZERI_AZERBAIJAN_CYRILLIC

TT_MS_LANGID_KOREAN_JOHAB_KOREA

TT_MS_LANGID_ITALIAN_ITALY

TT_MS_LANGID_MAORI_NEW_ZEALAND

TT_MS_LANGID_SPANISH_VENEZUELA

TT_MS_LANGID_IGBO_NIGERIA

TT_MS_LANGID_IBIBIO_NIGERIA

TT_MS_LANGID_CHINESE_HONG_KONG

TT_MS_LANGID_FRENCH_SWITZERLAND

TT_MS_LANGID_BULGARIAN_BULGARIA

TT_MS_LANGID_FULFULDE_NIGERIA

TT_MS_LANGID_RUSSIAN_MOLDAVIA

TT_MS_LANGID_VENDA_SOUTH_AFRICA

TT_MS_LANGID_GEORGIAN_GEORGIA

TT_MS_LANGID_SWEDISH_FINLAND
"""

TT_MS_LANGIDS = {
    'TT_MS_LANGID_ARABIC_GENERAL'                    : 0x0001,
    'TT_MS_LANGID_ARABIC_SAUDI_ARABIA'               : 0x0401,
    'TT_MS_LANGID_ARABIC_IRAQ'                       : 0x0801,
    'TT_MS_LANGID_ARABIC_EGYPT'                      : 0x0c01,
    'TT_MS_LANGID_ARABIC_LIBYA'                      : 0x1001,
    'TT_MS_LANGID_ARABIC_ALGERIA'                    : 0x1401,
    'TT_MS_LANGID_ARABIC_MOROCCO'                    : 0x1801,
    'TT_MS_LANGID_ARABIC_TUNISIA'                    : 0x1c01,
    'TT_MS_LANGID_ARABIC_OMAN'                       : 0x2001,
    'TT_MS_LANGID_ARABIC_YEMEN'                      : 0x2401,
    'TT_MS_LANGID_ARABIC_SYRIA'                      : 0x2801,
    'TT_MS_LANGID_ARABIC_JORDAN'                     : 0x2c01,
    'TT_MS_LANGID_ARABIC_LEBANON'                    : 0x3001,
    'TT_MS_LANGID_ARABIC_KUWAIT'                     : 0x3401,
    'TT_MS_LANGID_ARABIC_UAE'                        : 0x3801,
    'TT_MS_LANGID_ARABIC_BAHRAIN'                    : 0x3c01,
    'TT_MS_LANGID_ARABIC_QATAR'                      : 0x4001,
    'TT_MS_LANGID_BULGARIAN_BULGARIA'                : 0x0402,
    'TT_MS_LANGID_CATALAN_SPAIN'                     : 0x0403,
    'TT_MS_LANGID_CHINESE_GENERAL'                   : 0x0004,
    'TT_MS_LANGID_CHINESE_TAIWAN'                    : 0x0404,
    'TT_MS_LANGID_CHINESE_PRC'                       : 0x0804,
    'TT_MS_LANGID_CHINESE_HONG_KONG'                 : 0x0c04,
    'TT_MS_LANGID_CHINESE_SINGAPORE'                 : 0x1004,
    'TT_MS_LANGID_CHINESE_MACAU'                     : 0x1404,
    'TT_MS_LANGID_CZECH_CZECH_REPUBLIC'              : 0x0405,
    'TT_MS_LANGID_DANISH_DENMARK'                    : 0x0406,
    'TT_MS_LANGID_GERMAN_GERMANY'                    : 0x0407,
    'TT_MS_LANGID_GERMAN_SWITZERLAND'                : 0x0807,
    'TT_MS_LANGID_GERMAN_AUSTRIA'                    : 0x0c07,
    'TT_MS_LANGID_GERMAN_LUXEMBOURG'                 : 0x1007,
    'TT_MS_LANGID_GERMAN_LIECHTENSTEI'               : 0x1407,
    'TT_MS_LANGID_GREEK_GREECE'                      : 0x0408,
    'TT_MS_LANGID_ENGLISH_GENERAL'                   : 0x0009,
    'TT_MS_LANGID_ENGLISH_UNITED_STATES'             : 0x0409,
    'TT_MS_LANGID_ENGLISH_UNITED_KINGDOM'            : 0x0809,
    'TT_MS_LANGID_ENGLISH_AUSTRALIA'                 : 0x0c09,
    'TT_MS_LANGID_ENGLISH_CANADA'                    : 0x1009,
    'TT_MS_LANGID_ENGLISH_NEW_ZEALAND'               : 0x1409,
    'TT_MS_LANGID_ENGLISH_IRELAND'                   : 0x1809,
    'TT_MS_LANGID_ENGLISH_SOUTH_AFRICA'              : 0x1c09,
    'TT_MS_LANGID_ENGLISH_JAMAICA'                   : 0x2009,
    'TT_MS_LANGID_ENGLISH_CARIBBEAN'                 : 0x2409,
    'TT_MS_LANGID_ENGLISH_BELIZE'                    : 0x2809,
    'TT_MS_LANGID_ENGLISH_TRINIDAD'                  : 0x2c09,
    'TT_MS_LANGID_ENGLISH_ZIMBABWE'                  : 0x3009,
    'TT_MS_LANGID_ENGLISH_PHILIPPINES'               : 0x3409,
    'TT_MS_LANGID_ENGLISH_INDONESIA'                 : 0x3809,
    'TT_MS_LANGID_ENGLISH_HONG_KONG'                 : 0x3c09,
    'TT_MS_LANGID_ENGLISH_INDIA'                     : 0x4009,
    'TT_MS_LANGID_ENGLISH_MALAYSIA'                  : 0x4409,
    'TT_MS_LANGID_ENGLISH_SINGAPORE'                 : 0x4809,
    'TT_MS_LANGID_SPANISH_SPAIN_TRADITIONAL_SORT'    : 0x040a,
    'TT_MS_LANGID_SPANISH_MEXICO'                    : 0x080a,
    'TT_MS_LANGID_SPANISH_SPAIN_INTERNATIONAL_SORT'  : 0x0c0a,
    'TT_MS_LANGID_SPANISH_GUATEMALA'                 : 0x100a,
    'TT_MS_LANGID_SPANISH_COSTA_RICA'                : 0x140a,
    'TT_MS_LANGID_SPANISH_PANAMA'                    : 0x180a,
    'TT_MS_LANGID_SPANISH_DOMINICAN_REPUBLIC'        : 0x1c0a,
    'TT_MS_LANGID_SPANISH_VENEZUELA'                 : 0x200a,
    'TT_MS_LANGID_SPANISH_COLOMBIA'                  : 0x240a,
    'TT_MS_LANGID_SPANISH_PERU'                      : 0x280a,
    'TT_MS_LANGID_SPANISH_ARGENTINA'                 : 0x2c0a,
    'TT_MS_LANGID_SPANISH_ECUADOR'                   : 0x300a,
    'TT_MS_LANGID_SPANISH_CHILE'                     : 0x340a,
    'TT_MS_LANGID_SPANISH_URUGUAY'                   : 0x380a,
    'TT_MS_LANGID_SPANISH_PARAGUAY'                  : 0x3c0a,
    'TT_MS_LANGID_SPANISH_BOLIVIA'                   : 0x400a,
    'TT_MS_LANGID_SPANISH_EL_SALVADOR'               : 0x440a,
    'TT_MS_LANGID_SPANISH_HONDURAS'                  : 0x480a,
    'TT_MS_LANGID_SPANISH_NICARAGUA'                 : 0x4c0a,
    'TT_MS_LANGID_SPANISH_PUERTO_RICO'               : 0x500a,
    'TT_MS_LANGID_SPANISH_UNITED_STATES'             : 0x540a,
    'TT_MS_LANGID_SPANISH_LATIN_AMERICA'             : 0xE40a,
    'TT_MS_LANGID_FINNISH_FINLAND'                   : 0x040b,
    'TT_MS_LANGID_FRENCH_FRANCE'                     : 0x040c,
    'TT_MS_LANGID_FRENCH_BELGIUM'                    : 0x080c,
    'TT_MS_LANGID_FRENCH_CANADA'                     : 0x0c0c,
    'TT_MS_LANGID_FRENCH_SWITZERLAND'                : 0x100c,
    'TT_MS_LANGID_FRENCH_LUXEMBOURG'                 : 0x140c,
    'TT_MS_LANGID_FRENCH_MONACO'                     : 0x180c,
    'TT_MS_LANGID_FRENCH_WEST_INDIES'                : 0x1c0c,
    'TT_MS_LANGID_FRENCH_REUNION'                    : 0x200c,
    'TT_MS_LANGID_FRENCH_CONGO'                      : 0x240c,
    'TT_MS_LANGID_FRENCH_SENEGAL'                    : 0x280c,
    'TT_MS_LANGID_FRENCH_CAMEROON'                   : 0x2c0c,
    'TT_MS_LANGID_FRENCH_COTE_D_IVOIRE'              : 0x300c,
    'TT_MS_LANGID_FRENCH_MALI'                       : 0x340c,
    'TT_MS_LANGID_FRENCH_MOROCCO'                    : 0x380c,
    'TT_MS_LANGID_FRENCH_HAITI'                      : 0x3c0c,
    'TT_MS_LANGID_FRENCH_NORTH_AFRICA'               : 0xE40c,
    'TT_MS_LANGID_HEBREW_ISRAEL'                     : 0x040d,
    'TT_MS_LANGID_HUNGARIAN_HUNGARY'                 : 0x040e,
    'TT_MS_LANGID_ICELANDIC_ICELAND'                 : 0x040f,
    'TT_MS_LANGID_ITALIAN_ITALY'                     : 0x0410,
    'TT_MS_LANGID_ITALIAN_SWITZERLAND'               : 0x0810,
    'TT_MS_LANGID_JAPANESE_JAPAN'                    : 0x0411,
    'TT_MS_LANGID_KOREAN_EXTENDED_WANSUNG_KOREA'     : 0x0412,
    'TT_MS_LANGID_KOREAN_JOHAB_KOREA'                : 0x0812,
    'TT_MS_LANGID_DUTCH_NETHERLANDS'                 : 0x0413,
    'TT_MS_LANGID_DUTCH_BELGIUM'                     : 0x0813,
    'TT_MS_LANGID_NORWEGIAN_NORWAY_BOKMAL'           : 0x0414,
    'TT_MS_LANGID_NORWEGIAN_NORWAY_NYNORSK'          : 0x0814,
    'TT_MS_LANGID_POLISH_POLAND'                     : 0x0415,
    'TT_MS_LANGID_PORTUGUESE_BRAZIL'                 : 0x0416,
    'TT_MS_LANGID_PORTUGUESE_PORTUGAL'               : 0x0816,
    'TT_MS_LANGID_RHAETO_ROMANIC_SWITZERLAND'        : 0x0417,
    'TT_MS_LANGID_ROMANIAN_ROMANIA'                  : 0x0418,
    'TT_MS_LANGID_MOLDAVIAN_MOLDAVIA'                : 0x0818,
    'TT_MS_LANGID_RUSSIAN_RUSSIA'                    : 0x0419,
    'TT_MS_LANGID_RUSSIAN_MOLDAVIA'                  : 0x0819,
    'TT_MS_LANGID_CROATIAN_CROATIA'                  : 0x041a,
    'TT_MS_LANGID_SERBIAN_SERBIA_LATIN'              : 0x081a,
    'TT_MS_LANGID_SERBIAN_SERBIA_CYRILLIC'           : 0x0c1a,
    'TT_MS_LANGID_CROATIAN_BOSNIA_HERZEGOVINA'       : 0x101a,
    'TT_MS_LANGID_BOSNIAN_BOSNIA_HERZEGOVINA'        : 0x141a,
    'TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_LATIN'         : 0x181a,
    'TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_CYRILLIC'      : 0x181a,
    'TT_MS_LANGID_SLOVAK_SLOVAKIA'                   : 0x041b,
    'TT_MS_LANGID_ALBANIAN_ALBANIA'                  : 0x041c,
    'TT_MS_LANGID_SWEDISH_SWEDEN'                    : 0x041d,
    'TT_MS_LANGID_SWEDISH_FINLAND'                   : 0x081d,
    'TT_MS_LANGID_THAI_THAILAND'                     : 0x041e,
    'TT_MS_LANGID_TURKISH_TURKEY'                    : 0x041f,
    'TT_MS_LANGID_URDU_PAKISTAN'                     : 0x0420,
    'TT_MS_LANGID_URDU_INDIA'                        : 0x0820,
    'TT_MS_LANGID_INDONESIAN_INDONESIA'              : 0x0421,
    'TT_MS_LANGID_UKRAINIAN_UKRAINE'                 : 0x0422,
    'TT_MS_LANGID_BELARUSIAN_BELARUS'                : 0x0423,
    'TT_MS_LANGID_SLOVENE_SLOVENIA'                  : 0x0424,
    'TT_MS_LANGID_ESTONIAN_ESTONIA'                  : 0x0425,
    'TT_MS_LANGID_LATVIAN_LATVIA'                    : 0x0426,
    'TT_MS_LANGID_LITHUANIAN_LITHUANIA'              : 0x0427,
    'TT_MS_LANGID_CLASSIC_LITHUANIAN_LITHUANIA'      : 0x0827,
    'TT_MS_LANGID_TAJIK_TAJIKISTAN'                  : 0x0428,
    'TT_MS_LANGID_FARSI_IRAN'                        : 0x0429,
    'TT_MS_LANGID_VIETNAMESE_VIET_NAM'               : 0x042a,
    'TT_MS_LANGID_ARMENIAN_ARMENIA'                  : 0x042b,
    'TT_MS_LANGID_AZERI_AZERBAIJAN_LATIN'            : 0x042c,
    'TT_MS_LANGID_AZERI_AZERBAIJAN_CYRILLIC'         : 0x082c,
    'TT_MS_LANGID_BASQUE_SPAIN'                      : 0x042d,
    'TT_MS_LANGID_SORBIAN_GERMANY'                   : 0x042e,
    'TT_MS_LANGID_MACEDONIAN_MACEDONIA'              : 0x042f,
    'TT_MS_LANGID_SUTU_SOUTH_AFRICA'                 : 0x0430,
    'TT_MS_LANGID_TSONGA_SOUTH_AFRICA'               : 0x0431,
    'TT_MS_LANGID_TSWANA_SOUTH_AFRICA'               : 0x0432,
    'TT_MS_LANGID_VENDA_SOUTH_AFRICA'                : 0x0433,
    'TT_MS_LANGID_XHOSA_SOUTH_AFRICA'                : 0x0434,
    'TT_MS_LANGID_ZULU_SOUTH_AFRICA'                 : 0x0435,
    'TT_MS_LANGID_AFRIKAANS_SOUTH_AFRICA'            : 0x0436,
    'TT_MS_LANGID_GEORGIAN_GEORGIA'                  : 0x0437,
    'TT_MS_LANGID_FAEROESE_FAEROE_ISLANDS'           : 0x0438,
    'TT_MS_LANGID_HINDI_INDIA'                       : 0x0439,
    'TT_MS_LANGID_MALTESE_MALTA'                     : 0x043a,
    'TT_MS_LANGID_SAMI_NORTHERN_NORWAY'              : 0x043b,
    'TT_MS_LANGID_SAMI_NORTHERN_SWEDEN'              : 0x083b,
    'TT_MS_LANGID_SAMI_NORTHERN_FINLAND'             : 0x0C3b,
    'TT_MS_LANGID_SAMI_LULE_NORWAY'                  : 0x103b,
    'TT_MS_LANGID_SAMI_LULE_SWEDEN'                  : 0x143b,
    'TT_MS_LANGID_SAMI_SOUTHERN_NORWAY'              : 0x183b,
    'TT_MS_LANGID_SAMI_SOUTHERN_SWEDEN'              : 0x1C3b,
    'TT_MS_LANGID_SAMI_SKOLT_FINLAND'                : 0x203b,
    'TT_MS_LANGID_SAMI_INARI_FINLAND'                : 0x243b,
    'TT_MS_LANGID_SAAMI_LAPONIA'                     : 0x043b,
    'TT_MS_LANGID_SCOTTISH_GAELIC_UNITED_KINGDOM'    : 0x083c,
    'TT_MS_LANGID_IRISH_GAELIC_IRELAND'              : 0x043c,
    'TT_MS_LANGID_YIDDISH_GERMANY'                   : 0x043d,
    'TT_MS_LANGID_MALAY_MALAYSIA'                    : 0x043e,
    'TT_MS_LANGID_MALAY_BRUNEI_DARUSSALAM'           : 0x083e,
    'TT_MS_LANGID_KAZAK_KAZAKSTAN'                   : 0x043f,
    'TT_MS_LANGID_KIRGHIZ_KIRGHIZSTAN'               : 0x0440,
    'TT_MS_LANGID_KIRGHIZ_KIRGHIZ_REPUBLIC'          : 0x0440,
    'TT_MS_LANGID_SWAHILI_KENYA'                     : 0x0441,
    'TT_MS_LANGID_TURKMEN_TURKMENISTAN'              : 0x0442,
    'TT_MS_LANGID_UZBEK_UZBEKISTAN_LATIN'            : 0x0443,
    'TT_MS_LANGID_UZBEK_UZBEKISTAN_CYRILLIC'         : 0x0843,
    'TT_MS_LANGID_TATAR_TATARSTAN'                   : 0x0444,
    'TT_MS_LANGID_BENGALI_INDIA'                     : 0x0445,
    'TT_MS_LANGID_BENGALI_BANGLADESH'                : 0x0845,
    'TT_MS_LANGID_PUNJABI_INDIA'                     : 0x0446,
    'TT_MS_LANGID_PUNJABI_ARABIC_PAKISTAN'           : 0x0846,
    'TT_MS_LANGID_GUJARATI_INDIA'                    : 0x0447,
    'TT_MS_LANGID_ORIYA_INDIA'                       : 0x0448,
    'TT_MS_LANGID_TAMIL_INDIA'                       : 0x0449,
    'TT_MS_LANGID_TELUGU_INDIA'                      : 0x044a,
    'TT_MS_LANGID_KANNADA_INDIA'                     : 0x044b,
    'TT_MS_LANGID_MALAYALAM_INDIA'                   : 0x044c,
    'TT_MS_LANGID_ASSAMESE_INDIA'                    : 0x044d,
    'TT_MS_LANGID_MARATHI_INDIA'                     : 0x044e,
    'TT_MS_LANGID_SANSKRIT_INDIA'                    : 0x044f,
    'TT_MS_LANGID_MONGOLIAN_MONGOLIA'                : 0x0450,
    'TT_MS_LANGID_MONGOLIAN_MONGOLIA_MONGOLIAN'      : 0x0850,
    'TT_MS_LANGID_TIBETAN_CHINA'                     : 0x0451,
    'TT_MS_LANGID_DZONGHKA_BHUTAN'                   : 0x0851,
    'TT_MS_LANGID_TIBETAN_BHUTAN'                    : 0x0851,
    'TT_MS_LANGID_WELSH_WALES'                       : 0x0452,
    'TT_MS_LANGID_KHMER_CAMBODIA'                    : 0x0453,
    'TT_MS_LANGID_LAO_LAOS'                          : 0x0454,
    'TT_MS_LANGID_BURMESE_MYANMAR'                   : 0x0455,
    'TT_MS_LANGID_GALICIAN_SPAIN'                    : 0x0456,
    'TT_MS_LANGID_KONKANI_INDIA'                     : 0x0457,
    'TT_MS_LANGID_MANIPURI_INDIA'                    : 0x0458,
    'TT_MS_LANGID_SINDHI_INDIA'                      : 0x0459,
    'TT_MS_LANGID_SINDHI_PAKISTAN'                   : 0x0859,
    'TT_MS_LANGID_SYRIAC_SYRIA'                      : 0x045a,
    'TT_MS_LANGID_SINHALESE_SRI_LANKA'               : 0x045b,
    'TT_MS_LANGID_CHEROKEE_UNITED_STATES'            : 0x045c,
    'TT_MS_LANGID_INUKTITUT_CANADA'                  : 0x045d,
    'TT_MS_LANGID_AMHARIC_ETHIOPIA'                  : 0x045e,
    'TT_MS_LANGID_TAMAZIGHT_MOROCCO'                 : 0x045f,
    'TT_MS_LANGID_TAMAZIGHT_MOROCCO_LATIN'           : 0x085f,
    'TT_MS_LANGID_KASHMIRI_PAKISTAN'                 : 0x0460,
    'TT_MS_LANGID_KASHMIRI_SASIA'                    : 0x0860,
    'TT_MS_LANGID_KASHMIRI_INDIA'                    : 0x0860,
    'TT_MS_LANGID_NEPALI_NEPAL'                      : 0x0461,
    'TT_MS_LANGID_NEPALI_INDIA'                      : 0x0861,
    'TT_MS_LANGID_FRISIAN_NETHERLANDS'               : 0x0462,
    'TT_MS_LANGID_PASHTO_AFGHANISTAN'                : 0x0463,
    'TT_MS_LANGID_FILIPINO_PHILIPPINES'              : 0x0464,
    'TT_MS_LANGID_DHIVEHI_MALDIVES'                  : 0x0465,
    'TT_MS_LANGID_DIVEHI_MALDIVES'                   : 0x0465,
    'TT_MS_LANGID_EDO_NIGERIA'                       : 0x0466,
    'TT_MS_LANGID_FULFULDE_NIGERIA'                  : 0x0467,
    'TT_MS_LANGID_HAUSA_NIGERIA'                     : 0x0468,
    'TT_MS_LANGID_IBIBIO_NIGERIA'                    : 0x0469,
    'TT_MS_LANGID_YORUBA_NIGERIA'                    : 0x046a,
    'TT_MS_LANGID_QUECHUA_BOLIVIA'                   : 0x046b,
    'TT_MS_LANGID_QUECHUA_ECUADOR'                   : 0x086b,
    'TT_MS_LANGID_QUECHUA_PERU'                      : 0x0c6b,
    'TT_MS_LANGID_SEPEDI_SOUTH_AFRICA'               : 0x046c,
    'TT_MS_LANGID_SOTHO_SOUTHERN_SOUTH_AFRICA'       : 0x046c,
    'TT_MS_LANGID_IGBO_NIGERIA'                      : 0x0470,
    'TT_MS_LANGID_KANURI_NIGERIA'                    : 0x0471,
    'TT_MS_LANGID_OROMO_ETHIOPIA'                    : 0x0472,
    'TT_MS_LANGID_TIGRIGNA_ETHIOPIA'                 : 0x0473,
    'TT_MS_LANGID_TIGRIGNA_ERYTHREA'                 : 0x0873,
    'TT_MS_LANGID_TIGRIGNA_ERYTREA'                  : 0x0873,
    'TT_MS_LANGID_GUARANI_PARAGUAY'                  : 0x0474,
    'TT_MS_LANGID_HAWAIIAN_UNITED_STATES'            : 0x0475,
    'TT_MS_LANGID_LATIN'                             : 0x0476,
    'TT_MS_LANGID_SOMALI_SOMALIA'                    : 0x0477,
    'TT_MS_LANGID_YI_CHINA'                          : 0x0478,
    'TT_MS_LANGID_PAPIAMENTU_NETHERLANDS_ANTILLES'   : 0x0479,
    'TT_MS_LANGID_UIGHUR_CHINA'                      : 0x0480,
    'TT_MS_LANGID_MAORI_NEW_ZEALAND'                 : 0x0481 }
globals().update(TT_MS_LANGIDS)
