#include <stdlib.h>
#include "shgetc.h"
#include "floatscan.h"
#include "stdio_impl.h"
#include "libc.h"

static long double strtox(const char *s, char **p, int prec)
{
	FILE f = {
		.buf = (void *)s, .rpos = (void *)s,
		.rend = (void *)-1, .lock = -1
	};
	shlim(&f, 0);
	long double y = __floatscan(&f, prec, 1);
	off_t cnt = shcnt(&f);
	if (p) *p = cnt ? (char *)s + cnt : (char *)s;
	return y;
}

float strtof(const char *restrict s, char **restrict p)
{
	return strtox(s, p, 0);
}

double strtod(const char *restrict s, char **restrict p)
{
	return strtox(s, p, 1);
}

long double strtold(const char *restrict s, char **restrict p)
{
	return strtox(s, p, 2);
}

float strtof_l(const char *restrict s, char **restrict p, struct __locale_struct *loc)
{
  return strtof(s, p);
}

double strtod_l(const char *restrict s, char **restrict p, struct __locale_struct *loc)
{
  return strtod(s, p);
}

long double strtold_l(const char *restrict s, char **restrict p, struct __locale_struct *loc)
{
  return strtold(s, p);
}

weak_alias(strtof_l, __strtof_l);
weak_alias(strtod_l, __strtod_l);
weak_alias(strtold_l, __strtold_l);
