//===- FuzzerMain.cpp - main() function and flags -------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
// main() and flags.
//===----------------------------------------------------------------------===//

#include "FuzzerDefs.h"
#include "FuzzerPlatform.h"

extern "C" {

// This function should be defined by the user.
int LLVMFuzzerTestOneInput(const uint8_t *Data, size_t Size);

}  // extern "C"

ATTRIBUTE_INTERFACE int main(int argc, char **argv) {

  return fuzzer::FuzzerDriver(&argc, &argv, LLVMFuzzerTestOneInput);

}

