/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserAddCertRequest;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserAddCertDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserAddCertDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserAddCertRequest) {
            UserAddCertRequest req = (UserAddCertRequest)request;
            LOG.debug((Object)("Uploading certificate " + request));
            if (req.getCert() == null && req.getCertFile() == null) {
                Utils.exit(1, "no certificate has been passed in", null);
            } else if (!(req.getCert() != null ^ req.getCertFile() != null)) {
                Utils.exit(1, "can only specify one of -c -o", null);
            }
            UploadSigningCertificateRequest certificateRequest = new UploadSigningCertificateRequest();
            if (req.getCert() != null) {
                certificateRequest.setCertificateBody(req.getCert());
            } else {
                String certBody = Utils.readFile(req.getCertFile());
                LOG.debug((Object)("certificate body read from file is : " + certBody));
                certificateRequest.setCertificateBody(certBody);
            }
            certificateRequest.setUserName(req.getUserName());
            UploadSigningCertificateResult result = this.getClient().uploadSigningCertificate(certificateRequest);
            LOG.info((Object)result.getCertificate().getCertificateId());
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

