/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.interop.InteropTest;
import org.apache.xml.security.test.utils.resolver.OfflineResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class BaltimoreTest
extends InteropTest {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$interop$BaltimoreTest == null ? (class$org$apache$xml$security$test$interop$BaltimoreTest = BaltimoreTest.class$("org.apache.xml.security.test.interop.BaltimoreTest")) : class$org$apache$xml$security$test$interop$BaltimoreTest).getName());
    static String merlinsDir15 = "data/ie/baltimore/merlin-examples/merlin-xmldsig-fifteen/";
    static String merlinsDir16 = "data/ie/baltimore/merlin-examples/merlin-xmldsig-sixteen";
    static String merlinsDir23 = "data/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/";
    static /* synthetic */ Class class$org$apache$xml$security$test$interop$BaltimoreTest;

    public static Test suite() {
        TestSuite testSuite = new TestSuite(class$org$apache$xml$security$test$interop$BaltimoreTest == null ? (class$org$apache$xml$security$test$interop$BaltimoreTest = BaltimoreTest.class$("org.apache.xml.security.test.interop.BaltimoreTest")) : class$org$apache$xml$security$test$interop$BaltimoreTest);
        return testSuite;
    }

    public BaltimoreTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$interop$BaltimoreTest == null ? (class$org$apache$xml$security$test$interop$BaltimoreTest = BaltimoreTest.class$("org.apache.xml.security.test.interop.BaltimoreTest")) : class$org$apache$xml$security$test$interop$BaltimoreTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void test_fifteen_enveloping_hmac_sha1() throws Exception {
        String string = merlinsDir15 + "signature-enveloping-hmac-sha1.xml";
        boolean bl = this.verifyHMAC(string, new OfflineResolver(), false, "secret".getBytes("ASCII"));
        if (!bl) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl);
    }

    public void test_fifteen_enveloping_hmac_sha1_40() throws Exception {
        block3: {
            String string = merlinsDir15 + "signature-enveloping-hmac-sha1-40.xml";
            OfflineResolver offlineResolver = new OfflineResolver();
            boolean bl = false;
            byte[] byArray = "secret".getBytes("ASCII");
            try {
                this.verifyHMAC(string, offlineResolver, bl, byArray);
                BaltimoreTest.fail((String)"HMACOutputLength Exception not caught");
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)("Verification crashed for " + string));
                throw runtimeException;
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block3;
                BaltimoreTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    public void test_fifteen_enveloped_dsa() throws Exception {
        String string = merlinsDir15 + "signature-enveloped-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_fifteen_enveloping_b64_dsa() throws Exception {
        String string = merlinsDir15 + "signature-enveloping-b64-dsa.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_fifteen_enveloping_dsa() throws Exception {
        String string = merlinsDir15 + "signature-enveloping-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_fifteen_enveloping_rsa() throws Exception {
        String string = merlinsDir15 + "signature-enveloping-rsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_fifteen_external_b64_dsa() throws Exception {
        String string = merlinsDir15 + "signature-external-b64-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_fifteen_external_dsa() throws Exception {
        String string = merlinsDir15 + "signature-external-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_sixteen_external_dsa() throws Exception {
        String string = merlinsDir16 + "/signature.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_sixteen_bad_signature() throws Exception {
        String string = merlinsDir16 + "/bad-signature.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (bl2) {
            log.error((Object)("Verification passed (should have failed) for " + string));
        }
        BaltimoreTest.assertFalse((String)string, (boolean)bl2);
    }

    public void test_twenty_three_enveloping_hmac_sha1() throws Exception {
        String string = merlinsDir23 + "signature-enveloping-hmac-sha1.xml";
        boolean bl = this.verifyHMAC(string, new OfflineResolver(), false, "secret".getBytes("ASCII"));
        if (!bl) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl);
    }

    public void test_twenty_three_enveloping_hmac_sha1_40() throws Exception {
        block3: {
            String string = merlinsDir23 + "signature-enveloping-hmac-sha1-40.xml";
            OfflineResolver offlineResolver = new OfflineResolver();
            boolean bl = false;
            byte[] byArray = "secret".getBytes("ASCII");
            try {
                this.verifyHMAC(string, offlineResolver, bl, byArray);
                BaltimoreTest.fail((String)"HMACOutputLength Exception not caught");
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)("Verification crashed for " + string));
                throw runtimeException;
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block3;
                BaltimoreTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    public void test_twenty_three_enveloped_dsa() throws Exception {
        String string = merlinsDir23 + "signature-enveloped-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_enveloping_b64_dsa() throws Exception {
        String string = merlinsDir23 + "signature-enveloping-b64-dsa.xml";
        ResourceResolverSpi resourceResolverSpi = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, resourceResolverSpi, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_enveloping_dsa() throws Exception {
        String string = merlinsDir23 + "signature-enveloping-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_enveloping_rsa() throws Exception {
        String string = merlinsDir23 + "signature-enveloping-rsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_external_b64_dsa() throws Exception {
        String string = merlinsDir23 + "signature-external-b64-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_external_dsa() throws Exception {
        String string = merlinsDir23 + "signature-external-dsa.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    public void test_twenty_three_external_dsa_2() throws Exception {
        String string = merlinsDir23 + "signature.xml";
        OfflineResolver offlineResolver = new OfflineResolver();
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = this.verify(string, offlineResolver, bl);
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("Verification crashed for " + string));
            throw runtimeException;
        }
        if (!bl2) {
            log.error((Object)("Verification failed for " + string));
        }
        BaltimoreTest.assertTrue((String)string, (boolean)bl2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            merlinsDir15 = string + "/" + merlinsDir15;
            merlinsDir16 = string + "/" + merlinsDir16;
            merlinsDir23 = string + "/" + merlinsDir23;
        }
        Init.init();
    }
}

