/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;

public class EnvVarCommandProcessor
implements CommandProcessor {
    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        for (ParamConfig param : parameters) {
            String value;
            if (param.getEnvVarValue() == null || StringUtils.isEmpty(value = System.getenv(param.getEnvVarValue().getVariableName()))) continue;
            param.setValue(value, ParamConfig.InputMode.ENV_VAR);
        }
        return process;
    }
}

