/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;

public class PolygonTool
extends AbstractTool {
    private PolygonFigure fPolygon;
    private int fLastX;
    private int fLastY;
    private Figure myAddedFigure;

    public PolygonTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void activate() {
        super.activate();
        this.fPolygon = null;
    }

    public void deactivate() {
        if (this.fPolygon != null) {
            this.fPolygon.smoothPoints();
            if (this.fPolygon.pointCount() < 3 || this.fPolygon.size().width < 4 || this.fPolygon.size().height < 4) {
                this.getActiveView().drawing().remove(this.fPolygon);
                this.setUndoActivity(null);
            }
        }
        this.fPolygon = null;
        super.deactivate();
    }

    private void addPoint(int n, int n2) {
        if (this.fPolygon == null) {
            this.fPolygon = new PolygonFigure(n, n2);
            this.setAddedFigure(this.view().add(this.fPolygon));
            this.fPolygon.addPoint(n, n2);
        } else if (this.fLastX != n || this.fLastY != n2) {
            this.fPolygon.addPoint(n, n2);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        if (mouseEvent.getClickCount() >= 2) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                this.editor().toolDone();
            }
            this.fPolygon = null;
        } else {
            this.addPoint(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getSource() == this.getActiveView() && this.fPolygon != null && this.fPolygon.pointCount() > 1) {
            this.fPolygon.setPointAt(new Point(n, n2), this.fPolygon.pointCount() - 1);
            this.getActiveView().checkDamage();
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        this.addPoint(n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure figure) {
        this.myAddedFigure = figure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }
}

