/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HprofScrubber {
    private static void dumpSamples(Sample[] sampleArray, Map map) {
        int n = 0;
        int n2 = 0;
        while (n2 < sampleArray.length) {
            n += sampleArray[n2].count;
            ++n2;
        }
        System.out.println("          percent");
        System.out.println("rank   self  accum      count");
        System.out.println("Total:              " + n);
        double d = 0.0;
        MessageFormat messageFormat = new MessageFormat("{0,number,00000} {1,number,00.00}% {2,number,00.00}% {3,number,000000000}");
        int n3 = 0;
        while (n3 < sampleArray.length) {
            Sample sample = sampleArray[n3];
            double d2 = 100.0 * ((double)sample.count / (double)n);
            System.out.println(messageFormat.format(new Object[]{new Integer(n3 + 1), new Double(d2), new Double(d += d2), new Integer(sample.count)}, new StringBuffer(), new FieldPosition(0)));
            String[] stringArray = (String[])map.get(new Integer(sample.traceNumber));
            if (stringArray != null) {
                int n4 = 0;
                while (n4 < stringArray.length) {
                    System.out.println("                           " + stringArray[n4]);
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private static void dumpSites(Site[] siteArray, Map map) {
        Arrays.sort(siteArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Site)object2).allocatedBytes - ((Site)object).allocatedBytes;
            }
        });
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < siteArray.length) {
            Site site = siteArray[n3];
            n += site.allocatedBytes;
            n2 += site.allocatedObjects;
            ++n3;
        }
        System.out.println("          percent          alloc'ed");
        System.out.println("rank   self  accum      bytes  objects  class name");
        System.out.println("Total:              " + n + "  " + n2);
        double d = 0.0;
        MessageFormat messageFormat = new MessageFormat("{0,number,00000} {1,number,00.00}% {2,number,00.00}% {3,number,000000000} {4,number,000000000} {5}");
        int n4 = 0;
        while (n4 < siteArray.length) {
            Site site = siteArray[n4];
            double d2 = 100.0 * ((double)site.allocatedBytes / (double)n);
            System.out.println(messageFormat.format(new Object[]{new Integer(n4 + 1), new Double(d2), new Double(d += d2), new Integer(site.allocatedBytes), new Integer(site.allocatedObjects), site.className}, new StringBuffer(), new FieldPosition(0)));
            String[] stringArray = (String[])map.get(new Integer(site.traceNumber));
            if (stringArray != null) {
                int n5 = 0;
                while (n5 < stringArray.length) {
                    System.out.println("                           " + stringArray[n5]);
                    ++n5;
                }
            }
            ++n4;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length == 0 ? "java.hprof.txt" : stringArray[0];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            HashMap<Integer, String[]> hashMap = new HashMap<Integer, String[]>();
            ArrayList<Site> arrayList = new ArrayList<Site>();
            ArrayList<Sample> arrayList2 = new ArrayList<Sample>();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("SITES BEGIN")) {
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    while (!(string2 = bufferedReader.readLine()).startsWith("SITES END")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        arrayList.add(new Site(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken()));
                    }
                    continue;
                }
                if (string2.startsWith("TRACE ") && string2.endsWith(":")) {
                    int n = Integer.parseInt(string2.substring(6, string2.length() - 1));
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    while ((string2 = bufferedReader.readLine()).startsWith("\t")) {
                        arrayList3.add(string2.substring(1));
                    }
                    hashMap.put(new Integer(n), arrayList3.toArray(new String[arrayList3.size()]));
                    continue;
                }
                if (string2.startsWith("CPU SAMPLES BEGIN")) {
                    bufferedReader.readLine();
                    while (!(string2 = bufferedReader.readLine()).startsWith("CPU SAMPLES END")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n == 0) continue;
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        arrayList2.add(new Sample(n, n2));
                    }
                    continue;
                }
                string2 = bufferedReader.readLine();
            }
            HprofScrubber.dumpSites(arrayList.toArray(new Site[arrayList.size()]), hashMap);
            HprofScrubber.dumpSamples(arrayList2.toArray(new Sample[arrayList2.size()]), hashMap);
        }
        catch (Throwable throwable) {
            Object var4_14 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_13 = null;
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    private static class Site {
        public final int allocatedBytes;
        public final int allocatedObjects;
        public final int traceNumber;
        public final String className;

        public Site(int n, int n2, int n3, String string) {
            this.allocatedBytes = n;
            this.allocatedObjects = n2;
            this.traceNumber = n3;
            this.className = string;
        }
    }

    private static class Sample {
        public final int count;
        public final int traceNumber;

        public Sample(int n, int n2) {
            this.count = n;
            this.traceNumber = n2;
        }
    }
}

