# tcl/tk browser for Xconq image families.
# Copyright (C) 1998, 1999 Stanley T. Shebs.

# Xconq is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.  See the file COPYING.

set mag 32
set showcolor 1
set shownames 1
set showmasks 1
set bgcolor gray
set showbbox 0
set showsolid 0

set as unit

set tk_strictMotif 1

wm title . imfapp

menu .menubar
. configure -menu .menubar

.menubar add cascade -label File -menu .menubar.file
menu .menubar.file
.menubar.file add command -label New \
	-command { new_cmd }
.menubar.file add command -label "Open Imf Dir..." -state disabled \
	-command { open_imf_dir_cmd }
.menubar.file add command -label "Add Imf File..." \
	-command { add_imf_file_cmd }
.menubar.file add command -label "Add Other File..." \
	-command { add_other_file_cmd }
.menubar.file add separator
.menubar.file add command -label "Save Imf Dir..." -state disabled \
	-command { save_imf_dir_cmd }
.menubar.file add command -label "Save Imf File..." \
	-command { save_imf_file_cmd }
.menubar.file add check -label "Save Selected Only" \
	-variable save_selected_only
.menubar.file add separator
.menubar.file add command -label Quit \
	-command { exit }

.menubar add cascade -label View -menu .menubar.view
menu .menubar.view
.menubar.view add radio -label 8x8 -variable mag -value 8 \
	-command { .images.content config -iwidth 8 -iheight 8 }
.menubar.view add radio -label 16x16 -variable mag -value 16 \
	-command { .images.content config -iwidth 16 -iheight 16 }
.menubar.view add radio -label 32x32 -variable mag -value 32 \
	-command { .images.content config -iwidth 32 -iheight 32 }
.menubar.view add radio -label 64x64 -variable mag -value 64 \
	-command { .images.content config -iwidth 64 -iheight 64 }
.menubar.view add separator
.menubar.view add check -label Color -variable showcolor \
	-command { toggle_show_color }
.menubar.view add check -label Names -variable shownames \
	-command { toggle_show_names }
.menubar.view add check -label Masks -variable showmasks \
	-command { toggle_show_masks }
.menubar.view add cascade -label Background -menu .menubar.view.bg
menu .menubar.view.bg
.menubar.view.bg add radio -label black -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label gray -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label white -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label red -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label green -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label blue -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view add check -label BBox -variable showbbox \
	-command { toggle_show_bbox }
.menubar.view add check -label "Solid Color" -variable showsolid \
	-command { toggle_show_solid }
.menubar.view add separator
.menubar.view add radio -label "As Unit" -variable as -value unit \
	-command { toggle_as_unit }
.menubar.view add radio -label "As Terrain" -variable as -value terrain \
	-command { toggle_as_terrain }
.menubar.view add radio -label "As Emblem" -variable as -value emblem \
	-command { toggle_as_emblem }
.menubar.view add check -label "With Unit" -variable with_unit \
	-command { toggle_with_unit }
.menubar.view add check -label "With Selected as Terrain" -variable with_terrain \
	-command { toggle_with_terrain }
.menubar.view add check -label "With Selected As Emblem" \
	-variable with_emblem \
	-command { toggle_with_emblem }

frame .closeup -borderwidth 2 -relief sunken
pack .closeup -side top -fill x

canvas .closeup.content -height 170
pack .closeup.content -side top -fill both

.closeup.content create text 10 20 -tag selname -text "(nothing selected)" -anchor sw
.closeup.content create text 480 20 -tag status -text "" -anchor se

set winbgcolor [ .closeup.content cget -background ]

set sy 30
.closeup.content create line 0 $sy 5000 $sy -tag line1 -fill gray
incr sy 3
imfsample .closeup.content.line1 -bg $winbgcolor -width 8 -height 8 -iwidth 8 -iheight 8
.closeup.content create window 2 $sy -window .closeup.content.line1 -anchor nw
incr sy [ expr 8 + 2 ]
.closeup.content create line 0 $sy 5000 $sy -tag line2 -fill gray
incr sy 3
imfsample .closeup.content.line2 -bg $winbgcolor -width 16 -height 16 -iwidth 16 -iheight 16
.closeup.content create window 2 $sy -window .closeup.content.line2 -anchor nw
incr sy [ expr 16 + 2 ]
.closeup.content create line 0 $sy 5000 $sy -tag line3 -fill gray
incr sy 3
imfsample .closeup.content.line3 -bg $winbgcolor -width 32 -height 32 -iwidth 32 -iheight 32
.closeup.content create window 2 $sy -window .closeup.content.line3 -anchor nw
incr sy [ expr 32 + 2 ]
.closeup.content create line 0 $sy 5000 $sy -tag line4 -fill gray
incr sy 3
imfsample .closeup.content.line4 -bg $winbgcolor -width 64 -height 64 -iwidth 64 -iheight 64
.closeup.content create window 2 $sy -window .closeup.content.line4 -anchor nw

frame .images -width 500 -height 300
pack .images -side top -fill both -expand true
pack propagate .images false

imfsample .images.content -pad 2 \
	-showcolor $showcolor -showmasks $showmasks -bg $bgcolor
#	-yscrollcommand { .images.scroll set }

scrollbar .images.scroll -orient vert -command { .images.content yview }
pack .images.scroll -side right -fill y
pack .images.content -side left -fill both -expand true

bind .images.content <ButtonRelease-1> { select_imf %x %y }

proc set_initial_view {} {
    .closeup.content itemconfig status -text [ get_imf_status ]
}

# Clear all existing images, start afresh.

proc new_cmd {} {
    .images.content remove all
}

proc open_imf_dir_cmd {} {
}

proc add_imf_file_cmd {} {
    set filename [ tk_getOpenFile ]
    if { $filename != {} } {
	load_imf_file $filename
	.closeup.content itemconfig status -text [ get_imf_status ]
    }
}

proc save_imf_dir_cmd {} {
}

proc save_imf_file_cmd {} {
    set filename [ tk_getSaveFile -initialfile "images.imf" ]
    if { $filename != {} } {
	save_imf_file $filename
    }
}

proc toggle_show_color {} {
    global showcolor

    .images.content config -showcolor $showcolor
}

proc toggle_show_names {} {
    global shownames

    .images.content config -shownames $shownames
}

proc toggle_show_masks {} {
    global showmasks

    .images.content config -showmasks $showmasks
}

proc toggle_show_bbox {} {
    global showbbox

    .images.content config -showbbox $showbbox
}

proc toggle_show_solid {} {
    global showsolid

    .images.content config -showsolid $showsolid
}

proc toggle_as_unit {} {
}

proc toggle_as_terrain {} {
}

proc toggle_as_emblem {} {
}

proc toggle_with_unit {} {
#    .images.content unit [ .images.content curselection ]
}

proc toggle_with_terrain {} {
    .images.content terrain [ .images.content curselection ]
}

proc toggle_with_emblem {} {
    .images.content emblem [ .images.content curselection ]
}

proc select_imf { x y } {
    .images.content select $x $y
    set n [ .images.content curselection ]
    if { $n >= 0 } {
	set header "[ get_imf_name $n ] ([ get_imf_numsizes $n ] images)" 
	.closeup.content.line1 replace imf [ get_imf_name $n ]
	.closeup.content.line2 replace imf [ get_imf_name $n ]
	.closeup.content.line3 replace imf [ get_imf_name $n ]
	.closeup.content.line4 replace imf [ get_imf_name $n ]
    } else {
	set header "(nothing selected)"
    }
    .closeup.content itemconfigure selname -text $header
}
