'\"
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) loadTk.n 1.5 97/08/18 17:44:43
'\" 
.so man.macros
.TH "Safe Tk" n 8.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
loadTk \- Load Tk into a safe interpreter.
.SH SYNOPSIS
\fB::safe::loadTk \fIslave\fR ?\fB\-use\fR \fIwindowId\fR?
.BE

Safe Tk is based on Safe Tcl, which provides a mechanism 
that allows restricted and mediated
access to auto-loading and packages for safe interpreters.
Safe Tk adds the ability to configure the interpreter
for safe Tk operations and load Tk into safe 
interpreters.

.SH DESCRIPTION
.PP
The \fB::safe::loadTk\fR command initializes the required data structures
in the named safe interpreter and then loads Tk into it.
The command returns the name of the safe interpreter.
If \fB\-use\fR is specified, the window identified by the specified system
dependent identifier \fIwindowId\fR is used to contain the \fB``.''\fR
window of the safe interpreter; it can be any valid id, eventually 
referencing a window belonging to another application.
Otherwise, a new toplevel window is created for the \fB``.''\fR window of
the safe interpreter.
See the \fBSECURITY ISSUES\fR section below for implementation details.

.SH SECURITY ISSUES
.PP
Please read the \fBsafe\fR manual page for Tcl to learn about the basic
security considerations for Safe Tcl.
.PP
Information in the safe interpreter should never be trusted for security
purposes.
However, because Tk initialization of the safe interpreter do use 
local information, it is unsafe if the safe interpreter 
could have gained control before Tk is loaded.
This will be fixed in an upcoming release, by making Tk initialization in a
safe interpreter use only information found in the interpreter's master
instead of relying on the (un)safe interpreter state.
.PP
You should therefore use \fBsafe::loadTk $slave\fR as soon as possible
after \fBsafe::interpCreate\fR and before any code is evaluated in the safe
interpreter.
The preferred sequence is:
.CS
set slave [::safe::loadTk [::safe::interpCreate]]
.CE
If you want to prevent safe interpreters from loading Tk entirely, you
should create the interpreter as follows:
.CS
::safe::interpCreate \-nostatics \-accesspath \fI{directories...}\fR
.CE
and you must also insure that the virtual access path \fIdirectories\fR for
the interpreter does not contain a dynamically loadable version of Tk.
.PP
\fB::safe::loadTk\fR adds the value of \fBtk_library\fR taken from the master
interpreter to the virtual access path of the safe interpreter so that
auto-loading will work in the safe interpreter.
It also sets \fBenv(DISPLAY)\fR in the safe interpreter to the value of
\fBenv(DISPLAY)\fR in the master interpreter, if it exists.
Finally, it sets the slave's Tcl variable \fBargv\fR to \fB\-use\fR 
\fIwindowId\fR in the safe interpreter.

When \fB\-use\fR is not used, the new toplevel created is specially
decorated so the user is always aware that the user interface presented comes
from a potentially unsafe code and can easily delete the corresponding
interpreter.

.SH "SEE ALSO"
safe(n), interp(n), library(n), load(n), package(n), source(n), unknown(n)
 
.SH KEYWORDS
alias, auto\-loading, auto_mkindex, load, master interpreter, safe
interpreter, slave interpreter, source
