(game-module "intro"
  (title "Introductory Game")
  (blurb "An introduction to Xconq; your goal is to explore and take over the world.")
  ;; no variants, this is just a basic game.
)

(unit-type infantry (image-name "soldiers")
  (help "slow-moving but quick to make"))
(unit-type armor (image-name "tank")
  (help "fast-moving and powerful"))
(unit-type transport (image-name "ap")
  (help "ferries ground units over the sea"))
(unit-type battleship (image-name "bb")
  (help "rids the sea of transports and attacks anything on coast"))
(unit-type base (image-name "airbase") (char "/")
  (help "infantry can build, ships can use like a canal"))
(unit-type city (image-name "city20") (char "@")
  (help "cities build units and represent territory"))

(terrain-type sea (char ".")
  (help "where the ships are"))
(terrain-type land (image-name "plains") (char "+")
  (help "easy movement for infantry and armor"))
(terrain-type mountains (char "^")
  (help "rugged terrain, slows down armor"))

(add sea liquid true)

;;; Static relationships.

(table vanishes-on
  ((infantry armor base city) sea true)
  ((transport battleship) (land mountains) true)
  )

(add (transport base city) capacity (6 6 24))

(table unit-size-as-occupant
  (u* u* 99)
  ((infantry armor) transport 1)
  ((infantry armor) (base city) 1)
  ((transport battleship) city (3 6))
  )

;;; Actions.

(add u* acp-per-turn (1 2 2 4 0 1))

;;; Movement.

(add (base city) speed 0)

(table mp-to-enter-terrain
  ;; Prevent movement into hostile terrain.
  ((infantry armor) sea 99)
  ((transport battleship) (land mountains) 99)
  ;; Armor is slower in mountains.
  (armor mountains 2)
  )

;; We don't need to be picky about counting mp.

(add armor free-mp 1)

;;; Construction.

(add u* cp (4 6 12 30 6 1))

(table acp-to-create
  (city (infantry armor transport battleship) 1)
  (infantry base 1)
  )

(table acp-to-build
  (city (infantry armor transport battleship) 1)
  (infantry base 1)
  )

;;; Combat.

(add u* hp-max (2 2 1 4 10 40))

(table hit-chance
  (infantry u* (50 30 20 10 30  50))
  (armor u*    (70 70 40 20 50 100))
  ;; Transports can never fight.
  (battleship u* 80)
  )

(table damage
  (u* u* 1)
  )

(table capture-chance
  (infantry (base city) (50 50))
  (armor    (base city) (90 70))
  ;; As a special case, infantry can sometimes capture armor.
  (infantry armor 10)
  )

;;; Initialization parameters.

(add t* alt-percentile-min (  0  60  90))
(add t* alt-percentile-max ( 60  90 100))
(add t* wet-percentile-min (  0   0   0))
(add t* wet-percentile-max (100 100 100))

(add (sea land) country-terrain-min (1 7))
(add city start-with 1)
(add city independent-near-start 3)
(set country-radius-min 3)
;; Countries are close together so beginners can find the enemy easily.
(set country-separation-min 6)
(set country-separation-max 8)

(table independent-density
  (city (land mountains) (200 20))
  )

(table favored-terrain
  (u* t* 0)
  ((infantry armor) land 100)
  (city (land mountains) (100 10))
  )

(include "ng-weird")
(add city namer "short-generic-names")

;; Hexagon map is simpler to play on than cylinder.
 
(world 120)

;; Fixed area, easier to play on.

(area 40 20)

;; Wire to exactly two players, no options.

(side 1 (noun "human"))

(side 2 (noun "robot"))

(set sides-min 2)
(set sides-max 2)

;; This is just a simple "take over the world", easier to explain.

(scorekeeper (do last-side-wins))

;; Only cities count.

(add u* point-value 0)
(add u* point-value 1)

(set synthesis-methods nil)

(area 40 20)

(area 40 20 (terrain
  "40a"
  "3a3b3a4b8c2b3a5b9a"
  "4a2b4a9b3cb3ab2a2bc8a"
  "5ab5a10b3cb5a3b7a"
  "ab3a2b5a9b5cb3a4b6a"
  "abcb2a2b4a3bc6b4c4a2b8a"
  "a3b2ab2c14bcb15a"
  "a3b3a4c3b2a7b13ab3a"
  "a3b3ab3c2b4a6b13abc2a"
  "ac3b3ab3c2b4a6b12ab2ca"
  "2a4b3a3c3b3a10b8ab2ca"
  "3a3b3ab3c4b3abcba4b5ab3a2ba"
  "4a4b2a2bc4b4a2b2a3b5a2b3aba"
  "5a3b6a3b9abcb3a3b5a"
  "6a4b4a4b8ab2cb2a2bcb4a"
  "10ab2abc4b8a3b3a3b4a"
  "11abab2cb3a2b2a3b7a2b4a"
  "14abcb4a7b6a3b3a"
  "22a3bc2b6a4b2a"
  "40a"
  ))

(city 18 9 0 (n "Bonsig"))
(city 5 15 0 (n "Druent"))
(city 3 11 0 (n "Ernou"))
(city 21 7 0 (n "Hall Sep"))
(city 14 15 0 (n "Hanawhald"))
(city 15 8 0 (n "Lynug"))
(city 13 13 0 (n "Mebnels"))
(city 16 15 0 (n "Nugbag"))
(city 22 11 0 (n "Opplen"))
(city 18 13 0 (n "Reva"))
(city 18 4 0 (n "Uk Fensotguf"))
(city 13 8 0 (n "Vetpi"))

(city 12 10 1 (n "Jinod"))

(city 17 12 2 (n "Ko Renme"))

(game-module (instructions (
  "This game is an introduction to Xconq."
  ""
  "You start with one city and try to expand throughout the world."
  "Eventually you will encounter the evil robots, and must do battle"
  "with them."
  ""
  "To get things going, use your first infantry to explore around."
  ""
  "You should try to capture independent cities and set them to"
  "building also, either infantry or armor.  Armor moves faster,"
  "but also takes longer to build."
  ""
  "When you find the bad guys, try to capture their cities.  There may"
  "be a lot of these, so search carefully.  They may also have armies secretly"
  "in reserve - watch out for surprise invasions!"
)))

