/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* Initialization and random routines for the display part of xconq. */

#include "config.h"
#include "misc.h"
#include "dir.h"
#include "side.h"
#include "unit.h"
#include "map.h"
#include "X11.h"
#include "Motif.h"
#include "global.h"

/* A predicate that tests whether our display can safely be written to. */

bool active_display(Side *side) {

    return (side && side->host && side->display);
}

/* Find a unit and put it at center (or close to it) of first view.  I guess */
/* can't use put_on_screen because not enough stuff is inited yet. */

void init_curxy(Side *side) {

    Unit *unit;
    Side *loop_side;

    for_all_units(loop_side, unit) {
        if (unit->side == side) {
            side->cx = unit->x;  side->cy = unit->y;
            side->vcx = unit->x;
            side->vcy = max(unit->y, world.w2+1);
            side->vcy = min(side->vcy, (world.height-1) - world.h2);
            return;
        }
    }
    side->vcx = world.w2;  side->vcy = world.h2;
    side->cx = side->vcx;  side->cy = side->vcy;
}

/* Open display, create all the windows we'll need, do misc setup things, */
/* and initialize some globals to out-of-range values for recognition later. */

void init_display(Side *side, int argc, char *argv[]) {

    int i;

    if (Debug) printf("Will try to open display \"%s\" ...\n", side->host);

    if (!open_display(side, argc, argv)) {
	fprintf(stderr, "Display could not be opened!\n", side->host);
	exit_xconq();
    }

    create_main_window(side);

    init_colors(side);
    init_misc(side);
    init_WM(side);

    create_msg_window(side);
    create_info_window(side);
    create_unit_menu_window(side);
    create_map_window(side);

    create_world_window(side);
    create_state_window(side);
    create_clock_window(side);
    create_timemode_window(side);
    create_sides_window(side);

    fixup_windows(side);

    for (i = 0; i < MAXUTYPES; ++i) side->unitslist[i].bvec = FALSE;

    /* Flag some values as uninitialized */
    side->vcx = side->vcy = -1;
    side->lastvcx = side->lastvcy = -1;
    side->lastx = side->lasty = -1;

    if (Debug) printf("Successfully opened \"%s\"!\n", side->host);
    init_curxy(side);
    if (active_display(side)) {
        show_info(side);
        draw_all_sides(side);
        show_time(side);
        show_mode(side);
        show_state(side);
        show_map(side);
        show_world(side);
    }
}

/* The length of the printed host name is the length till the first */
/* period or the total length */

int hostlen(char str[]) {

  int len = 0;

  while ((str[len] != '.') && (str[len] != '\0')) len++;
  return len;
}

/* open displays early so that the first redraw will find the displays already up. */

int maxnamelen = 0;		/* length of longest side name+host */

void init_displays1(int argc, char *argv[]) {

    int len;
    Side *side;

    for_all_sides(side) {
	len = 8 + strlen(side->name) + 1;
	maxnamelen = max(maxnamelen,
			 len + (side->host ? hostlen(side->host) + 3 : 0));
    }
    for_all_sides(side) {
	if (side->host != NULL) {
	    init_display(side, argc, argv);
	}
    }
    flush_events();
}
