/*
 * Hmm ...
 */

#define LOCORE

#include "assym.h"


/* Interrupt handlers:

   For all interrupts.  The sprg* are used as follows:

     sprg0 - base address of the per-cpu data structure
	     This struct (well only one as only one cpu)
	     contains things like the address of the
	     kernel and interrupt stacks.
     sprg1 <- r29 <- new stack || trap addr
     sprg2 <- r30 <- cr
     sprg3 <- r31 <- trap dump area

   Following on from this:

   `traps' determine if the old mode was user then depending on this
   save using either the sp register or the above stack start
   register.

   `interrupts' check on where it was previously and then either save
   on the kernel stack (using sprg0) or the interrupt stack using
   either sp or sprg2

	*/



/* save a context in the trap frame. First dump out the urgent
   material than leave rest to function */

#define STORE_CONTEXT \
	/* make space */
	addi 31, -SIZEOF_TRAP_FRAME ; /* align? */
	/* dump urgent registers */ \
	stwcx. 30, TRAP_FRAME_CR(31) ; /* kill reservation */ \
	stw 30, TRAP_FRAME_CR(31) ; \
	mflr 30 ; \
	stw 30, TRAP_FRAME_LR(31) ; \
	bl store_remaining_context



/* handle trap, get things started than use real handler */

#define TRAP(NAME, HANDLER) \
	.align 8 ; /* on 256byte boundary */ \
	.globl NAME##_interrupt ; \
NAME##_interrupt: ; \
	\
	/* make space, record where then go to handler */ \
	mtsprg1 29 ; \
	ori 29, 0, NAME##_interrupt ; \
	mtsprg2 30 ; \
	mfcr 30 ; \
	mtsprg3 31 ; \
	b HANDLER##_handler


/* 00000 - reserved so use it for a jump around the rest */
	.align 8
entry:
	.extern start
	b start



/*****************************************************************/


	/* handle any traps (things that go onto the per thread kernel
 	   stack).

	   Entry:
		29 == interrupt address (or is that enum)
		30 == context CR
		31 == free

	   Cases:
		1. was user mode - start per thread kernel stack
		3. was kernel mode - keep on curr stack
	*/

trap_handler:
	/* sort out our memory problems */ \
	/* (reservation killed below, once have write space) */


	/* determine trap-frame to save context. Different if was in
	   user or kernel mode */
	mfsrr1 31
	addi 31, 0, MSR_PROBLEM_STATE
	cmpwi 31, 0
	beq nested_trap

first_trap:
	/* dump the context on to the top of the threads kernel stack */
	mfsprg0 31 /* fetch base address of per thread kernel stack */
	lwz 31, CPU_CURR_THREAD(31)
	lwz 31, THREAD_KERNEL_STACK(31)
	STORE_CONTEXT

	/* call trap handler then check for ast */
	mr 1, 31
	mr 3, 31
	mr 4, 29
	CALL(trap)
	mr 3, 31
	bl check_ast
	bl return_to_context

nested_trap:
	/* dump context onto existing kernel stack */
	mr 31, 1
	STORE_CONTEXT

	/* nested interrupt, just return when finished */
	mr 1, 31
	mr 3, 31
	mr 4, 29	
	bl trap /*(trap_address, trap_context)*/
	bl return_to_context
		

/*****************************************************************/


	/* handle any traps (things that go onto the per thread kernel
 	   stack).

	   Entry:
		29 == interrupt address (or is that enum)
		30 == context CR
		31 == free */

	   Cases:
		1. was user mode - save on per thread kernel call on
		   interrupt
		2. was kernel but first - start on interrupt stack
		3. was kernel not first - continue on interrupt

	*/

interrupt_handler:
	/* sort out our memory problems */ \
	/* (reservation killed below, once have write space) */


	/* determine trap-frame to save context. Different if was in
	   user or kernel mode */
	mfsrr1 31
	addi 31, 0, MSR_PROBLEM_STATE
	cmpwi 31, 0
	beq kernel_interrupted

user_interrupted:
	/* dump context on per thread kernel stack */
	mfsprg0 31
	lwz 31, CPU_CURR_THREAD(31)
	lwz 31, THREAD_KERNEL_STACK(31)
	STORE_CONTEXT

	/* mark our presence on the interrupt stack */

	/* call interrupt handler on interrupt stack */
	mfsprg0 1
	lwz 1, CPU_INTERRUPT_STACK(31)
	mr 3, 31
	CALL(interrupt)

	/* clear our presence on the interrupt stack */

	/* switch to user stack/check for ast */
	lw
	mr 3, 31
	bl check_ast
	bl return_to_context


kernel_interrupted:
	/* check nesting level */
	mfspr0 31
	lwz 31, CPU_INTERRUPT_LEVEL(31)
	cmpwi 31, 0
	bne interrupt_interrupted

trap_interrupted:
	/* start kernel interrupt stack */
	mfspr0 31
	lwz 31, CPU_INTERRUPT_STACK(31)
	STORE_CONTEXT

	/* mark cpu as in an interrupt */

	/* call interrupt handler */

	/* clear membership of interrupt handler */

	/* resume */
	

interrupt_interrupted:
	/* dump context onto existing kernel stack */
	mr 31, 1
	STORE_CONTEXT

	/* nested interrupt, just return when finished */
	mr 1, 31
	mr 3, 31
	mr 4, 29	
	bl trap /*(trap_address, trap_context)*/
	bl return_to_context
		

/*****************************************************************/


/* Push a processes context onto the stack

   Entry:
	r30 - real stack
	r31 - TRAP_FRAME base address (could == r30)
	sprg1 - context r29
	sprg2 - context r30
	sprg3 - context r31
	already saved - CR, LR

   Exit:
	r31 - TRAP_FRAME base address
	r2 - real stack frame
	context saved */

store_context:
store_gprs:
	stw 0, TRAP_FRAME_GPR_0(31)
	stw 1, TRAP_FRAME_GPR_1(31)
	stw 2, TRAP_FRAME_GPR_2(31)
	stw 3, TRAP_FRAME_GPR_3(31)
	stw 4, TRAP_FRAME_GPR_4(31)
	stw 5, TRAP_FRAME_GPR_5(31)
	stw 6, TRAP_FRAME_GPR_6(31)
	stw 7, TRAP_FRAME_GPR_7(31)
	stw 8, TRAP_FRAME_GPR_8(31)
	stw 9, TRAP_FRAME_GPR_9(31)
	stw 10, TRAP_FRAME_GPR_10(31)
	stw 11, TRAP_FRAME_GPR_11(31)
	stw 12, TRAP_FRAME_GPR_12(31)
	stw 13, TRAP_FRAME_GPR_13(31)
	stw 14, TRAP_FRAME_GPR_14(31)
	stw 15, TRAP_FRAME_GPR_15(31)
	stw 16, TRAP_FRAME_GPR_16(31)
	stw 17, TRAP_FRAME_GPR_17(31)
	stw 18, TRAP_FRAME_GPR_18(31)
	stw 19, TRAP_FRAME_GPR_19(31)
	stw 20, TRAP_FRAME_GPR_20(31)
	stw 21, TRAP_FRAME_GPR_21(31)
	stw 22, TRAP_FRAME_GPR_22(31)
	stw 23, TRAP_FRAME_GPR_23(31)
	stw 24, TRAP_FRAME_GPR_24(31)
	stw 25, TRAP_FRAME_GPR_25(31)
	stw 26, TRAP_FRAME_GPR_26(31)
	stw 27, TRAP_FRAME_GPR_27(31)
	stw 28, TRAP_FRAME_GPR_28(31)
	/* finally save sprg[123] nee r{29,30,31} */
	mfspr sprg1, 0
	stw 0, TRAP_FRAME_GPR_29(31)
	mfspr sprg2, 0
	stw 0, TRAP_FRAME_GPR_30(31)
	mfspr sprg3, 0
	stw 0, TRAP_FRAME_GPR_31(31)
	
store_fpr:
	stfd 0, TRAP_FRAME_FPR_0(31)
	stfd 1, TRAP_FRAME_FPR_1(31)
	stfd 2, TRAP_FRAME_FPR_2(31)
	stfd 3, TRAP_FRAME_FPR_3(31)
	stfd 4, TRAP_FRAME_FPR_4(31)
	stfd 5, TRAP_FRAME_FPR_5(31)
	stfd 6, TRAP_FRAME_FPR_6(31)
	stfd 7, TRAP_FRAME_FPR_7(31)
	stfd 8, TRAP_FRAME_FPR_8(31)
	stfd 9, TRAP_FRAME_FPR_9(31)
	stfd 10, TRAP_FRAME_FPR_10(31)
	stfd 11, TRAP_FRAME_FPR_11(31)
	stfd 12, TRAP_FRAME_FPR_12(31)
	stfd 13, TRAP_FRAME_FPR_13(31)
	stfd 14, TRAP_FRAME_FPR_14(31)
	stfd 15, TRAP_FRAME_FPR_15(31)
	stfd 16, TRAP_FRAME_FPR_16(31)
	stfd 17, TRAP_FRAME_FPR_17(31)
	stfd 18, TRAP_FRAME_FPR_18(31)
	stfd 19, TRAP_FRAME_FPR_19(31)
	stfd 20, TRAP_FRAME_FPR_20(31)
	stfd 21, TRAP_FRAME_FPR_21(31)
	stfd 22, TRAP_FRAME_FPR_22(31)
	stfd 23, TRAP_FRAME_FPR_23(31)
	stfd 24, TRAP_FRAME_FPR_24(31)
	stfd 25, TRAP_FRAME_FPR_25(31)
	stfd 26, TRAP_FRAME_FPR_26(31)
	stfd 27, TRAP_FRAME_FPR_27(31)
	stfd 28, TRAP_FRAME_FPR_28(31)
	stfd 29, TRAP_FRAME_FPR_29(31)
	stfd 30, TRAP_FRAME_FPR_30(31)
	stfd 31, TRAP_FRAME_FPR_31(31)

store_fpcsr:
	/* while fscsr is 32bits, we store 64 to avoid conversion */
	mffs /*fr*/0
	stfd 0, TRAP_FRAME_FPCSR(31)
	
/* other random registers */
/* FIXME - what about the 601 MX */

store_ctr:
	mfctr 0
	stw 0, TRAP_FRAME_CTR(31)
store_xer:
	mfxer 0
	stw 0, TRAP_FRAME_XER(31)
store_pc:
	mfsrr0 0
	stw 0, TRAP_FRAME_PC(31)
store_msr:
	mfsrr1 0
	stw 0, TRAP_FRAME_MSR(31)

context_stored:
	blr


/*****************************************************************/

/* Entry:
	r31 - base of TRAP_FRAME
   Exit: never exits
	reti - all registers are restored */

return_to_context:

	/* absolutly guarentee that interrupts are disabled */
	mfmsr 0
	ori 0, 0, MSR_EXTERNAL_INTERRUPT_ENABLE
	xori 0, 0, MSR_EXTERNAL_INTERRUPT_ENABLE

	/* mark our status as non recoverable */
	xori 0, 0, MSR_RECOVERABLE_INTERRUPT
	mtmsr 0 /* no sync required? */

	/* discard any outstanding reservations (paranoid) */
	lwz, TRAP_FRAME_MSR(31)
	stwcx. TRAP_FRAME_MSR(31)
	
/* special registers first */
load_msr:
	/* see above: lwz 0, TRAP_FRAME_MSR(31) */
	mtsrr1 0
load_pc:
	lwz 0, TRAP_FRAME_PC(31)
	mtsrr0 0
load_xer:
	lwz 0, TRAP_FRAME_XER(31)
	mtxer 0
load_ctr:
	lwz 0, TRAP_FRAME_CTR(31)
	mtctr 0

/* wierd fp status register */
load_fpcsr:
	lfd 0, TRAP_FRAME_FPCSR(31)
	mtfsf 0xff, 0 /* replace all bits of FPCSR */

load_fpr:
	lfd 0, TRAP_FRAME_FPR_0(31)
	lfd 1, TRAP_FRAME_FPR_1(31)
	lfd 2, TRAP_FRAME_FPR_2(31)
	lfd 3, TRAP_FRAME_FPR_3(31)
	lfd 4, TRAP_FRAME_FPR_4(31)
	lfd 5, TRAP_FRAME_FPR_5(31)
	lfd 6, TRAP_FRAME_FPR_6(31)
	lfd 7, TRAP_FRAME_FPR_7(31)
	lfd 8, TRAP_FRAME_FPR_8(31)
	lfd 9, TRAP_FRAME_FPR_9(31)
	lfd 10, TRAP_FRAME_FPR_10(31)
	lfd 11, TRAP_FRAME_FPR_11(31)
	lfd 12, TRAP_FRAME_FPR_12(31)
	lfd 13, TRAP_FRAME_FPR_13(31)
	lfd 14, TRAP_FRAME_FPR_14(31)
	lfd 15, TRAP_FRAME_FPR_15(31)
	lfd 16, TRAP_FRAME_FPR_16(31)
	lfd 17, TRAP_FRAME_FPR_17(31)
	lfd 18, TRAP_FRAME_FPR_18(31)
	lfd 19, TRAP_FRAME_FPR_19(31)
	lfd 20, TRAP_FRAME_FPR_20(31)
	lfd 21, TRAP_FRAME_FPR_21(31)
	lfd 22, TRAP_FRAME_FPR_22(31)
	lfd 23, TRAP_FRAME_FPR_23(31)
	lfd 24, TRAP_FRAME_FPR_24(31)
	lfd 25, TRAP_FRAME_FPR_25(31)
	lfd 26, TRAP_FRAME_FPR_26(31)
	lfd 27, TRAP_FRAME_FPR_27(31)
	lfd 28, TRAP_FRAME_FPR_28(31)
	lfd 29, TRAP_FRAME_FPR_29(31)
	lfd 30, TRAP_FRAME_FPR_30(31)
	lfd 31, TRAP_FRAME_FPR_31(31)

load_gprs:
	/* load r29, 30, 31 into sprg */
	lwz 0, TRAP_FRAME_GPR_29(31)
	mtsprg1 0
	lwz 0, TRAP_FRAME_GPR_30(31)
	mtsprg2 0
	lwz 0, TRAP_FRAME_GPR_31(31)
	mtsprg3 0
	/* now the rest */
	lwz 0, TRAP_FRAME_GPR_0(31)
	lwz 1, TRAP_FRAME_GPR_1(31)
	lwz 2, TRAP_FRAME_GPR_2(31)
	lwz 3, TRAP_FRAME_GPR_3(31)
	lwz 4, TRAP_FRAME_GPR_4(31)
	lwz 5, TRAP_FRAME_GPR_5(31)
	lwz 6, TRAP_FRAME_GPR_6(31)
	lwz 7, TRAP_FRAME_GPR_7(31)
	lwz 8, TRAP_FRAME_GPR_8(31)
	lwz 9, TRAP_FRAME_GPR_9(31)
	lwz 10, TRAP_FRAME_GPR_10(31)
	lwz 11, TRAP_FRAME_GPR_11(31)
	lwz 12, TRAP_FRAME_GPR_12(31)
	lwz 13, TRAP_FRAME_GPR_13(31)
	lwz 14, TRAP_FRAME_GPR_14(31)
	lwz 15, TRAP_FRAME_GPR_15(31)
	lwz 16, TRAP_FRAME_GPR_16(31)
	lwz 17, TRAP_FRAME_GPR_17(31)
	lwz 18, TRAP_FRAME_GPR_18(31)
	lwz 19, TRAP_FRAME_GPR_19(31)
	lwz 20, TRAP_FRAME_GPR_20(31)
	lwz 21, TRAP_FRAME_GPR_21(31)
	lwz 22, TRAP_FRAME_GPR_22(31)
	lwz 23, TRAP_FRAME_GPR_23(31)
	lwz 24, TRAP_FRAME_GPR_24(31)
	lwz 25, TRAP_FRAME_GPR_25(31)
	lwz 26, TRAP_FRAME_GPR_26(31)
	lwz 27, TRAP_FRAME_GPR_27(31)
	lwz 28, TRAP_FRAME_GPR_28(31)

/* finally all that junk that is avoided by save context */
load_cr_lr:
	lwz 30, TRAP_FRAME_GPR_CR
	mtcrf 0xff, 30
	lwz 30, TRAP_FRAME_LR
	mtlr 30

load_29_30_31:
	mfsprg1 29
	mfsprg2 30
	mfsprg3 31
	/* back to previous mode */
	rfi
