/* Test the time base registers. In PSIM, the time base is incremented
   once every clock tick */

/* WARNING: You can't properly debug this code with GDB.  Single
   stepping double increments the time base register */

#include "../lib/oea_pal.h"

.globl catch
catch:
.globl main
main:


/* Test 1: Simple increment */

	# test = 1
	li 3, 1

	# tbu:tbl = 0:0
	li 4, 0
	li 5, 0

	# count = 1000
	li 0, 1000
	mtctr 0

	# ans = 1000+2
	li 6, 0
	li 7, 1002

	bl trial


/* Test 2: carry between low and high */

	# test = 2
	li 3, 2

	# tbu:tbl = 1:0xfffffff0
	li 4, 1
	li 0, 0
	addi 5, 0, -16

	# count = 32
	li 0, 32
	mtctr 0

	# ans = 2:16+2
	li 6, 2
	li 7, 18

	bl trial


/* Test 3: Carry between high and low */

	# test = 3
	li 3, 3

	# tbu:tbl = 0xffffffff:0xfffffff0
	li 0, 0
	addi 4, 0, -1
	addi 5, 0, -16

	# count = 32
	li 0, 32
	mtctr 0

	# ans = 0:16+2
	li 6, 0
	li 7, 18

	bl trial


/* All ok - exit 0 */

	li 3, 0
	b exit


/* LIBRARY FUNCTIONS */


/* TRIAL: Run test nr R3 by setting tbr to R4:R5.  Looping for
	  CTR and then comparing tbr against R6:R7 */
   
trial:
	/* set TBR being careful to force tbl to 0 so as to avoid
	   potential overflow into tbu */
	li 0, 0		
	mttbl 0
	mttbu 4
	mttbl 5

	/* wait the required time */
trial_loop:
	bdnz trial_loop

	/* grab back the time base being careful to handle
	   it changing during the read */
trial_read:
	mftbu 4
	mftb 5
	mftbu 0
	cmpw 4, 0
	bne trial_read

	/* Compare the time base with what was expected */
	cmpw 4, 6
	bne exit
	cmpw 5, 7
	bne exit
	blr


/* EXIT: the program by writing the status (found in r3) to the halt
         device */

exit:
	addis 4, 0, ((OEA_DEV + PAL_RESET) >> 16)
	ori 4, 4, ((OEA_DEV + PAL_RESET) & 0xffff)
	stb 3, 0(4)
