/*
 * test rig for the interrupts
 */

	.text

/* simple system call interrupt */
	.globl tst_sc1
tst_sc1:
	mtmsr 3
	isync
	sc
	.globl trap_sc1
trap_sc1:


/* simple trap interrupt */
	.globl tst_trap1
tst_trap1:
	mtmsr 3
	isync
	.globl trap_trap1
trap_trap1:
	trap /* tw 31, 0, 0 */


/* a simple floating point instruction */
	.data
	.align 3
fp_zero: .long 0 ; .long 0

	.text
	.globl tst_fp1
tst_fp1:
	/* 3==msr, 4==addr */
	mtmsr 3
	isync
	.globl trap_fp1_load
trap_fp1_load:
	lfd 0, 0(4)
	lfd 1, 0(4)
	.globl trap_fp1_assist
trap_fp1_assist:
	fctiw 0, 1 /* NOTE - need to find a more unusual insn */
	.globl trap_fp1_trap
trap_fp1_trap:
	trap


/* illegal instruction */
	.globl tst_ill1
tst_ill1:
	mtmsr 3
	isync
	.globl trap_ill1
trap_ill1:
	.long 0


/* privliged instruction */
	.globl tst_priv1
tst_priv1:
	mtmsr 3
	isync
	.globl trap_priv1_priv
trap_priv1_priv:
	mfmsr 3
	.globl trap_priv1_ok
trap_priv1_ok:
	trap


/* a simple store! */
	.globl tst_store
tst_store:
	mtmsr 3
	isync
	.globl trap_store
	nop
trap_store:
	stw 4, 0(5)
	.globl trap_store_ok
trap_store_ok:
	trap


/* decrementer interrupt test */
	.globl tst_dec
tst_dec:
	mtmsr 3
	nop
	isync
	.globl trap_dec_mtdec_1
trap_dec_mtdec_1: mtdec 4
	.globl trap_dec_1
trap_dec_1: nop
	.globl trap_dec_2
trap_dec_2: nop
	.globl trap_dec_3
trap_dec_3: nop
	.globl trap_dec_4
trap_dec_4: nop
	.globl trap_dec_5
trap_dec_5: nop
	.globl trap_dec_6
trap_dec_6: nop
	.globl trap_dec_7
trap_dec_7: nop
	.globl trap_dec_8
trap_dec_8: nop
	.globl trap_dec_9
trap_dec_9: nop
	.globl trap_dec_a
trap_dec_a: nop
	.globl trap_dec_b
trap_dec_b: nop
	.globl trap_dec_c
trap_dec_c: nop
	.globl trap_dec_d
trap_dec_d: nop
	.globl trap_dec_e
trap_dec_e: nop
	.globl trap_dec_f
trap_dec_f: nop
	.globl trap_dec_mtmsr_2
trap_dec_mtmsr_2: mtmsr 5
	.globl trap_dec_nop_2
trap_dec_nop_2:	nop
	.globl trap_dec_isync_2
trap_dec_isync_2: isync
	.globl trap_dec_mtdec_2
trap_dec_mtdec_2: mtdec 6
	.globl trap_dec_trap
trap_dec_trap: trap


/* SMP/ICU test */
	.globl tst_smpee
tst_smpee:
	mtmsr 3
	.globl tst_smpee_msr
tst_smpee_msr:
	isync
	sth 4, 0(5)
	.globl tst_smpee_idle
tst_smpee_idle:
	b tst_smpee_idle

	.globl trap_smpee
trap_smpee:
	mfmsr 0
	ori 0, 0, 0x8000
	mtmsr 0		# no sync (p486)
	.globl trap_smpee_idle
trap_smpee_idle:
	b trap_smpee_idle
