void
write_string(char *str)
{
  int length;
  /* get the strings length */
  for (length = 0; str[length] != '\0'; length++);
  write (1, str, length);
}

void
write_unsigned(unsigned val)
{
  int pos;
  char digits[25]; /* is this safe */

  pos = sizeof(digits);
  do {
    pos -= 1;
    digits[pos] = (val % 10) + '0'; /* yuck */
    val = val / 10;
    /* assert number in digits[pos:sizeof(digits)-1] */
  } while (val > 0 && pos >= 0);

  write(1, digits+pos, sizeof(digits) - pos);
}

void
write_char(char ch)
{
  write (1, &ch, 1);
}

void
write_line()
{
  write(1, "\r\n", 2);
}

void
write_hex(unsigned val)
{
  int pos;
  unsigned digit;

  pos = sizeof(val) * 8;
  do {
    pos -= 4;
    digit = (val >> pos) & 0xf;
    if (digit < 10) {
      write_char(digit+'0');
    }
    else {
      write_char(digit+'a'-10);
    }
  } while (pos > 0);
}

void
write_int(int val)
{
  if (val < 0) {
    write_char('-');
    val = -val;
  }
  write_unsigned(val);
}

void
write_bcd(unsigned int bcd)
{
  int pos;
  unsigned digit;

  pos = sizeof(bcd) * 8;
  write_int((bcd >> 4) & 0xf);
  write_int(bcd & 0xf);
}
