/*
 * Copyright (c) 1995 Dale Rahn. All rights reserved.
 *
 *   
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *   This product includes software developed by Dale Rahn.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
 *   $Id: bug.h,v 1.3 1995/05/13 19:31:18 rahn Exp $
 */  

#ifndef MACHINE_BUG_H
#define MACHINE_BUG_H
typedef struct bug_dskio {
	unsigned char	 ctrl_lun;
	unsigned char	 dev_lun;
	unsigned short	 status;
	void		*pbuffer;
	unsigned long	 blk_num;
	unsigned short	 blk_cnt;
	unsigned char	 flag;
#define BUG_FILE_MARK	 0x80
#define IGNORE_FILENUM	 0x02
#define END_OF_FILE	 0x01
	unsigned char	 addr_mod;
} bug_dskio;

#ifdef NOTYET
typedef struct bug_dskcfg {
}
#endif

struct bug_brdid {
	unsigned char	eye[4];
	unsigned char	rev;
	unsigned char	month;
	unsigned char	day;
	unsigned char	year;
	unsigned short	pkt_sz;
	unsigned short	reserved;
	unsigned short	brd_num;
	char		brd_suff[2];
	unsigned int	options;
	unsigned short	ctr_lun;
	unsigned short	dev_lun;
	unsigned short	dev_type;
	unsigned short	dev_num;
	void		*pssid ;
};
struct bug_time {
	unsigned char year_BCD;
	unsigned char month_BCD;
	unsigned char day_BCD;
	unsigned char wday_BCD;
	unsigned char hour_BCD;
	unsigned char min_BCD;
	unsigned char sec_BCD;
	unsigned char cal_BCD;
};
struct bugargs {
	unsigned int	dev_lun;
	unsigned int  ctrl_lun;
	unsigned int	flags;
	unsigned int  ctrl_addr;
	unsigned int	entry;
	unsigned int	conf_blk;
	char *arg_start;
	char *arg_end;
};
char bug_inchr();
int bug_instat();
void bug_outchr(char a);
void bug_outstr(char *pstrb, char *pstre);
void bug_outln(char *pstrb, char *pstre);
int bug_diskrd(bug_dskio *arg);
int bug_diskwr(bug_dskio *arg);
void bug_delay(int delay_msec);
void bug_return();
void bug_exit(int status); /*NOTE: The real bug does not have this */
struct bug_brdid *bug_brdid();
void bug_rtc_rd(struct bug_time *ptime);
void bug_stat();

#endif /* MACHINE_BUG_H */
