#include "../lib/of1275.h"
#include "opic.h"

void
timeout(int count,
	unsigned *target,
	unsigned value)
{
  while (count > 0 && *target == value)
    count --;
  if (count <= 0) {
    write_string("timeout");
    write_line();
    exit(1);
  }
}


int
main()
{
  
  int i;
  opic_descriptor opic;

  opic_parse_args(&opic, 0);

  /* set the timer frequencey register */
  opic.global->timer_frequence_reporting.reg = htovl(2);
  if (vtohl(opic.global->timer_frequence_reporting.reg) != 2) {
    write_string("Timer frequencey reg invalid");
    write_line();
  }

  /* program up timer interrupts */
  for (i = 0; i < nr_timers; i++) {
    opic.global->timer[i].vector_priority.reg =
      htovl(((i + 1) << 16)
	    | (i + 1));
    opic.global->timer[i].destination.reg = htovl(-1);
  }

  /* enable delivery */
  opic.per_processor[0].current_task_priority.reg = htovl(0);


  /* start then stop each timer, check that they changed */

  for (i = 0; i < nr_timers; i++) {
    unsigned old_count;
    unsigned new_count;
    opic.global->timer[i].base_count.reg = htovl(0x80000000); /* freeze? */
    old_count = opic.global->timer[i].current_count.reg;
    opic.global->timer[i].base_count.reg = htovl(0x10000000); /* some number */

    new_count = opic.global->timer[i].current_count.reg;
    if (old_count == new_count) {
      write_string("timer ");
      write_int(i);
      write_string(" did not change");
      write_line();
      exit(1);
    }

    old_count = new_count;
    new_count = opic.global->timer[i].current_count.reg;
    if (old_count == new_count) {
      write_string("timer ");
      write_int(i);
      write_string(" does not decrement");
      write_line();
      exit(1);
    }
    if (old_count < new_count) {
      write_string("timer ");
      write_int(i);
      write_string(" increments!");
      write_line();
      exit(1);
    }


    opic.global->timer[i].base_count.reg = htovl(0x80000000); /* freeze */
    old_count = new_count;
    new_count = opic.global->timer[i].current_count.reg;
    if (old_count <= new_count) {
      write_string("timer ");
      write_int(i);
      write_string(" went backwards when frozen");
      write_line();
      exit(1);
    }
    old_count = new_count;
    new_count = opic.global->timer[i].current_count.reg;
    if (old_count != new_count) {
      write_string("timer ");
      write_int(i);
      write_string(" did not refreeze");
      write_line();
      exit(1);
    }

  }


  /* get each timer to generate an interrupt */

  for (i = 0; i < nr_timers; i++) {
    int j;

    /* set up an interrupt */
    opic.global->timer[i].base_count.reg = htovl(0x80000000); /* freeze? */
    opic.global->timer[i].base_count.reg = htovl(0x1000); /* some number */
    
    for (j = 0; j < 2; j++) {

      /* wait for the interrupt */
      timeout(1000, &opic.output[0], 0);

      /* check delivered */
      if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != i + 1) {
	write_string("bad ack for ");
	write_int(i);
	write_line();
	exit (1);
      }

      /* check pending cleared */
      if (htonl(opic.output[0]) != 0) {
	write_string("pending interrupt ");
	write_int(i);
	write_string(" not cleared");
	write_line();
	exit (1);
      }
      
      /* end it */
      opic.per_processor[0].end_of_interrupt.reg = 0;
      
      /* wait for the second interrupt */
      timeout(1000, &opic.output[0], 0);
      
      /* check delivered */
      if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != i + 1) {
	write_string("bad ack for ");
	write_int(i);
	write_line();
	exit (1);
      }
      
      /* check pending cleared */
      if (htonl(opic.output[0]) != 0) {
	write_string("pending interrupt ");
	write_int(i);
	write_string(" not cleared");
	write_line();
	exit (1);
      }
      
      /* end it */
      opic.per_processor[0].end_of_interrupt.reg = 0;
      
    }

    /* freeze the timer */
    opic.global->timer[i].base_count.reg = htovl(0x80000000); /* freeze? */
    
  }



  exit (0);


}
