#include "../lib/of1275.h"
#include "opic.h"

int
main()
{
  
  int i;
  opic_descriptor opic;

  opic_parse_args(&opic, 0);

  /* program up interrupt source zero */
  for (i = 0; i < opic.nr_inputs; i++) {
    opic.interrupt_source_configuration[i].vector_priority.reg = 
      htovl(level_triggered | positive_polarity | ((i + 1) << 16) | (i + 1));
    opic.interrupt_source_configuration[i].destination.reg = htovl(-1);
  }

  /* and the spurious vector */
  opic.global->spurious_vector.reg = htovl(254);


  /* enable interrupts */
  opic.per_processor[0].current_task_priority.reg = htovl(0);


  /* Stimulate the next interrupt once the previous has been ack'ed
     but not eoi'd - forces the use of the interrupt stack */

  for (i = 0; i < opic.nr_inputs; i++) {

    /* pend interrupt */
    opic.input[i] = htonl(1);

    /* check pending */
    if (htonl(opic.output[0]) == 0) {
      write_string("no pending interrupt ");
      write_int(i);
      write_line();
      exit (1);
    }

    /* check delivered */
    if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != i + 1) {
      write_string("bad ack for ");
      write_int(i);
      write_line();
      exit (1);
    }

    /* check pending cleared */
    if (htonl(opic.output[0]) != 0) {
      write_string("pending interrupt ");
      write_int(i);
      write_string(" not cleared");
      write_line();
      exit (1);
    }

  }

  /* ack everything */
  for (i = opic.nr_inputs - 1; i >= 0; i--) {

    /* clear pending */
    opic.input[i] = htonl(0);

    /* ack the just cleared */
    opic.per_processor[0].end_of_interrupt.reg = 0;

    /* check nothing pending */
    if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != 254) {
      write_string("interrupt still pending");
      write_line();
      exit (1);
    }
  }


  exit (0);
}
