#define LINE \
do { \
  write_string(__FILE__); \
  write_string(":"); \
  write_int(__LINE__); \
  write_string(": "); \
} while (0)

/* NOTE: All registers are little endian. Use the vtohs() and htovl()
   functions. */

typedef struct _opic_reg {
  unsigned reg;
  char padding[0x0C];
} opic_reg;


typedef struct _opic_interrupt_source_configuration_reg {
  opic_reg vector_priority;
  opic_reg destination;
} opic_interrupt_source_configuration_reg;


typedef struct _opic_per_processor_reg {
  char padding_0x00[0x40];
  opic_reg interprocessor_interrupt_dispatch[4]; /* 0x40 - 0x70 */
  opic_reg current_task_priority; /* 0x80 */
  char padding_0x90[0x10];
  opic_reg interrupt_acknowledge; /* 0xA0 */
  opic_reg end_of_interrupt; /* 0xB0 */
  char padding_0xC0[0xF40];
} opic_per_processor_reg;


typedef struct _opic_timer_reg {
  opic_reg current_count;
  opic_reg base_count;
  opic_reg vector_priority;
  opic_reg destination;
} opic_timer_reg;


typedef struct _opic_global_reg {
  opic_reg feature_reporting[2]; /* 0x00 */
  opic_reg global_configuration; /* 0x20 */
  opic_reg padding_0x30[5];
  opic_reg vendor_identification; /* 0x80 */
  opic_reg processor_init; /* 0x90 */
  opic_reg ipi_vector_priority[4]; /* 0xA0 */
  opic_reg spurious_vector; /* 0xE0 */
  opic_reg timer_frequence_reporting; /* 0xF0 */
  opic_timer_reg timer[4]; /* 0x100 */
} opic_global_reg;



typedef struct _opic_descriptor {
  char path[128];

  /* the OPIC */
  void *address;

  /* the input testing glue */
  unsigned *input;
  int nr_inputs;

  /* the output testing glue */
  unsigned *output;
  int nr_outputs;

  /* the reset pins */
  unsigned *init;
  int nr_inits;

  /* the opic registers abstracted out */
  opic_global_reg *global;
  opic_per_processor_reg *per_processor;
  opic_interrupt_source_configuration_reg *interrupt_source_configuration;

} opic_descriptor;

extern void opic_parse_args(opic_descriptor *opic, int verbose);


enum {
  level_triggered =  0x00400000,
  positive_polarity = 0x00800000,
};

enum {
  nr_timers = 4,
  nr_ipi = 4,
};
