/* erase the entire eeprom */

#include "eeprom.h"


char data[] = { 0xee, 0x55 };

int
main()
{
  int i;
  eeprom_args eeprom;
  int ihandle;
  int status;
  unsigned address = 0x1234;

  parse_eeprom_args(&eeprom);

  /* open it up */
  if (of1275_open(eeprom.path, &ihandle) < 0) {
    write_string("Failed to open eeprom");
    write_line();
    exit(1);
  }

  /* seek to an arbitrary offset */
  of1275_seek(ihandle, 0, address, &status);

  /* write a new value */
  of1275_write(ihandle, data, sizeof(data), &status);

  /* verify it */
  of1275_seek(ihandle, 0, address, &status);
  for (i = 0; i < sizeof(data); i++) {
    char byte;
    write_string("0x");
    write_hex(address+i);
    write_string(": ");
    of1275_read(ihandle, &byte, sizeof(byte), &status);
    if (byte != data[i]) {
      write_string("read bad");
      write_line();
      exit(1);
    }
    if (eeprom.memory[address + i] != data[i]) {
      write_string("peek bad");
      write_line();
      exit(1);
    }
    write_string("ok");
    write_line();
  }

  exit(0);
}
