/* erase the entire eeprom */

#include "eeprom.h"

static int sectors[] = {
  0, 3, 7, -1,
};


int
main()
{
  int i;
  int last_sector;
  eeprom_args eeprom;
  parse_eeprom_args(&eeprom);

  /* write the erase sector sequence */
  last_sector = -1;
  for (i = 0; sectors[i] >= 0; i++) {
    unsigned sector = sectors[i] * eeprom.sector_size;
    if (erase_sector(&eeprom, last_sector, sector) != erase_sector_ok) {
      write_string("Missed sector window");
      write_line();
      exit (1);
    }
    last_sector = sector;
  }

  /* now miss the erase window */
  while ((eeprom.memory[last_sector] & 0xa8) == 0x0);
  if (erase_sector(&eeprom, -1, last_sector) != erase_sector_window_closed) {
    write_string("Window should have been closed");
    write_line();
    exit(1);
  }

  /* wait for it to finish */
  for (i = 0; i < eeprom.erase_delay; i++) {
    if ((eeprom.memory[last_sector] & 0x80) == 0x80) {
      int sector;
      for (sector = 0; sector < eeprom.nr_sectors; sector++) {
	int byte;
	int erased = 0;
	int k;
	for (k = 0; sectors[k] >= 0; k++) {
	  if (sector == sectors[k])
	    erased = 1;
	}
	write_string("checking sector ");
	write_int(sector);
	write_string(erased ? " erased" : " zero");
	write_line();
	for (byte = 0; byte < eeprom.sector_size; byte += sizeof(int)) {
	  int address = sector * eeprom.sector_size + byte;
	  int memory = *(int*)(eeprom.memory + address);
	  if (erased && memory != -1) {
	    write_string("byte 0x");
	    write_hex(address);
	    write_string(" should be erased");
	    write_line();
	    exit(1);
	  }
	  else if (!erased && memory != 0x00) {
	    write_string("byte 0x");
	    write_hex(address);
	    write_string(" should be zero");
	    write_line();
	    exit(1);
	  }
	}
      }
      write_string("Chip erased after ");
      write_int(i);
      write_string(" iterations");
      write_line();
      exit(0);
    }
  }

  write_string("erase-sector timed out");
  write_line();
  exit(1);
}
