#include "../lib/of1275.h"

typedef struct _heap_entry {
  unsigned int address;
  unsigned int size;
} heap_entry;

typedef struct _heap {
  int nr_entries;
  heap_entry entry[10];
} heap;

heap available;

void
get_available()
{
  int memory_phandle;
  /* find the chosen memory devices phandle */
  {
    int chosen_phandle;
    int memory_ihandle;
    int size;
    of1275_finddevice("/chosen", &chosen_phandle);
    of1275_getprop(chosen_phandle, "memory", &memory_ihandle,
		   sizeof(memory_ihandle), &size);
    memory_ihandle = ntohl(memory_ihandle);
    of1275_instance_to_package(memory_ihandle, &memory_phandle);
  }
  /* determine how big the actual property is */
  {
    int available_size;
    of1275_getproplen(memory_phandle, "available", &available_size);
    available.nr_entries = available_size / sizeof(available.entry[0]);
    if (available_size > sizeof(available.entry)) {
      write_string("get_available: heap overflow");
      write_line();
      exit(1);
    }
  }
  /* bring the property in */
  {
    int size;
    int i;
    of1275_getprop(memory_phandle, "available",
		   &available.entry, sizeof(available.entry),
		   &size);
    for (i = 0; i < available.nr_entries; i++) {
      available.entry[i].address = ntohl(available.entry[i].address);
      available.entry[i].size = ntohl(available.entry[i].size);
    }
  }
}

void
print_available()
{
  int i;
  write_string(" i    address     size");
  write_line();
  for (i = 0; i < available.nr_entries; i++) {
    write_string(" ");
    write_int(i);
    write_string(": 0x");
    write_hex(available.entry[i].address);
    write_string(" 0x");
    write_hex(available.entry[i].size);
    write_line();
  }
}


main()
{
  /* start things off */
  write_string("Initial available:");
  write_line();
  get_available();
  print_available();
  /* now try a simple alloc */
  /* ???? */
  /* and finished */
  return 0;
}
