/*
 * tools/lib/vg_check_name.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March-May 1997
 * January,May,June,September 1998
 * January,May 1999
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    11/01/1998 - seperated from previous vg_name.c
 *    12/02/1998 - changed for free volume group names
 *    12/05/1998 - avoided checking vg_name against LVM_PV_NEW
 *    27/05/1998 - checking vg_name against EXPORTED
 *    06/06/1998 - checking vg_name against EXPORTED was an error
 *                 for vgexport
 *    06/09/1998 - checked VG characters with new lvm_check_chars()
 *    26/01/1999 - made volume group directory prefix a preprocessor option
 *    17/05/1999 - checked for invalid "." and ".." VG name
 *    08/02/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int vg_check_name ( char *vg_name) {
   int length = 0;
   int ret = 0;

#ifdef DEBUG
   debug_enter ( "vg_check_name -- CALLED\n");
#endif

   if ( vg_name == NULL) ret = -LVM_EPARAM;
   else {
#ifdef DEBUG
      debug ( "vg_check_name -- vg_name: \"%s\"\n", vg_name);
#endif

      length = sizeof ( LVM_DIR_PREFIX) - 1;
      if ( strncmp ( vg_name, LVM_DIR_PREFIX, length) == 0)
         strcpy ( vg_name, &vg_name[length]);

      if ( strlen ( vg_name) > NAME_LEN - sizeof ( LVM_DIR_PREFIX) - 1 ||
           lvm_check_chars ( vg_name) < 0 ||
           strchr ( vg_name, '/') != NULL ||
           strlen ( vg_name) > ( NAME_LEN / 2) ||
           strcmp ( vg_name, ".") == 0 ||
           strcmp ( vg_name, "..") == 0) ret = -LVM_EVG_CHECK_NAME;
   }

#ifdef DEBUG
   debug_leave ( "vg_check_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
