/*
 * tools/lib/pv_copy.c
 *
 * Copyright (C)  1998 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * August 1998
 * July 1999
 * January,March 2000
 * July 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    27/07/1999 - avoided dummy[1-3] definitions
 *    03/02/2000 - use debug_enter()/debug_leave()
 *    16/03/2000 - added UUID support in pv_copy_from_disk()
 *    05/07/2000 - changed to disk macro conventione
 *
 */

#include <liblvm.h>

pv_t *pv_copy_from_disk ( pv_disk_t *pv_disk) {
   pv_t *pv_tmp = NULL;

#ifdef DEBUG
   debug_enter ( "pv_copy_from_disk -- CALLED\n");
#endif
   if ( pv_disk != NULL && ( pv_tmp = malloc ( sizeof ( pv_t))) != NULL) {
      memset ( pv_tmp, 0,  sizeof ( pv_t));
      strncpy ( pv_tmp->id, pv_disk->id, sizeof ( pv_tmp->id));
      pv_tmp->version = LVM_TO_CORE32 ( pv_disk->version);
      pv_tmp->pv_on_disk.base = LVM_TO_CORE32 ( pv_disk->pv_on_disk.base);
      pv_tmp->pv_on_disk.size = LVM_TO_CORE32 ( pv_disk->pv_on_disk.size);
      pv_tmp->vg_on_disk.base = LVM_TO_CORE32 ( pv_disk->vg_on_disk.base);
      pv_tmp->vg_on_disk.size = LVM_TO_CORE32 ( pv_disk->vg_on_disk.size);
      pv_tmp->pv_uuidlist_on_disk.base =
         LVM_TO_CORE32 ( pv_disk->pv_uuidlist_on_disk.base);
      pv_tmp->pv_uuidlist_on_disk.size =
         LVM_TO_CORE32 ( pv_disk->pv_uuidlist_on_disk.size);
      pv_tmp->lv_on_disk.base = LVM_TO_CORE32 ( pv_disk->lv_on_disk.base);
      pv_tmp->lv_on_disk.size = LVM_TO_CORE32 ( pv_disk->lv_on_disk.size);
      pv_tmp->pe_on_disk.base = LVM_TO_CORE32 ( pv_disk->pe_on_disk.base);
      pv_tmp->pe_on_disk.size = LVM_TO_CORE32 ( pv_disk->pe_on_disk.size);
      memset  ( pv_tmp->pv_name, 0, sizeof ( pv_tmp->pv_name));
      memset  ( pv_tmp->pv_uuid, 0, sizeof ( pv_tmp->pv_uuid));
      memcpy ( pv_tmp->pv_uuid, pv_disk->pv_uuid, UUID_LEN);
      strncpy ( pv_tmp->vg_name, pv_disk->vg_name, sizeof ( pv_tmp->vg_name));
      strncpy ( pv_tmp->system_id, pv_disk->system_id,
                sizeof ( pv_tmp->system_id));
      pv_tmp->pv_dev = LVM_TO_CORE32 ( pv_disk->pv_major);
      pv_tmp->pv_number = LVM_TO_CORE32 ( pv_disk->pv_number);
      pv_tmp->pv_status = LVM_TO_CORE32 ( pv_disk->pv_status);
      pv_tmp->pv_allocatable = LVM_TO_CORE32 ( pv_disk->pv_allocatable);
      pv_tmp->pv_size = LVM_TO_CORE32 ( pv_disk->pv_size);
      pv_tmp->lv_cur = LVM_TO_CORE32 ( pv_disk->lv_cur);
      pv_tmp->pe_size = LVM_TO_CORE32 ( pv_disk->pe_size);
      pv_tmp->pe_total = LVM_TO_CORE32 ( pv_disk->pe_total);
      pv_tmp->pe_allocated = LVM_TO_CORE32 ( pv_disk->pe_allocated);
      pv_tmp->pe_stale = 0;
      pv_tmp->pe = NULL;
      pv_tmp->inode = NULL;
   }

#ifdef DEBUG
   debug_leave ( "pv_copy_from_disk -- LEAVING\n");
#endif
   return pv_tmp;
}


pv_disk_t *pv_copy_to_disk ( pv_t *pv_core) {
   pv_disk_t *pv_disk_tmp = NULL;

#ifdef DEBUG
   debug_enter ( "pv_copy_to_disk -- CALLED\n");
#endif
   if ( pv_core != NULL &&
        ( pv_disk_tmp = malloc ( sizeof ( pv_disk_t))) != NULL) {
      memset ( pv_disk_tmp, 0,  sizeof ( pv_disk_t));
      strncpy ( pv_disk_tmp->id, pv_core->id, sizeof ( pv_disk_tmp->id));
      pv_disk_tmp->version = LVM_TO_DISK32 ( pv_core->version);
      pv_disk_tmp->pv_on_disk.base = LVM_TO_DISK32 ( pv_core->pv_on_disk.base);
      pv_disk_tmp->pv_on_disk.size = LVM_TO_DISK32 ( pv_core->pv_on_disk.size);
      pv_disk_tmp->vg_on_disk.base = LVM_TO_DISK32 ( pv_core->vg_on_disk.base);
      pv_disk_tmp->vg_on_disk.size = LVM_TO_DISK32 ( pv_core->vg_on_disk.size);
      pv_disk_tmp->pv_uuidlist_on_disk.base =
         LVM_TO_DISK32 ( pv_core->pv_uuidlist_on_disk.base);
     pv_disk_tmp->pv_uuidlist_on_disk.size =
         LVM_TO_DISK32 ( pv_core->pv_uuidlist_on_disk.size);
      pv_disk_tmp->lv_on_disk.base = LVM_TO_DISK32 ( pv_core->lv_on_disk.base);
      pv_disk_tmp->lv_on_disk.size = LVM_TO_DISK32 ( pv_core->lv_on_disk.size);
      pv_disk_tmp->pe_on_disk.base = LVM_TO_DISK32 ( pv_core->pe_on_disk.base);
      pv_disk_tmp->pe_on_disk.size = LVM_TO_DISK32 ( pv_core->pe_on_disk.size);
      memcpy ( pv_disk_tmp->pv_uuid, pv_core->pv_uuid, UUID_LEN);
      strncpy ( pv_disk_tmp->vg_name, pv_core->vg_name,
                sizeof ( pv_disk_tmp->vg_name));
      strncpy ( pv_disk_tmp->system_id, pv_core->system_id,
                sizeof ( pv_disk_tmp->system_id));
      /* core type is kdev_t; but no matter what it is,
         only store major for check in pv_read() */
      pv_disk_tmp->pv_major = LVM_TO_DISK32 ( MAJOR ( pv_core->pv_dev));
      pv_disk_tmp->pv_number = LVM_TO_DISK32 ( pv_core->pv_number);
      pv_disk_tmp->pv_status = LVM_TO_DISK32 ( pv_core->pv_status);
      pv_disk_tmp->pv_allocatable = LVM_TO_DISK32 ( pv_core->pv_allocatable);
      pv_disk_tmp->pv_size = LVM_TO_DISK32 ( pv_core->pv_size);
      pv_disk_tmp->lv_cur = LVM_TO_DISK32 ( pv_core->lv_cur);
      pv_disk_tmp->pe_size = LVM_TO_DISK32 ( pv_core->pe_size);
      pv_disk_tmp->pe_total = LVM_TO_DISK32 ( pv_core->pe_total);
      pv_disk_tmp->pe_allocated = LVM_TO_DISK32 ( pv_core->pe_allocated);
   }

#ifdef DEBUG
   debug_leave ( "pv_copy_to_disk -- LEAVING\n");
#endif
   return pv_disk_tmp;
}
