/*
 * tools/lib/lvm_get_col_numbers.c
 *
 * Copyright (C)  1997 - 1999  Heinz Mauelshagen, Germany
 *
 * August 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>

#define	LVM_CHECK_NUMBER(a,b) \
   if ( ( a = lvm_check_number ( b, FALSE)) < 0) { \
      fprintf ( stderr, "%s -- option extend argument %s is " \
                        "no number\n\n", \
                        cmd, b); \
      return -1; \
   }


int lvm_get_col_numbers ( char *optarg, int **ptr) {
   int ext_count = 0;
   int new_count = 0;
   int start = 0;
   int end = 0;
   char *range_ptr = NULL;
   char *col_ptr = NULL;
   char *col_ptr2 = NULL;

   if ( optarg == NULL || ptr == NULL) return -LVM_EPARAM;

   if ( strchr ( optarg, ':') == NULL) {
      *ptr = NULL;
      return 0;
   }

   col_ptr = optarg;
   while ( ( col_ptr = strchr ( col_ptr, ':')) != NULL) {
      *col_ptr++ = 0;
      if ( *col_ptr != 0) {
         if ( ( col_ptr2 = strchr ( col_ptr, ':')) != NULL)
            *col_ptr2 = 0;
         if ( ( range_ptr = strchr ( col_ptr, '-')) != NULL) {
            *range_ptr++ = 0;
            LVM_CHECK_NUMBER ( start, col_ptr);
            LVM_CHECK_NUMBER ( end, range_ptr);
            if ( start < end) new_count = end - start + 2;
            else {
               fprintf ( stderr, "%s -- %s is not smaller than %s\n\n",
                                 cmd, col_ptr, range_ptr);
               return -1;
            }
            col_ptr = range_ptr;
         } else {
            new_count = 2;
            LVM_CHECK_NUMBER ( start, col_ptr);
            end = start;
         }

         if ( ( *ptr = realloc ( *ptr,
                                 ( ext_count + new_count) *
                                 sizeof ( int))) == NULL) {
            fprintf ( stderr, "%s -- realloc error "
                              "in file %s [line %d]\n\n",
                              cmd,
                              __FILE__, __LINE__);
            return -1;
         }

         while ( start <= end) (*ptr)[ext_count++] = start++;
         (*ptr)[ext_count] = -1;

         if ( col_ptr2 != NULL) *col_ptr2 = ':';
      }
   }

   return 0;
}
